package com.sinosig.client.external.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import com.sinosig.core.client.model.IJQXBJ;
import com.sinosig.client.external.config.ExternalClientProperties;
import com.sinosig.core.client.service.IJQXBJClientService;
import com.sinosig.client.external.model.JQXBJImpl;
import com.sinosig.client.external.feign.JQXBJFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import com.sinosig.util.feign.FeignRequestInterceptor;
import com.sinosig.util.SearchContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import com.sinosig.util.feign.suport.SearchContextFeignEncode;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

/**
 * 实体[JQXBJ] 服务对象接口
 */
@Service
public class JQXBJClientServiceImpl implements IJQXBJClientService {

    JQXBJFeignClient jQXBJFeignClient;

    @Autowired
    public JQXBJClientServiceImpl(Decoder decoder, Encoder encoder, Client client, Contract contract ,FeignRequestInterceptor feignRequestInterceptor,ExternalClientProperties externalClientProperties) {
        if (externalClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.jQXBJFeignClient = nameBuilder.target(JQXBJFeignClient.class,"http://"+externalClientProperties.getServiceId()+"/") ;
		}else if (externalClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.jQXBJFeignClient = nameBuilder.target(JQXBJFeignClient.class,"http://"+externalClientProperties.getServiceUrl()+"/") ;
		}
    }
    @Override
    public IJQXBJ createModel() {
		return new JQXBJImpl();
	}


    public void get(IJQXBJ jqxbj){
        IJQXBJ clientModel = jQXBJFeignClient.get(jqxbj.getJQXBJId()) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), jqxbj.getClass(), false);
        copier.copy(clientModel, jqxbj, null);
    }


    public Page<IJQXBJ> fetchDefault(SearchContext context){
        Page<JQXBJImpl> page = this.jQXBJFeignClient.fetchDefault(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }


    public Page<IJQXBJ> select(SearchContext context){
        return null ;
    }


    public void update(IJQXBJ jqxbj){
        IJQXBJ clientModel = jQXBJFeignClient.update(jqxbj.getJQXBJId(),(JQXBJImpl)jqxbj) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), jqxbj.getClass(), false);
        copier.copy(clientModel, jqxbj, null);
    }


    public void remove(IJQXBJ jqxbj){
        jQXBJFeignClient.remove(jqxbj.getJQXBJId()) ;
    }


    public void save(IJQXBJ jqxbj){
        IJQXBJ clientModel = jQXBJFeignClient.save((JQXBJImpl)jqxbj) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), jqxbj.getClass(), false);
        copier.copy(clientModel, jqxbj, null);
    }


    public void create(IJQXBJ jqxbj){
        IJQXBJ clientModel = jQXBJFeignClient.create((JQXBJImpl)jqxbj) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), jqxbj.getClass(), false);
        copier.copy(clientModel, jqxbj, null);
    }


    public void checkKey(IJQXBJ jqxbj){
        IJQXBJ clientModel = jQXBJFeignClient.checkKey((JQXBJImpl)jqxbj) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), jqxbj.getClass(), false);
        copier.copy(clientModel, jqxbj, null);
    }


    public void getDraft(IJQXBJ jqxbj){
        IJQXBJ clientModel = jQXBJFeignClient.getDraft((JQXBJImpl)jqxbj) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), jqxbj.getClass(), false);
        copier.copy(clientModel, jqxbj, null);
    }



}

