package com.sinosig.client.external.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import com.sinosig.core.client.model.ICPXH;
import com.sinosig.client.external.config.ExternalClientProperties;
import com.sinosig.core.client.service.ICPXHClientService;
import com.sinosig.client.external.model.CPXHImpl;
import com.sinosig.client.external.feign.CPXHFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import com.sinosig.util.feign.FeignRequestInterceptor;
import com.sinosig.util.SearchContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import com.sinosig.util.feign.suport.SearchContextFeignEncode;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

/**
 * 实体[CPXH] 服务对象接口
 */
@Service
public class CPXHClientServiceImpl implements ICPXHClientService {

    CPXHFeignClient cPXHFeignClient;

    @Autowired
    public CPXHClientServiceImpl(Decoder decoder, Encoder encoder, Client client, Contract contract ,FeignRequestInterceptor feignRequestInterceptor,ExternalClientProperties externalClientProperties) {
        if (externalClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.cPXHFeignClient = nameBuilder.target(CPXHFeignClient.class,"http://"+externalClientProperties.getServiceId()+"/") ;
		}else if (externalClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.cPXHFeignClient = nameBuilder.target(CPXHFeignClient.class,"http://"+externalClientProperties.getServiceUrl()+"/") ;
		}
    }
    @Override
    public ICPXH createModel() {
		return new CPXHImpl();
	}


    public void update(ICPXH cpxh){
        ICPXH clientModel = cPXHFeignClient.update(cpxh.getCPXHID(),(CPXHImpl)cpxh) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), cpxh.getClass(), false);
        copier.copy(clientModel, cpxh, null);
    }


    public Page<ICPXH> fetchDefault(SearchContext context){
        Page<CPXHImpl> page = this.cPXHFeignClient.fetchDefault(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }


    public void create(ICPXH cpxh){
        ICPXH clientModel = cPXHFeignClient.create((CPXHImpl)cpxh) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), cpxh.getClass(), false);
        copier.copy(clientModel, cpxh, null);
    }


    public void get(ICPXH cpxh){
        ICPXH clientModel = cPXHFeignClient.get(cpxh.getCPXHID()) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), cpxh.getClass(), false);
        copier.copy(clientModel, cpxh, null);
    }


    public void remove(ICPXH cpxh){
        cPXHFeignClient.remove(cpxh.getCPXHID()) ;
    }


    public Page<ICPXH> select(SearchContext context){
        return null ;
    }


    public void getDraft(ICPXH cpxh){
        ICPXH clientModel = cPXHFeignClient.getDraft((CPXHImpl)cpxh) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), cpxh.getClass(), false);
        copier.copy(clientModel, cpxh, null);
    }


    public void checkKey(ICPXH cpxh){
        ICPXH clientModel = cPXHFeignClient.checkKey((CPXHImpl)cpxh) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), cpxh.getClass(), false);
        copier.copy(clientModel, cpxh, null);
    }


    public void save(ICPXH cpxh){
        ICPXH clientModel = cPXHFeignClient.save((CPXHImpl)cpxh) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), cpxh.getClass(), false);
        copier.copy(clientModel, cpxh, null);
    }



}

