package com.sinosig.client.external.model;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.client.model.ISYXBJ;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 接口实体[SYXBJ] 对象
 */
public class SYXBJImpl implements ISYXBJ,Serializable{

    /**
     * 费率
     */
    public Double Fl;

    @JsonIgnore
    public boolean FlDirtyFlag;
    
    /**
     * 基准保费
     */
    public BigDecimal Jzbf;

    @JsonIgnore
    public boolean JzbfDirtyFlag;
    
    /**
     * MD
     */
    public String Md;

    @JsonIgnore
    public boolean MdDirtyFlag;
    
    /**
     * 平台返回系数
     */
    public Double Ptfhxs;

    @JsonIgnore
    public boolean PtfhxsDirtyFlag;
    
    /**
     * 实交保费
     */
    public BigDecimal Sjbf;

    @JsonIgnore
    public boolean SjbfDirtyFlag;
    
    /**
     * 商业险报价标识
     */
    public String SYXBJId;

    @JsonIgnore
    public boolean SYXBJIdDirtyFlag;
    
    /**
     * 商业险报价名称
     */
    public String SYXBJName;

    @JsonIgnore
    public boolean SYXBJNameDirtyFlag;
    
    /**
     * 条款代码
     */
    public String Tkdm;

    @JsonIgnore
    public boolean TkdmDirtyFlag;
    
    /**
     * 条款名称
     */
    public String Tkmc;

    @JsonIgnore
    public boolean TkmcDirtyFlag;
    
    /**
     * 获取 [费率]
     */
    @JsonProperty("fl")
    public Double getFl(){
        return Fl ;
    }

    /**
     * 设置 [费率]
     */
    @JsonProperty("fl")
    public void setFl(Double  fl){
        this.Fl = fl ;
        this.FlDirtyFlag = true ;
    }

     /**
     * 获取 [费率]脏标记
     */
    @JsonIgnore
    public boolean getFlDirtyFlag(){
        return FlDirtyFlag ;
    }   

    /**
     * 获取 [基准保费]
     */
    @JsonProperty("jzbf")
    public BigDecimal getJzbf(){
        return Jzbf ;
    }

    /**
     * 设置 [基准保费]
     */
    @JsonProperty("jzbf")
    public void setJzbf(BigDecimal  jzbf){
        this.Jzbf = jzbf ;
        this.JzbfDirtyFlag = true ;
    }

     /**
     * 获取 [基准保费]脏标记
     */
    @JsonIgnore
    public boolean getJzbfDirtyFlag(){
        return JzbfDirtyFlag ;
    }   

    /**
     * 获取 [MD]
     */
    @JsonProperty("md")
    public String getMd(){
        return Md ;
    }

    /**
     * 设置 [MD]
     */
    @JsonProperty("md")
    public void setMd(String  md){
        this.Md = md ;
        this.MdDirtyFlag = true ;
    }

     /**
     * 获取 [MD]脏标记
     */
    @JsonIgnore
    public boolean getMdDirtyFlag(){
        return MdDirtyFlag ;
    }   

    /**
     * 获取 [平台返回系数]
     */
    @JsonProperty("ptfhxs")
    public Double getPtfhxs(){
        return Ptfhxs ;
    }

    /**
     * 设置 [平台返回系数]
     */
    @JsonProperty("ptfhxs")
    public void setPtfhxs(Double  ptfhxs){
        this.Ptfhxs = ptfhxs ;
        this.PtfhxsDirtyFlag = true ;
    }

     /**
     * 获取 [平台返回系数]脏标记
     */
    @JsonIgnore
    public boolean getPtfhxsDirtyFlag(){
        return PtfhxsDirtyFlag ;
    }   

    /**
     * 获取 [实交保费]
     */
    @JsonProperty("sjbf")
    public BigDecimal getSjbf(){
        return Sjbf ;
    }

    /**
     * 设置 [实交保费]
     */
    @JsonProperty("sjbf")
    public void setSjbf(BigDecimal  sjbf){
        this.Sjbf = sjbf ;
        this.SjbfDirtyFlag = true ;
    }

     /**
     * 获取 [实交保费]脏标记
     */
    @JsonIgnore
    public boolean getSjbfDirtyFlag(){
        return SjbfDirtyFlag ;
    }   

    /**
     * 获取 [商业险报价标识]
     */
    @JsonProperty("syxbjid")
    public String getSYXBJId(){
        return SYXBJId ;
    }

    /**
     * 设置 [商业险报价标识]
     */
    @JsonProperty("syxbjid")
    public void setSYXBJId(String  sYXBJId){
        this.SYXBJId = sYXBJId ;
        this.SYXBJIdDirtyFlag = true ;
    }

     /**
     * 获取 [商业险报价标识]脏标记
     */
    @JsonIgnore
    public boolean getSYXBJIdDirtyFlag(){
        return SYXBJIdDirtyFlag ;
    }   

    /**
     * 获取 [商业险报价名称]
     */
    @JsonProperty("syxbjname")
    public String getSYXBJName(){
        return SYXBJName ;
    }

    /**
     * 设置 [商业险报价名称]
     */
    @JsonProperty("syxbjname")
    public void setSYXBJName(String  sYXBJName){
        this.SYXBJName = sYXBJName ;
        this.SYXBJNameDirtyFlag = true ;
    }

     /**
     * 获取 [商业险报价名称]脏标记
     */
    @JsonIgnore
    public boolean getSYXBJNameDirtyFlag(){
        return SYXBJNameDirtyFlag ;
    }   

    /**
     * 获取 [条款代码]
     */
    @JsonProperty("tkdm")
    public String getTkdm(){
        return Tkdm ;
    }

    /**
     * 设置 [条款代码]
     */
    @JsonProperty("tkdm")
    public void setTkdm(String  tkdm){
        this.Tkdm = tkdm ;
        this.TkdmDirtyFlag = true ;
    }

     /**
     * 获取 [条款代码]脏标记
     */
    @JsonIgnore
    public boolean getTkdmDirtyFlag(){
        return TkdmDirtyFlag ;
    }   

    /**
     * 获取 [条款名称]
     */
    @JsonProperty("tkmc")
    public String getTkmc(){
        return Tkmc ;
    }

    /**
     * 设置 [条款名称]
     */
    @JsonProperty("tkmc")
    public void setTkmc(String  tkmc){
        this.Tkmc = tkmc ;
        this.TkmcDirtyFlag = true ;
    }

     /**
     * 获取 [条款名称]脏标记
     */
    @JsonIgnore
    public boolean getTkmcDirtyFlag(){
        return TkmcDirtyFlag ;
    }   

}
