package com.sinosig.client.external.model;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.client.model.IJQXBJ;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 接口实体[JQXBJ] 对象
 */
public class JQXBJImpl implements IJQXBJ,Serializable{

    /**
     * 费率系数
     */
    public Double Flxs;

    @JsonIgnore
    public boolean FlxsDirtyFlag;
    
    /**
     * 交强险报价标识
     */
    public String JQXBJId;

    @JsonIgnore
    public boolean JQXBJIdDirtyFlag;
    
    /**
     * 交强险报价名称
     */
    public String JQXBJName;

    @JsonIgnore
    public boolean JQXBJNameDirtyFlag;
    
    /**
     * 基准保费
     */
    public BigDecimal Jzbf;

    @JsonIgnore
    public boolean JzbfDirtyFlag;
    
    /**
     * 实交保费
     */
    public BigDecimal Sjbf;

    @JsonIgnore
    public boolean SjbfDirtyFlag;
    
    /**
     * 条款代码
     */
    public String Tkdm;

    @JsonIgnore
    public boolean TkdmDirtyFlag;
    
    /**
     * 条款名称
     */
    public String Tkmc;

    @JsonIgnore
    public boolean TkmcDirtyFlag;
    
    /**
     * 责任限额
     */
    public BigDecimal Zrxe;

    @JsonIgnore
    public boolean ZrxeDirtyFlag;
    
    /**
     * 获取 [费率系数]
     */
    @JsonProperty("flxs")
    public Double getFlxs(){
        return Flxs ;
    }

    /**
     * 设置 [费率系数]
     */
    @JsonProperty("flxs")
    public void setFlxs(Double  flxs){
        this.Flxs = flxs ;
        this.FlxsDirtyFlag = true ;
    }

     /**
     * 获取 [费率系数]脏标记
     */
    @JsonIgnore
    public boolean getFlxsDirtyFlag(){
        return FlxsDirtyFlag ;
    }   

    /**
     * 获取 [交强险报价标识]
     */
    @JsonProperty("jqxbjid")
    public String getJQXBJId(){
        return JQXBJId ;
    }

    /**
     * 设置 [交强险报价标识]
     */
    @JsonProperty("jqxbjid")
    public void setJQXBJId(String  jQXBJId){
        this.JQXBJId = jQXBJId ;
        this.JQXBJIdDirtyFlag = true ;
    }

     /**
     * 获取 [交强险报价标识]脏标记
     */
    @JsonIgnore
    public boolean getJQXBJIdDirtyFlag(){
        return JQXBJIdDirtyFlag ;
    }   

    /**
     * 获取 [交强险报价名称]
     */
    @JsonProperty("jqxbjname")
    public String getJQXBJName(){
        return JQXBJName ;
    }

    /**
     * 设置 [交强险报价名称]
     */
    @JsonProperty("jqxbjname")
    public void setJQXBJName(String  jQXBJName){
        this.JQXBJName = jQXBJName ;
        this.JQXBJNameDirtyFlag = true ;
    }

     /**
     * 获取 [交强险报价名称]脏标记
     */
    @JsonIgnore
    public boolean getJQXBJNameDirtyFlag(){
        return JQXBJNameDirtyFlag ;
    }   

    /**
     * 获取 [基准保费]
     */
    @JsonProperty("jzbf")
    public BigDecimal getJzbf(){
        return Jzbf ;
    }

    /**
     * 设置 [基准保费]
     */
    @JsonProperty("jzbf")
    public void setJzbf(BigDecimal  jzbf){
        this.Jzbf = jzbf ;
        this.JzbfDirtyFlag = true ;
    }

     /**
     * 获取 [基准保费]脏标记
     */
    @JsonIgnore
    public boolean getJzbfDirtyFlag(){
        return JzbfDirtyFlag ;
    }   

    /**
     * 获取 [实交保费]
     */
    @JsonProperty("sjbf")
    public BigDecimal getSjbf(){
        return Sjbf ;
    }

    /**
     * 设置 [实交保费]
     */
    @JsonProperty("sjbf")
    public void setSjbf(BigDecimal  sjbf){
        this.Sjbf = sjbf ;
        this.SjbfDirtyFlag = true ;
    }

     /**
     * 获取 [实交保费]脏标记
     */
    @JsonIgnore
    public boolean getSjbfDirtyFlag(){
        return SjbfDirtyFlag ;
    }   

    /**
     * 获取 [条款代码]
     */
    @JsonProperty("tkdm")
    public String getTkdm(){
        return Tkdm ;
    }

    /**
     * 设置 [条款代码]
     */
    @JsonProperty("tkdm")
    public void setTkdm(String  tkdm){
        this.Tkdm = tkdm ;
        this.TkdmDirtyFlag = true ;
    }

     /**
     * 获取 [条款代码]脏标记
     */
    @JsonIgnore
    public boolean getTkdmDirtyFlag(){
        return TkdmDirtyFlag ;
    }   

    /**
     * 获取 [条款名称]
     */
    @JsonProperty("tkmc")
    public String getTkmc(){
        return Tkmc ;
    }

    /**
     * 设置 [条款名称]
     */
    @JsonProperty("tkmc")
    public void setTkmc(String  tkmc){
        this.Tkmc = tkmc ;
        this.TkmcDirtyFlag = true ;
    }

     /**
     * 获取 [条款名称]脏标记
     */
    @JsonIgnore
    public boolean getTkmcDirtyFlag(){
        return TkmcDirtyFlag ;
    }   

    /**
     * 获取 [责任限额]
     */
    @JsonProperty("zrxe")
    public BigDecimal getZrxe(){
        return Zrxe ;
    }

    /**
     * 设置 [责任限额]
     */
    @JsonProperty("zrxe")
    public void setZrxe(BigDecimal  zrxe){
        this.Zrxe = zrxe ;
        this.ZrxeDirtyFlag = true ;
    }

     /**
     * 获取 [责任限额]脏标记
     */
    @JsonIgnore
    public boolean getZrxeDirtyFlag(){
        return ZrxeDirtyFlag ;
    }   

}
