package com.sinosig.client.external.feign;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import com.sinosig.core.client.model.ISYXBJ;
import com.sinosig.client.external.model.SYXBJImpl;
import com.sinosig.util.SearchContext;
/**
 * 实体[SYXBJ] 服务对象接口
 */
public interface SYXBJFeignClient {

    @RequestMapping(method = RequestMethod.GET, value = "/web/syxbjs/fetchdefault")
    public Page<SYXBJImpl> fetchDefault(SearchContext context);


    @RequestMapping(method = RequestMethod.GET, value = "/web/syxbjs/{syxbjid}")
    public SYXBJImpl get(@PathVariable("syxbjid") String syxbjid);


    @RequestMapping(method = RequestMethod.POST, value = "/web/syxbjs/select")
    public Page<SYXBJImpl> select();


    @RequestMapping(method = RequestMethod.POST, value = "/web/syxbjs/save")
    public SYXBJImpl save(@RequestBody SYXBJImpl syxbj);


    @RequestMapping(method = RequestMethod.DELETE, value = "/web/syxbjs/{syxbjid}")
    public Boolean remove(@PathVariable("syxbjid") String syxbjid);
        

    @RequestMapping(method = RequestMethod.GET, value = "/web/syxbjs/getdraft")
    public SYXBJImpl getDraft(@RequestBody SYXBJImpl syxbj);


    @RequestMapping(method = RequestMethod.POST, value = "/web/syxbjs/checkkey")
    public SYXBJImpl checkKey(@RequestBody SYXBJImpl syxbj);


    @RequestMapping(method = RequestMethod.PUT, value = "/web/syxbjs/{syxbjid}")
    public SYXBJImpl update(@PathVariable("syxbjid") String syxbjid,@RequestBody SYXBJImpl syxbj);


    @RequestMapping(method = RequestMethod.POST, value = "/web/syxbjs")
    public SYXBJImpl create(@RequestBody SYXBJImpl syxbj);
        


}
