package com.sinosig.client.external.feign;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import com.sinosig.core.client.model.IJQXBJ;
import com.sinosig.client.external.model.JQXBJImpl;
import com.sinosig.util.SearchContext;
/**
 * 实体[JQXBJ] 服务对象接口
 */
public interface JQXBJFeignClient {

    @RequestMapping(method = RequestMethod.GET, value = "/web/jqxbjs/{jqxbjid}")
    public JQXBJImpl get(@PathVariable("jqxbjid") String jqxbjid);


    @RequestMapping(method = RequestMethod.GET, value = "/web/jqxbjs/fetchdefault")
    public Page<JQXBJImpl> fetchDefault(SearchContext context);


    @RequestMapping(method = RequestMethod.POST, value = "/web/jqxbjs/select")
    public Page<JQXBJImpl> select();


    @RequestMapping(method = RequestMethod.PUT, value = "/web/jqxbjs/{jqxbjid}")
    public JQXBJImpl update(@PathVariable("jqxbjid") String jqxbjid,@RequestBody JQXBJImpl jqxbj);


    @RequestMapping(method = RequestMethod.DELETE, value = "/web/jqxbjs/{jqxbjid}")
    public Boolean remove(@PathVariable("jqxbjid") String jqxbjid);
        

    @RequestMapping(method = RequestMethod.POST, value = "/web/jqxbjs/save")
    public JQXBJImpl save(@RequestBody JQXBJImpl jqxbj);


    @RequestMapping(method = RequestMethod.POST, value = "/web/jqxbjs")
    public JQXBJImpl create(@RequestBody JQXBJImpl jqxbj);
        

    @RequestMapping(method = RequestMethod.POST, value = "/web/jqxbjs/checkkey")
    public JQXBJImpl checkKey(@RequestBody JQXBJImpl jqxbj);


    @RequestMapping(method = RequestMethod.GET, value = "/web/jqxbjs/getdraft")
    public JQXBJImpl getDraft(@RequestBody JQXBJImpl jqxbj);



}
