package com.sinosig.client.external.feign;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;
import com.sinosig.core.client.model.ICPXH;
import com.sinosig.client.external.model.CPXHImpl;
import com.sinosig.util.SearchContext;
/**
 * 实体[CPXH] 服务对象接口
 */
public interface CPXHFeignClient {

    @RequestMapping(method = RequestMethod.PUT, value = "/web/cpxhs/{cpxhid}")
    public CPXHImpl update(@PathVariable("cpxhid") String cpxhid,@RequestBody CPXHImpl cpxh);


    @RequestMapping(method = RequestMethod.GET, value = "/web/cpxhs/fetchdefault")
    public Page<CPXHImpl> fetchDefault(SearchContext context);


    @RequestMapping(method = RequestMethod.POST, value = "/web/cpxhs")
    public CPXHImpl create(@RequestBody CPXHImpl cpxh);
        

    @RequestMapping(method = RequestMethod.GET, value = "/web/cpxhs/{cpxhid}")
    public CPXHImpl get(@PathVariable("cpxhid") String cpxhid);


    @RequestMapping(method = RequestMethod.DELETE, value = "/web/cpxhs/{cpxhid}")
    public Boolean remove(@PathVariable("cpxhid") String cpxhid);
        

    @RequestMapping(method = RequestMethod.POST, value = "/web/cpxhs/select")
    public Page<CPXHImpl> select();


    @RequestMapping(method = RequestMethod.GET, value = "/web/cpxhs/getdraft")
    public CPXHImpl getDraft(@RequestBody CPXHImpl cpxh);


    @RequestMapping(method = RequestMethod.POST, value = "/web/cpxhs/checkkey")
    public CPXHImpl checkKey(@RequestBody CPXHImpl cpxh);


    @RequestMapping(method = RequestMethod.POST, value = "/web/cpxhs/save")
    public CPXHImpl save(@RequestBody CPXHImpl cpxh);



}
