package com.sinosig.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.sinosig.service.web.dto.SYXBJDTO;
import com.sinosig.core.external.domain.SYXBJ;
import com.sinosig.core.external.service.ISYXBJService;
import com.sinosig.util.SearchContext;
import com.sinosig.core.external.filter.SYXBJSearchContext;

@Api(tags = {"SYXBJ" })
@RestController
@RequestMapping("")
public class SYXBJResource {

    @Autowired
    private ISYXBJService syxbjService;

    public ISYXBJService getSyxbjService() {
        return this.syxbjService;
    }

    @ApiOperation(value = "Save", tags = {"SYXBJ" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/syxbjs/save")
    public ResponseEntity<Boolean> save(@RequestBody SYXBJDTO syxbjdto) {
        SYXBJ syxbj = syxbjdto.toDO();
    	Boolean b = syxbjService.save(syxbj) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Remove", tags = {"SYXBJ" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/syxbjs/{syxbj_id}")

    public ResponseEntity<Boolean> remove(@PathVariable("syxbj_id") String syxbj_id) {
        SYXBJDTO syxbjdto = new SYXBJDTO();
		SYXBJ domain = new SYXBJ();
		syxbjdto.setSYXBJId(syxbj_id);
		domain.setSYXBJId(syxbj_id);

        Boolean rst = syxbjService.remove(domain.getSYXBJId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "GetDraft", tags = {"SYXBJ" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/syxbjs/{syxbj_id}/getdraft")

    public ResponseEntity<SYXBJDTO> getDraft(@PathVariable("syxbj_id") String syxbj_id, @RequestBody SYXBJDTO syxbjdto) {
        SYXBJ syxbj = syxbjdto.toDO();
    	syxbj = syxbjService.getDraft(syxbj) ;
    	syxbjdto.fromDO(syxbj);
        return ResponseEntity.status(HttpStatus.OK).body(syxbjdto);
    }

    @ApiOperation(value = "CheckKey", tags = {"SYXBJ" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/syxbjs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody SYXBJDTO syxbjdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Update", tags = {"SYXBJ" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/syxbjs/{syxbj_id}")

    public ResponseEntity<SYXBJDTO> update(@PathVariable("syxbj_id") String syxbj_id, @RequestBody SYXBJDTO syxbjdto) {
		SYXBJ domain = syxbjdto.toDO();
        domain.setSYXBJId(syxbj_id);
		syxbjService.update(domain);
		SYXBJDTO dto = new SYXBJDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Create", tags = {"SYXBJ" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/syxbjs")

    public ResponseEntity<SYXBJDTO> create(@RequestBody SYXBJDTO syxbjdto) {
        SYXBJDTO dto = new SYXBJDTO();
        SYXBJ domain = syxbjdto.toDO();
		syxbjService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Get", tags = {"SYXBJ" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/syxbjs/{syxbj_id}")
    public ResponseEntity<SYXBJDTO> get(@PathVariable("syxbj_id") String syxbj_id) {
        SYXBJDTO dto = new SYXBJDTO();
        SYXBJ domain =new SYXBJ();
        domain.setSYXBJId(syxbj_id);
		syxbjService.get(domain);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"SYXBJ" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/syxbjs/fetchdefault")
	public ResponseEntity<Page<SYXBJDTO>> fetchDefault(SYXBJSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<SYXBJDTO> list = new ArrayList<SYXBJDTO>();
        
        Page<SYXBJ> domains = syxbjService.searchDefault(context) ;
        for(SYXBJ syxbj : domains.getContent()){
            SYXBJDTO dto = new SYXBJDTO();
            dto.fromDO(syxbj);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
