package com.sinosig.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.sinosig.service.web.dto.SJZDXDTO;
import com.sinosig.core.module.domain.SJZDX;
import com.sinosig.core.module.service.ISJZDXService;
import com.sinosig.util.SearchContext;
import com.sinosig.core.module.filter.SJZDXSearchContext;

@Api(tags = {"SJZDX" })
@RestController
@RequestMapping("")
public class SJZDXResource {

    @Autowired
    private ISJZDXService sjzdxService;

    public ISJZDXService getSjzdxService() {
        return this.sjzdxService;
    }

    @ApiOperation(value = "Create", tags = {"SJZDX" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/sjzdxes")
    @Transactional
    public ResponseEntity<SJZDXDTO> create(@RequestBody SJZDXDTO sjzdxdto) {
        SJZDXDTO dto = new SJZDXDTO();
        SJZDX domain = sjzdxdto.toDO();
		sjzdxService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Get", tags = {"SJZDX" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/sjzdxes/{sjzdx_id}")
    public ResponseEntity<SJZDXDTO> get(@PathVariable("sjzdx_id") String sjzdx_id) {
        SJZDXDTO dto = new SJZDXDTO();
        SJZDX domain =new SJZDX();
        domain.setSJZDXId(sjzdx_id);
		sjzdxService.get(domain);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Remove", tags = {"SJZDX" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/sjzdxes/{sjzdx_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("sjzdx_id") String sjzdx_id) {
        SJZDXDTO sjzdxdto = new SJZDXDTO();
		SJZDX domain = new SJZDX();
		sjzdxdto.setSJZDXId(sjzdx_id);
		domain.setSJZDXId(sjzdx_id);

        Boolean rst = sjzdxService.remove(domain.getSJZDXId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "CheckKey", tags = {"SJZDX" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/sjzdxes/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody SJZDXDTO sjzdxdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Update", tags = {"SJZDX" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/sjzdxes/{sjzdx_id}")
    @Transactional
    public ResponseEntity<SJZDXDTO> update(@PathVariable("sjzdx_id") String sjzdx_id, @RequestBody SJZDXDTO sjzdxdto) {
		SJZDX domain = sjzdxdto.toDO();
        domain.setSJZDXId(sjzdx_id);
		sjzdxService.update(domain);
		SJZDXDTO dto = new SJZDXDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"SJZDX" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/sjzdxes/{sjzdx_id}/getdraft")
    @Transactional
    public ResponseEntity<SJZDXDTO> getDraft(@PathVariable("sjzdx_id") String sjzdx_id, @RequestBody SJZDXDTO sjzdxdto) {
        SJZDX sjzdx = sjzdxdto.toDO();
    	sjzdx = sjzdxService.getDraft(sjzdx) ;
    	sjzdxdto.fromDO(sjzdx);
        return ResponseEntity.status(HttpStatus.OK).body(sjzdxdto);
    }

    @ApiOperation(value = "Save", tags = {"SJZDX" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/sjzdxes/save")
    public ResponseEntity<Boolean> save(@RequestBody SJZDXDTO sjzdxdto) {
        SJZDX sjzdx = sjzdxdto.toDO();
    	Boolean b = sjzdxService.save(sjzdx) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@ApiOperation(value = "获取车类种类", tags = {"SJZDX" } ,notes = "获取车类种类")
    @RequestMapping(method= RequestMethod.GET , value="/web/sjzdxes/fetchclzl")
	public ResponseEntity<Page<SJZDXDTO>> fetchCLZL(SJZDXSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<SJZDXDTO> list = new ArrayList<SJZDXDTO>();
        
        Page<SJZDX> domains = sjzdxService.searchCLZL(context) ;
        for(SJZDX sjzdx : domains.getContent()){
            SJZDXDTO dto = new SJZDXDTO();
            dto.fromDO(sjzdx);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}

	@ApiOperation(value = "获取业务来源", tags = {"SJZDX" } ,notes = "获取业务来源")
    @RequestMapping(method= RequestMethod.GET , value="/web/sjzdxes/fetchywly")
	public ResponseEntity<Page<SJZDXDTO>> fetchYWLY(SJZDXSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<SJZDXDTO> list = new ArrayList<SJZDXDTO>();
        
        Page<SJZDX> domains = sjzdxService.searchYWLY(context) ;
        for(SJZDX sjzdx : domains.getContent()){
            SJZDXDTO dto = new SJZDXDTO();
            dto.fromDO(sjzdx);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}

	@ApiOperation(value = "获取车辆大类", tags = {"SJZDX" } ,notes = "获取车辆大类")
    @RequestMapping(method= RequestMethod.GET , value="/web/sjzdxes/fetchcldl")
	public ResponseEntity<Page<SJZDXDTO>> fetchCLDL(SJZDXSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<SJZDXDTO> list = new ArrayList<SJZDXDTO>();
        
        Page<SJZDX> domains = sjzdxService.searchCLDL(context) ;
        for(SJZDX sjzdx : domains.getContent()){
            SJZDXDTO dto = new SJZDXDTO();
            dto.fromDO(sjzdx);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}

	@ApiOperation(value = "获取DEFAULT", tags = {"SJZDX" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/sjzdxes/fetchdefault")
	public ResponseEntity<Page<SJZDXDTO>> fetchDefault(SJZDXSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<SJZDXDTO> list = new ArrayList<SJZDXDTO>();
        
        Page<SJZDX> domains = sjzdxService.searchDefault(context) ;
        for(SJZDX sjzdx : domains.getContent()){
            SJZDXDTO dto = new SJZDXDTO();
            dto.fromDO(sjzdx);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
