package com.sinosig.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.sinosig.service.web.dto.ORGUSERDTO;
import com.sinosig.core.external.domain.ORGUSER;
import com.sinosig.core.external.service.IORGUSERService;
import com.sinosig.util.SearchContext;
import com.sinosig.core.external.filter.ORGUSERSearchContext;

@Api(tags = {"ORGUSER" })
@RestController
@RequestMapping("")
public class ORGUSERResource {

    @Autowired
    private IORGUSERService orguserService;

    public IORGUSERService getOrguserService() {
        return this.orguserService;
    }

    @ApiOperation(value = "Create", tags = {"ORGUSER" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgusers")

    public ResponseEntity<ORGUSERDTO> create(@RequestBody ORGUSERDTO orguserdto) {
        ORGUSERDTO dto = new ORGUSERDTO();
        ORGUSER domain = orguserdto.toDO();
		orguserService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"ORGUSER" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgusers/{orguser_id}/getdraft")

    public ResponseEntity<ORGUSERDTO> getDraft(@PathVariable("orguser_id") String orguser_id, @RequestBody ORGUSERDTO orguserdto) {
        ORGUSER orguser = orguserdto.toDO();
    	orguser = orguserService.getDraft(orguser) ;
    	orguserdto.fromDO(orguser);
        return ResponseEntity.status(HttpStatus.OK).body(orguserdto);
    }

    @ApiOperation(value = "Update", tags = {"ORGUSER" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/orgusers/{orguser_id}")

    public ResponseEntity<ORGUSERDTO> update(@PathVariable("orguser_id") String orguser_id, @RequestBody ORGUSERDTO orguserdto) {
		ORGUSER domain = orguserdto.toDO();
        domain.setORGUSERId(orguser_id);
		orguserService.update(domain);
		ORGUSERDTO dto = new ORGUSERDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Get", tags = {"ORGUSER" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgusers/{orguser_id}")
    public ResponseEntity<ORGUSERDTO> get(@PathVariable("orguser_id") String orguser_id) {
        ORGUSERDTO dto = new ORGUSERDTO();
        ORGUSER domain =new ORGUSER();
        domain.setORGUSERId(orguser_id);
		orguserService.get(domain);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKey", tags = {"ORGUSER" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgusers/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody ORGUSERDTO orguserdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Remove", tags = {"ORGUSER" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/orgusers/{orguser_id}")

    public ResponseEntity<Boolean> remove(@PathVariable("orguser_id") String orguser_id) {
        ORGUSERDTO orguserdto = new ORGUSERDTO();
		ORGUSER domain = new ORGUSER();
		orguserdto.setORGUSERId(orguser_id);
		domain.setORGUSERId(orguser_id);

        Boolean rst = orguserService.remove(domain.getORGUSERId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Save", tags = {"ORGUSER" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgusers/save")
    public ResponseEntity<Boolean> save(@RequestBody ORGUSERDTO orguserdto) {
        ORGUSER orguser = orguserdto.toDO();
    	Boolean b = orguserService.save(orguser) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@ApiOperation(value = "获取获取当前用户", tags = {"ORGUSER" } ,notes = "获取获取当前用户")
    @RequestMapping(method= RequestMethod.GET , value="/web/orgusers/fetchcurorguser")
	public ResponseEntity<Page<ORGUSERDTO>> fetchCurOrgUser(ORGUSERSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<ORGUSERDTO> list = new ArrayList<ORGUSERDTO>();
        
        Page<ORGUSER> domains = orguserService.searchCurOrgUser(context) ;
        for(ORGUSER orguser : domains.getContent()){
            ORGUSERDTO dto = new ORGUSERDTO();
            dto.fromDO(orguser);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}

	@ApiOperation(value = "获取DEFAULT", tags = {"ORGUSER" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/orgusers/fetchdefault")
	public ResponseEntity<Page<ORGUSERDTO>> fetchDefault(ORGUSERSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<ORGUSERDTO> list = new ArrayList<ORGUSERDTO>();
        
        Page<ORGUSER> domains = orguserService.searchDefault(context) ;
        for(ORGUSER orguser : domains.getContent()){
            ORGUSERDTO dto = new ORGUSERDTO();
            dto.fromDO(orguser);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
