package com.sinosig.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.sinosig.service.web.dto.JQXBJDTO;
import com.sinosig.core.external.domain.JQXBJ;
import com.sinosig.core.external.service.IJQXBJService;
import com.sinosig.util.SearchContext;
import com.sinosig.core.external.filter.JQXBJSearchContext;

@Api(tags = {"JQXBJ" })
@RestController
@RequestMapping("")
public class JQXBJResource {

    @Autowired
    private IJQXBJService jqxbjService;

    public IJQXBJService getJqxbjService() {
        return this.jqxbjService;
    }

    @ApiOperation(value = "Update", tags = {"JQXBJ" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/jqxbjs/{jqxbj_id}")

    public ResponseEntity<JQXBJDTO> update(@PathVariable("jqxbj_id") String jqxbj_id, @RequestBody JQXBJDTO jqxbjdto) {
		JQXBJ domain = jqxbjdto.toDO();
        domain.setJQXBJId(jqxbj_id);
		jqxbjService.update(domain);
		JQXBJDTO dto = new JQXBJDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Get", tags = {"JQXBJ" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/jqxbjs/{jqxbj_id}")
    public ResponseEntity<JQXBJDTO> get(@PathVariable("jqxbj_id") String jqxbj_id) {
        JQXBJDTO dto = new JQXBJDTO();
        JQXBJ domain =new JQXBJ();
        domain.setJQXBJId(jqxbj_id);
		jqxbjService.get(domain);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Remove", tags = {"JQXBJ" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/jqxbjs/{jqxbj_id}")

    public ResponseEntity<Boolean> remove(@PathVariable("jqxbj_id") String jqxbj_id) {
        JQXBJDTO jqxbjdto = new JQXBJDTO();
		JQXBJ domain = new JQXBJ();
		jqxbjdto.setJQXBJId(jqxbj_id);
		domain.setJQXBJId(jqxbj_id);

        Boolean rst = jqxbjService.remove(domain.getJQXBJId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Save", tags = {"JQXBJ" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/jqxbjs/save")
    public ResponseEntity<Boolean> save(@RequestBody JQXBJDTO jqxbjdto) {
        JQXBJ jqxbj = jqxbjdto.toDO();
    	Boolean b = jqxbjService.save(jqxbj) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Create", tags = {"JQXBJ" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/jqxbjs")

    public ResponseEntity<JQXBJDTO> create(@RequestBody JQXBJDTO jqxbjdto) {
        JQXBJDTO dto = new JQXBJDTO();
        JQXBJ domain = jqxbjdto.toDO();
		jqxbjService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKey", tags = {"JQXBJ" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/jqxbjs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody JQXBJDTO jqxbjdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraft", tags = {"JQXBJ" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/jqxbjs/{jqxbj_id}/getdraft")

    public ResponseEntity<JQXBJDTO> getDraft(@PathVariable("jqxbj_id") String jqxbj_id, @RequestBody JQXBJDTO jqxbjdto) {
        JQXBJ jqxbj = jqxbjdto.toDO();
    	jqxbj = jqxbjService.getDraft(jqxbj) ;
    	jqxbjdto.fromDO(jqxbj);
        return ResponseEntity.status(HttpStatus.OK).body(jqxbjdto);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"JQXBJ" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/jqxbjs/fetchdefault")
	public ResponseEntity<Page<JQXBJDTO>> fetchDefault(JQXBJSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<JQXBJDTO> list = new ArrayList<JQXBJDTO>();
        
        Page<JQXBJ> domains = jqxbjService.searchDefault(context) ;
        for(JQXBJ jqxbj : domains.getContent()){
            JQXBJDTO dto = new JQXBJDTO();
            dto.fromDO(jqxbj);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
