package com.sinosig.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.sinosig.service.web.dto.DBDDTO;
import com.sinosig.core.module.domain.DBD;
import com.sinosig.core.module.service.IDBDService;
import com.sinosig.util.SearchContext;
import com.sinosig.core.module.filter.DBDSearchContext;

@Api(tags = {"DBD" })
@RestController
@RequestMapping("")
public class DBDResource {

    @Autowired
    private IDBDService dbdService;

    public IDBDService getDbdService() {
        return this.dbdService;
    }

    @ApiOperation(value = "Save", tags = {"DBD" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/dbds/save")
    public ResponseEntity<Boolean> save(@RequestBody DBDDTO dbddto) {
        DBD dbd = dbddto.toDO();
    	Boolean b = dbdService.save(dbd) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Update", tags = {"DBD" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/dbds/{dbd_id}")
    @Transactional
    public ResponseEntity<DBDDTO> update(@PathVariable("dbd_id") String dbd_id, @RequestBody DBDDTO dbddto) {
		DBD domain = dbddto.toDO();
        domain.setDBDId(dbd_id);
		dbdService.update(domain);
		DBDDTO dto = new DBDDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"DBD" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/dbds/{dbd_id}/getdraft")
    @Transactional
    public ResponseEntity<DBDDTO> getDraft(@PathVariable("dbd_id") String dbd_id, @RequestBody DBDDTO dbddto) {
        DBD dbd = dbddto.toDO();
    	dbd = dbdService.getDraft(dbd) ;
    	dbddto.fromDO(dbd);
        return ResponseEntity.status(HttpStatus.OK).body(dbddto);
    }

    @ApiOperation(value = "Create", tags = {"DBD" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/dbds")
    @Transactional
    public ResponseEntity<DBDDTO> create(@RequestBody DBDDTO dbddto) {
        DBDDTO dto = new DBDDTO();
        DBD domain = dbddto.toDO();
		dbdService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKey", tags = {"DBD" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/dbds/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody DBDDTO dbddto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Remove", tags = {"DBD" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/dbds/{dbd_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("dbd_id") String dbd_id) {
        DBDDTO dbddto = new DBDDTO();
		DBD domain = new DBD();
		dbddto.setDBDId(dbd_id);
		domain.setDBDId(dbd_id);

        Boolean rst = dbdService.remove(domain.getDBDId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Get", tags = {"DBD" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/dbds/{dbd_id}")
    public ResponseEntity<DBDDTO> get(@PathVariable("dbd_id") String dbd_id) {
        DBDDTO dto = new DBDDTO();
        DBD domain =new DBD();
        domain.setDBDId(dbd_id);
		dbdService.get(domain);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"DBD" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/dbds/fetchdefault")
	public ResponseEntity<Page<DBDDTO>> fetchDefault(DBDSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<DBDDTO> list = new ArrayList<DBDDTO>();
        
        Page<DBD> domains = dbdService.searchDefault(context) ;
        for(DBD dbd : domains.getContent()){
            DBDDTO dto = new DBDDTO();
            dto.fromDO(dbd);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
