package com.sinosig.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.sinosig.service.web.dto.CIDDTO;
import com.sinosig.core.module.domain.CID;
import com.sinosig.core.module.service.ICIDService;
import com.sinosig.util.SearchContext;
import com.sinosig.core.module.filter.CIDSearchContext;
import com.sinosig.service.web.dto.JQXTBYDDTO;
import com.sinosig.core.module.domain.JQXTBYD;
import com.sinosig.core.module.service.IJQXTBYDService;
import com.sinosig.service.web.dto.SYXTBYDDTO;
import com.sinosig.core.module.domain.SYXTBYD;
import com.sinosig.core.module.service.ISYXTBYDService;
import com.sinosig.service.web.dto.CUSTOMERDTO;
import com.sinosig.core.module.domain.CUSTOMER;
import com.sinosig.core.module.service.ICUSTOMERService;
import com.sinosig.service.web.dto.JQXXXDTO;
import com.sinosig.core.module.domain.JQXXX;
import com.sinosig.core.module.service.IJQXXXService;
import com.sinosig.service.web.dto.SYXXXDTO;
import com.sinosig.core.module.domain.SYXXX;
import com.sinosig.core.module.service.ISYXXXService;

@Api(tags = {"CID" })
@RestController
@RequestMapping("")
public class CIDResource {

    @Autowired
    private ICIDService cidService;

    public ICIDService getCidService() {
        return this.cidService;
    }

    @Autowired
    private IJQXTBYDService jqxtbydService;

    public IJQXTBYDService getJqxtbydService() {
        return this.jqxtbydService;
    }

    @Autowired
    private ISYXTBYDService syxtbydService;

    public ISYXTBYDService getSyxtbydService() {
        return this.syxtbydService;
    }

    @Autowired
    private ICUSTOMERService customerService;

    public ICUSTOMERService getCustomerService() {
        return this.customerService;
    }

    @Autowired
    private IJQXXXService jqxxxService;

    public IJQXXXService getJqxxxService() {
        return this.jqxxxService;
    }

    @Autowired
    private ISYXXXService syxxxService;

    public ISYXXXService getSyxxxService() {
        return this.syxxxService;
    }

    @ApiOperation(value = "CheckKey", tags = {"CID" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/cids/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody CIDDTO ciddto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Create", tags = {"CID" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/cids")
    @Transactional
    public ResponseEntity<CIDDTO> create(@RequestBody CIDDTO ciddto) {
        CIDDTO dto = new CIDDTO();
        CID domain = ciddto.toDO();
		cidService.create(domain);
        dto.fromDO(domain);
		List<JQXTBYDDTO> jqxtbyddtos = ciddto.getJqxtbyds();
        List<JQXTBYDDTO> jqxtbyddtos2 = new ArrayList<JQXTBYDDTO>();
        if (jqxtbyddtos != null && jqxtbyddtos.size() > 0) {
            for (JQXTBYDDTO jqxtbyddto : jqxtbyddtos) {
                JQXTBYD jqxtbydDo = jqxtbyddto.toDO();
                jqxtbydDo.setCIDId(dto.getCIDId());
                jqxtbydService.create(jqxtbydDo);
                jqxtbyddto.fromDO(jqxtbydDo);
                jqxtbyddtos2.add(jqxtbyddto);
            }
        } else {
            jqxtbyddtos2 = jqxtbyddtos;
        }
        dto.setJqxtbyds(jqxtbyddtos2);

		List<SYXTBYDDTO> syxtbyddtos = ciddto.getSyxtbyds();
        List<SYXTBYDDTO> syxtbyddtos2 = new ArrayList<SYXTBYDDTO>();
        if (syxtbyddtos != null && syxtbyddtos.size() > 0) {
            for (SYXTBYDDTO syxtbyddto : syxtbyddtos) {
                SYXTBYD syxtbydDo = syxtbyddto.toDO();
                syxtbydDo.setCIDId(dto.getCIDId());
                syxtbydService.create(syxtbydDo);
                syxtbyddto.fromDO(syxtbydDo);
                syxtbyddtos2.add(syxtbyddto);
            }
        } else {
            syxtbyddtos2 = syxtbyddtos;
        }
        dto.setSyxtbyds(syxtbyddtos2);

		List<CUSTOMERDTO> customerdtos = ciddto.getCustomers();
        List<CUSTOMERDTO> customerdtos2 = new ArrayList<CUSTOMERDTO>();
        if (customerdtos != null && customerdtos.size() > 0) {
            for (CUSTOMERDTO customerdto : customerdtos) {
                CUSTOMER customerDo = customerdto.toDO();
                customerDo.setCIDId(dto.getCIDId());
                customerService.create(customerDo);
                customerdto.fromDO(customerDo);
                customerdtos2.add(customerdto);
            }
        } else {
            customerdtos2 = customerdtos;
        }
        dto.setCustomers(customerdtos2);

		List<JQXXXDTO> jqxxxdtos = ciddto.getJqxxxes();
        List<JQXXXDTO> jqxxxdtos2 = new ArrayList<JQXXXDTO>();
        if (jqxxxdtos != null && jqxxxdtos.size() > 0) {
            for (JQXXXDTO jqxxxdto : jqxxxdtos) {
                JQXXX jqxxxDo = jqxxxdto.toDO();
                jqxxxDo.setCIDId(dto.getCIDId());
                jqxxxService.create(jqxxxDo);
                jqxxxdto.fromDO(jqxxxDo);
                jqxxxdtos2.add(jqxxxdto);
            }
        } else {
            jqxxxdtos2 = jqxxxdtos;
        }
        dto.setJqxxxes(jqxxxdtos2);

		List<SYXXXDTO> syxxxdtos = ciddto.getSyxxxes();
        List<SYXXXDTO> syxxxdtos2 = new ArrayList<SYXXXDTO>();
        if (syxxxdtos != null && syxxxdtos.size() > 0) {
            for (SYXXXDTO syxxxdto : syxxxdtos) {
                SYXXX syxxxDo = syxxxdto.toDO();
                syxxxDo.setCIDId(dto.getCIDId());
                syxxxService.create(syxxxDo);
                syxxxdto.fromDO(syxxxDo);
                syxxxdtos2.add(syxxxdto);
            }
        } else {
            syxxxdtos2 = syxxxdtos;
        }
        dto.setSyxxxes(syxxxdtos2);

		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Get", tags = {"CID" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/cids/{cid_id}")
    public ResponseEntity<CIDDTO> get(@PathVariable("cid_id") String cid_id) {
        CIDDTO dto = new CIDDTO();
        CID domain =new CID();
        domain.setCIDId(cid_id);
		cidService.get(domain);
		dto.fromDO(domain);
        Page<JQXTBYD> JqxtbydDos = jqxtbydService.selectByCID(cid_id);
		if(JqxtbydDos != null){
		    List<JQXTBYDDTO> jqxtbyds = new ArrayList<JQXTBYDDTO>();
            for (JQXTBYD JqxtbydDo : JqxtbydDos) {
                JQXTBYDDTO jqxtbyddto = new JQXTBYDDTO();
                jqxtbyddto.fromDO(JqxtbydDo);
                jqxtbyds.add(jqxtbyddto);
            }
            dto.setJqxtbyds(jqxtbyds);
        }
        Page<SYXTBYD> SyxtbydDos = syxtbydService.selectByCID(cid_id);
		if(SyxtbydDos != null){
		    List<SYXTBYDDTO> syxtbyds = new ArrayList<SYXTBYDDTO>();
            for (SYXTBYD SyxtbydDo : SyxtbydDos) {
                SYXTBYDDTO syxtbyddto = new SYXTBYDDTO();
                syxtbyddto.fromDO(SyxtbydDo);
                syxtbyds.add(syxtbyddto);
            }
            dto.setSyxtbyds(syxtbyds);
        }
        Page<CUSTOMER> CustomerDos = customerService.selectByCID(cid_id);
		if(CustomerDos != null){
		    List<CUSTOMERDTO> customers = new ArrayList<CUSTOMERDTO>();
            for (CUSTOMER CustomerDo : CustomerDos) {
                CUSTOMERDTO customerdto = new CUSTOMERDTO();
                customerdto.fromDO(CustomerDo);
                customers.add(customerdto);
            }
            dto.setCustomers(customers);
        }
        Page<JQXXX> JqxxxDos = jqxxxService.selectByJQXXX(cid_id);
		if(JqxxxDos != null){
		    List<JQXXXDTO> jqxxxes = new ArrayList<JQXXXDTO>();
            for (JQXXX JqxxxDo : JqxxxDos) {
                JQXXXDTO jqxxxdto = new JQXXXDTO();
                jqxxxdto.fromDO(JqxxxDo);
                jqxxxes.add(jqxxxdto);
            }
            dto.setJqxxxes(jqxxxes);
        }
        Page<SYXXX> SyxxxDos = syxxxService.selectByCID(cid_id);
		if(SyxxxDos != null){
		    List<SYXXXDTO> syxxxes = new ArrayList<SYXXXDTO>();
            for (SYXXX SyxxxDo : SyxxxDos) {
                SYXXXDTO syxxxdto = new SYXXXDTO();
                syxxxdto.fromDO(SyxxxDo);
                syxxxes.add(syxxxdto);
            }
            dto.setSyxxxes(syxxxes);
        }
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"CID" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/cids/{cid_id}/getdraft")
    @Transactional
    public ResponseEntity<CIDDTO> getDraft(@PathVariable("cid_id") String cid_id, @RequestBody CIDDTO ciddto) {
        CID cid = ciddto.toDO();
    	cid = cidService.getDraft(cid) ;
    	ciddto.fromDO(cid);
        return ResponseEntity.status(HttpStatus.OK).body(ciddto);
    }

    @ApiOperation(value = "Update", tags = {"CID" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/cids/{cid_id}")
    @Transactional
    public ResponseEntity<CIDDTO> update(@PathVariable("cid_id") String cid_id, @RequestBody CIDDTO ciddto) {
		CID domain = ciddto.toDO();
        domain.setCIDId(cid_id);
		cidService.update(domain);
		CIDDTO dto = new CIDDTO();
		dto.fromDO(domain);
		List<JQXTBYDDTO> jqxtbyddtos = ciddto.getJqxtbyds();
		List<JQXTBYD> jqxtbydDOs = jqxtbydService.selectByCID2(cid_id);
        List<String> jqxtbydIds = new ArrayList<String>();
        if (jqxtbydDOs != null && !jqxtbydDOs.isEmpty()) {
            for (JQXTBYD minorDO : jqxtbydDOs) {
                jqxtbydIds.add(minorDO.getJQXTBYDId());
            }
        }
        List<JQXTBYDDTO> jqxtbyddtos2 = new ArrayList<JQXTBYDDTO>();
        if (jqxtbyddtos != null && jqxtbyddtos.size() > 0) {
            for (JQXTBYDDTO jqxtbyddto : jqxtbyddtos) {
                JQXTBYD jqxtbydDo = jqxtbyddto.toDO();
                jqxtbydDo.setCIDId(dto.getCIDId());
                if ( StringUtils.isEmpty( jqxtbydDo.getJQXTBYDId()) || (jqxtbydIds != null && !jqxtbydIds.isEmpty() &&  jqxtbydIds.contains(jqxtbydDo.getJQXTBYDId()))) {
                    jqxtbydService.save(jqxtbydDo);
                    jqxtbyddto.fromDO(jqxtbydDo);
                    jqxtbyddtos2.add(jqxtbyddto);
                } else {
                    jqxtbydService.remove(jqxtbydDo.getJQXTBYDId());
                }
            }
        } else {
            jqxtbyddtos2 = jqxtbyddtos;
        }
        dto.setJqxtbyds(jqxtbyddtos2);

		List<SYXTBYDDTO> syxtbyddtos = ciddto.getSyxtbyds();
		List<SYXTBYD> syxtbydDOs = syxtbydService.selectByCID2(cid_id);
        List<String> syxtbydIds = new ArrayList<String>();
        if (syxtbydDOs != null && !syxtbydDOs.isEmpty()) {
            for (SYXTBYD minorDO : syxtbydDOs) {
                syxtbydIds.add(minorDO.getSYXTBYDId());
            }
        }
        List<SYXTBYDDTO> syxtbyddtos2 = new ArrayList<SYXTBYDDTO>();
        if (syxtbyddtos != null && syxtbyddtos.size() > 0) {
            for (SYXTBYDDTO syxtbyddto : syxtbyddtos) {
                SYXTBYD syxtbydDo = syxtbyddto.toDO();
                syxtbydDo.setCIDId(dto.getCIDId());
                if ( StringUtils.isEmpty( syxtbydDo.getSYXTBYDId()) || (syxtbydIds != null && !syxtbydIds.isEmpty() &&  syxtbydIds.contains(syxtbydDo.getSYXTBYDId()))) {
                    syxtbydService.save(syxtbydDo);
                    syxtbyddto.fromDO(syxtbydDo);
                    syxtbyddtos2.add(syxtbyddto);
                } else {
                    syxtbydService.remove(syxtbydDo.getSYXTBYDId());
                }
            }
        } else {
            syxtbyddtos2 = syxtbyddtos;
        }
        dto.setSyxtbyds(syxtbyddtos2);

		List<CUSTOMERDTO> customerdtos = ciddto.getCustomers();
		List<CUSTOMER> customerDOs = customerService.selectByCID2(cid_id);
        List<String> customerIds = new ArrayList<String>();
        if (customerDOs != null && !customerDOs.isEmpty()) {
            for (CUSTOMER minorDO : customerDOs) {
                customerIds.add(minorDO.getCUSTOMERId());
            }
        }
        List<CUSTOMERDTO> customerdtos2 = new ArrayList<CUSTOMERDTO>();
        if (customerdtos != null && customerdtos.size() > 0) {
            for (CUSTOMERDTO customerdto : customerdtos) {
                CUSTOMER customerDo = customerdto.toDO();
                customerDo.setCIDId(dto.getCIDId());
                if ( StringUtils.isEmpty( customerDo.getCUSTOMERId()) || (customerIds != null && !customerIds.isEmpty() &&  customerIds.contains(customerDo.getCUSTOMERId()))) {
                    customerService.save(customerDo);
                    customerdto.fromDO(customerDo);
                    customerdtos2.add(customerdto);
                } else {
                    customerService.remove(customerDo.getCUSTOMERId());
                }
            }
        } else {
            customerdtos2 = customerdtos;
        }
        dto.setCustomers(customerdtos2);

		List<JQXXXDTO> jqxxxdtos = ciddto.getJqxxxes();
		List<JQXXX> jqxxxDOs = jqxxxService.selectByJQXXX2(cid_id);
        List<String> jqxxxIds = new ArrayList<String>();
        if (jqxxxDOs != null && !jqxxxDOs.isEmpty()) {
            for (JQXXX minorDO : jqxxxDOs) {
                jqxxxIds.add(minorDO.getJQXXXId());
            }
        }
        List<JQXXXDTO> jqxxxdtos2 = new ArrayList<JQXXXDTO>();
        if (jqxxxdtos != null && jqxxxdtos.size() > 0) {
            for (JQXXXDTO jqxxxdto : jqxxxdtos) {
                JQXXX jqxxxDo = jqxxxdto.toDO();
                jqxxxDo.setCIDId(dto.getCIDId());
                if ( StringUtils.isEmpty( jqxxxDo.getJQXXXId()) || (jqxxxIds != null && !jqxxxIds.isEmpty() &&  jqxxxIds.contains(jqxxxDo.getJQXXXId()))) {
                    jqxxxService.save(jqxxxDo);
                    jqxxxdto.fromDO(jqxxxDo);
                    jqxxxdtos2.add(jqxxxdto);
                } else {
                    jqxxxService.remove(jqxxxDo.getJQXXXId());
                }
            }
        } else {
            jqxxxdtos2 = jqxxxdtos;
        }
        dto.setJqxxxes(jqxxxdtos2);

		List<SYXXXDTO> syxxxdtos = ciddto.getSyxxxes();
		List<SYXXX> syxxxDOs = syxxxService.selectByCID2(cid_id);
        List<String> syxxxIds = new ArrayList<String>();
        if (syxxxDOs != null && !syxxxDOs.isEmpty()) {
            for (SYXXX minorDO : syxxxDOs) {
                syxxxIds.add(minorDO.getSYXXXId());
            }
        }
        List<SYXXXDTO> syxxxdtos2 = new ArrayList<SYXXXDTO>();
        if (syxxxdtos != null && syxxxdtos.size() > 0) {
            for (SYXXXDTO syxxxdto : syxxxdtos) {
                SYXXX syxxxDo = syxxxdto.toDO();
                syxxxDo.setCIDId(dto.getCIDId());
                if ( StringUtils.isEmpty( syxxxDo.getSYXXXId()) || (syxxxIds != null && !syxxxIds.isEmpty() &&  syxxxIds.contains(syxxxDo.getSYXXXId()))) {
                    syxxxService.save(syxxxDo);
                    syxxxdto.fromDO(syxxxDo);
                    syxxxdtos2.add(syxxxdto);
                } else {
                    syxxxService.remove(syxxxDo.getSYXXXId());
                }
            }
        } else {
            syxxxdtos2 = syxxxdtos;
        }
        dto.setSyxxxes(syxxxdtos2);

        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Save", tags = {"CID" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/cids/save")
    public ResponseEntity<Boolean> save(@RequestBody CIDDTO ciddto) {
        CID cid = ciddto.toDO();
    	Boolean b = cidService.save(cid) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Remove", tags = {"CID" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/cids/{cid_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("cid_id") String cid_id) {
        CIDDTO ciddto = new CIDDTO();
		CID domain = new CID();
		ciddto.setCIDId(cid_id);
		domain.setCIDId(cid_id);

		Map<String, Object> JqxtbydMap = new HashMap<String, Object>();
        JqxtbydMap.put("cidid",cid_id);
        Page<JQXTBYD> JqxtbydDos = jqxtbydService.selectByCID(cid_id);
		if(JqxtbydDos != null){
            for (JQXTBYD JqxtbydDo : JqxtbydDos) {
                jqxtbydService.remove(JqxtbydDo.getJQXTBYDId());
            }
        }
		Map<String, Object> SyxtbydMap = new HashMap<String, Object>();
        SyxtbydMap.put("cidid",cid_id);
        Page<SYXTBYD> SyxtbydDos = syxtbydService.selectByCID(cid_id);
		if(SyxtbydDos != null){
            for (SYXTBYD SyxtbydDo : SyxtbydDos) {
                syxtbydService.remove(SyxtbydDo.getSYXTBYDId());
            }
        }
		Map<String, Object> CustomerMap = new HashMap<String, Object>();
        CustomerMap.put("cidid",cid_id);
        Page<CUSTOMER> CustomerDos = customerService.selectByCID(cid_id);
		if(CustomerDos != null){
            for (CUSTOMER CustomerDo : CustomerDos) {
                customerService.remove(CustomerDo.getCUSTOMERId());
            }
        }
		Map<String, Object> JqxxxMap = new HashMap<String, Object>();
        JqxxxMap.put("cidid",cid_id);
        Page<JQXXX> JqxxxDos = jqxxxService.selectByJQXXX(cid_id);
		if(JqxxxDos != null){
            for (JQXXX JqxxxDo : JqxxxDos) {
                jqxxxService.remove(JqxxxDo.getJQXXXId());
            }
        }
		Map<String, Object> SyxxxMap = new HashMap<String, Object>();
        SyxxxMap.put("cidid",cid_id);
        Page<SYXXX> SyxxxDos = syxxxService.selectByCID(cid_id);
		if(SyxxxDos != null){
            for (SYXXX SyxxxDo : SyxxxDos) {
                syxxxService.remove(SyxxxDo.getSYXXXId());
            }
        }
        Boolean rst = cidService.remove(domain.getCIDId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"CID" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/cids/fetchdefault")
	public ResponseEntity<Page<CIDDTO>> fetchDefault(CIDSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<CIDDTO> list = new ArrayList<CIDDTO>();
        
        Page<CID> domains = cidService.searchDefault(context) ;
        for(CID cid : domains.getContent()){
            CIDDTO dto = new CIDDTO();
            dto.fromDO(cid);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
