package com.sinosig.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.module.valuerule.anno.tbydk.*;
import com.sinosig.core.module.domain.TBYDK;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 服务DTO对象[TBYDKDTO]
 */
public class TBYDKDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CREATEDATE]
     *
     */

    @TBYDKCreateDateDefault(info = "默认规则")
    private Timestamp CreateDate;

    @JsonIgnore
    private boolean CreateDateDirtyFlag;

    /**
     * 属性 [TBYDKNAME]
     *
     */

    @TBYDKTBYDKNameDefault(info = "默认规则")
    private String TBYDKName;

    @JsonIgnore
    private boolean TBYDKNameDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */

    @TBYDKUpdateDateDefault(info = "默认规则")
    private Timestamp UpdateDate;

    @JsonIgnore
    private boolean UpdateDateDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */

    @TBYDKUpdateManDefault(info = "默认规则")
    private String UpdateMan;

    @JsonIgnore
    private boolean UpdateManDirtyFlag;

    /**
     * 属性 [LB]
     *
     */

    @TBYDKLbDefault(info = "默认规则")
    private String Lb;

    @JsonIgnore
    private boolean LbDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */

    @TBYDKCreateManDefault(info = "默认规则")
    private String CreateMan;

    @JsonIgnore
    private boolean CreateManDirtyFlag;

    /**
     * 属性 [TYNR]
     *
     */

    @TBYDKTynrDefault(info = "默认规则")
    private String Tynr;

    @JsonIgnore
    private boolean TynrDirtyFlag;

    /**
     * 属性 [TYMC]
     *
     */

    @TBYDKTymcDefault(info = "默认规则")
    private String Tymc;

    @JsonIgnore
    private boolean TymcDirtyFlag;

    /**
     * 属性 [TBYDKID]
     *
     */

    @TBYDKTBYDKIdDefault(info = "默认规则")
    private String TBYDKId;

    @JsonIgnore
    private boolean TBYDKIdDirtyFlag;


    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return CreateDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.CreateDate = createDate ;
        this.CreateDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return CreateDateDirtyFlag ;
    }

    /**
     * 获取 [TBYDKNAME]
     */
    @JsonProperty("tbydkname")
    public String getTBYDKName(){
        return TBYDKName ;
    }

    /**
     * 设置 [TBYDKNAME]
     */
    @JsonProperty("tbydkname")
    public void setTBYDKName(String  tBYDKName){
        this.TBYDKName = tBYDKName ;
        this.TBYDKNameDirtyFlag = true ;
    }

    /**
     * 获取 [TBYDKNAME]脏标记
     */
    @JsonIgnore
    public boolean getTBYDKNameDirtyFlag(){
        return TBYDKNameDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return UpdateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.UpdateDate = updateDate ;
        this.UpdateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return UpdateDateDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return UpdateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.UpdateMan = updateMan ;
        this.UpdateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return UpdateManDirtyFlag ;
    }

    /**
     * 获取 [LB]
     */
    @JsonProperty("lb")
    public String getLb(){
        return Lb ;
    }

    /**
     * 设置 [LB]
     */
    @JsonProperty("lb")
    public void setLb(String  lb){
        this.Lb = lb ;
        this.LbDirtyFlag = true ;
    }

    /**
     * 获取 [LB]脏标记
     */
    @JsonIgnore
    public boolean getLbDirtyFlag(){
        return LbDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return CreateMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.CreateMan = createMan ;
        this.CreateManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return CreateManDirtyFlag ;
    }

    /**
     * 获取 [TYNR]
     */
    @JsonProperty("tynr")
    public String getTynr(){
        return Tynr ;
    }

    /**
     * 设置 [TYNR]
     */
    @JsonProperty("tynr")
    public void setTynr(String  tynr){
        this.Tynr = tynr ;
        this.TynrDirtyFlag = true ;
    }

    /**
     * 获取 [TYNR]脏标记
     */
    @JsonIgnore
    public boolean getTynrDirtyFlag(){
        return TynrDirtyFlag ;
    }

    /**
     * 获取 [TYMC]
     */
    @JsonProperty("tymc")
    public String getTymc(){
        return Tymc ;
    }

    /**
     * 设置 [TYMC]
     */
    @JsonProperty("tymc")
    public void setTymc(String  tymc){
        this.Tymc = tymc ;
        this.TymcDirtyFlag = true ;
    }

    /**
     * 获取 [TYMC]脏标记
     */
    @JsonIgnore
    public boolean getTymcDirtyFlag(){
        return TymcDirtyFlag ;
    }

    /**
     * 获取 [TBYDKID]
     */
    @JsonProperty("tbydkid")
    public String getTBYDKId(){
        return TBYDKId ;
    }

    /**
     * 设置 [TBYDKID]
     */
    @JsonProperty("tbydkid")
    public void setTBYDKId(String  tBYDKId){
        this.TBYDKId = tBYDKId ;
        this.TBYDKIdDirtyFlag = true ;
    }

    /**
     * 获取 [TBYDKID]脏标记
     */
    @JsonIgnore
    public boolean getTBYDKIdDirtyFlag(){
        return TBYDKIdDirtyFlag ;
    }



    public TBYDK toDO() {

        TBYDK srfdomain = new TBYDK();
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(CreateDate);
        if(getTBYDKNameDirtyFlag())
            srfdomain.setTBYDKName(TBYDKName);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(UpdateDate);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(UpdateMan);
        if(getLbDirtyFlag())
            srfdomain.setLb(Lb);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(CreateMan);
        if(getTynrDirtyFlag())
            srfdomain.setTynr(Tynr);
        if(getTymcDirtyFlag())
            srfdomain.setTymc(Tymc);
        if(getTBYDKIdDirtyFlag())
            srfdomain.setTBYDKId(TBYDKId);
        return srfdomain;
    }

    public void fromDO(TBYDK srfdomain) {

        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getTBYDKNameDirtyFlag())
            this.setTBYDKName(srfdomain.getTBYDKName());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getLbDirtyFlag())
            this.setLb(srfdomain.getLb());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getTynrDirtyFlag())
            this.setTynr(srfdomain.getTynr());
        if(srfdomain.getTymcDirtyFlag())
            this.setTymc(srfdomain.getTymc());
        if(srfdomain.getTBYDKIdDirtyFlag())
            this.setTBYDKId(srfdomain.getTBYDKId());

    }

    public List<TBYDKDTO> fromDOPage(List<TBYDK> poPage)   {
        if(poPage == null)
            return null;
        List<TBYDKDTO> dtos=new ArrayList<TBYDKDTO>();
        for(TBYDK domain : poPage) {
            TBYDKDTO dto = new TBYDKDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

