package com.sinosig.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.module.valuerule.anno.sjzdx.*;
import com.sinosig.core.module.domain.SJZDX;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 服务DTO对象[SJZDXDTO]
 */
public class SJZDXDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [NAME]
     *
     */

    @SJZDXNameDefault(info = "默认规则")
    private String Name;

    @JsonIgnore
    private boolean NameDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */

    @SJZDXCreateManDefault(info = "默认规则")
    private String CreateMan;

    @JsonIgnore
    private boolean CreateManDirtyFlag;

    /**
     * 属性 [PNAME]
     *
     */

    @SJZDXPnameDefault(info = "默认规则")
    private String Pname;

    @JsonIgnore
    private boolean PnameDirtyFlag;

    /**
     * 属性 [SJZDXID]
     *
     */

    @SJZDXSJZDXIdDefault(info = "默认规则")
    private String SJZDXId;

    @JsonIgnore
    private boolean SJZDXIdDirtyFlag;

    /**
     * 属性 [SJZDXNAME]
     *
     */

    @SJZDXSJZDXNameDefault(info = "默认规则")
    private String SJZDXName;

    @JsonIgnore
    private boolean SJZDXNameDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */

    @SJZDXUpdateManDefault(info = "默认规则")
    private String UpdateMan;

    @JsonIgnore
    private boolean UpdateManDirtyFlag;

    /**
     * 属性 [CODE]
     *
     */

    @SJZDXCodeDefault(info = "默认规则")
    private String Code;

    @JsonIgnore
    private boolean CodeDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */

    @SJZDXUpdateDateDefault(info = "默认规则")
    private Timestamp UpdateDate;

    @JsonIgnore
    private boolean UpdateDateDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */

    @SJZDXCreateDateDefault(info = "默认规则")
    private Timestamp CreateDate;

    @JsonIgnore
    private boolean CreateDateDirtyFlag;

    /**
     * 属性 [PCODE]
     *
     */

    @SJZDXPcodeDefault(info = "默认规则")
    private String Pcode;

    @JsonIgnore
    private boolean PcodeDirtyFlag;

    /**
     * 属性 [SJZDID]
     *
     */

    @SJZDXSJZDIdDefault(info = "默认规则")
    private String SJZDId;

    @JsonIgnore
    private boolean SJZDIdDirtyFlag;


    /**
     * 获取 [NAME]
     */
    @JsonProperty("name")
    public String getName(){
        return Name ;
    }

    /**
     * 设置 [NAME]
     */
    @JsonProperty("name")
    public void setName(String  name){
        this.Name = name ;
        this.NameDirtyFlag = true ;
    }

    /**
     * 获取 [NAME]脏标记
     */
    @JsonIgnore
    public boolean getNameDirtyFlag(){
        return NameDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return CreateMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.CreateMan = createMan ;
        this.CreateManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return CreateManDirtyFlag ;
    }

    /**
     * 获取 [PNAME]
     */
    @JsonProperty("pname")
    public String getPname(){
        return Pname ;
    }

    /**
     * 设置 [PNAME]
     */
    @JsonProperty("pname")
    public void setPname(String  pname){
        this.Pname = pname ;
        this.PnameDirtyFlag = true ;
    }

    /**
     * 获取 [PNAME]脏标记
     */
    @JsonIgnore
    public boolean getPnameDirtyFlag(){
        return PnameDirtyFlag ;
    }

    /**
     * 获取 [SJZDXID]
     */
    @JsonProperty("sjzdxid")
    public String getSJZDXId(){
        return SJZDXId ;
    }

    /**
     * 设置 [SJZDXID]
     */
    @JsonProperty("sjzdxid")
    public void setSJZDXId(String  sJZDXId){
        this.SJZDXId = sJZDXId ;
        this.SJZDXIdDirtyFlag = true ;
    }

    /**
     * 获取 [SJZDXID]脏标记
     */
    @JsonIgnore
    public boolean getSJZDXIdDirtyFlag(){
        return SJZDXIdDirtyFlag ;
    }

    /**
     * 获取 [SJZDXNAME]
     */
    @JsonProperty("sjzdxname")
    public String getSJZDXName(){
        return SJZDXName ;
    }

    /**
     * 设置 [SJZDXNAME]
     */
    @JsonProperty("sjzdxname")
    public void setSJZDXName(String  sJZDXName){
        this.SJZDXName = sJZDXName ;
        this.SJZDXNameDirtyFlag = true ;
    }

    /**
     * 获取 [SJZDXNAME]脏标记
     */
    @JsonIgnore
    public boolean getSJZDXNameDirtyFlag(){
        return SJZDXNameDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return UpdateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.UpdateMan = updateMan ;
        this.UpdateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return UpdateManDirtyFlag ;
    }

    /**
     * 获取 [CODE]
     */
    @JsonProperty("code")
    public String getCode(){
        return Code ;
    }

    /**
     * 设置 [CODE]
     */
    @JsonProperty("code")
    public void setCode(String  code){
        this.Code = code ;
        this.CodeDirtyFlag = true ;
    }

    /**
     * 获取 [CODE]脏标记
     */
    @JsonIgnore
    public boolean getCodeDirtyFlag(){
        return CodeDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return UpdateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.UpdateDate = updateDate ;
        this.UpdateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return UpdateDateDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return CreateDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.CreateDate = createDate ;
        this.CreateDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return CreateDateDirtyFlag ;
    }

    /**
     * 获取 [PCODE]
     */
    @JsonProperty("pcode")
    public String getPcode(){
        return Pcode ;
    }

    /**
     * 设置 [PCODE]
     */
    @JsonProperty("pcode")
    public void setPcode(String  pcode){
        this.Pcode = pcode ;
        this.PcodeDirtyFlag = true ;
    }

    /**
     * 获取 [PCODE]脏标记
     */
    @JsonIgnore
    public boolean getPcodeDirtyFlag(){
        return PcodeDirtyFlag ;
    }

    /**
     * 获取 [SJZDID]
     */
    @JsonProperty("sjzdid")
    public String getSJZDId(){
        return SJZDId ;
    }

    /**
     * 设置 [SJZDID]
     */
    @JsonProperty("sjzdid")
    public void setSJZDId(String  sJZDId){
        this.SJZDId = sJZDId ;
        this.SJZDIdDirtyFlag = true ;
    }

    /**
     * 获取 [SJZDID]脏标记
     */
    @JsonIgnore
    public boolean getSJZDIdDirtyFlag(){
        return SJZDIdDirtyFlag ;
    }



    public SJZDX toDO() {

        SJZDX srfdomain = new SJZDX();
        if(getNameDirtyFlag())
            srfdomain.setName(Name);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(CreateMan);
        if(getPnameDirtyFlag())
            srfdomain.setPname(Pname);
        if(getSJZDXIdDirtyFlag())
            srfdomain.setSJZDXId(SJZDXId);
        if(getSJZDXNameDirtyFlag())
            srfdomain.setSJZDXName(SJZDXName);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(UpdateMan);
        if(getCodeDirtyFlag())
            srfdomain.setCode(Code);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(UpdateDate);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(CreateDate);
        if(getPcodeDirtyFlag())
            srfdomain.setPcode(Pcode);
        if(getSJZDIdDirtyFlag())
            srfdomain.setSJZDId(SJZDId);
        return srfdomain;
    }

    public void fromDO(SJZDX srfdomain) {

        if(srfdomain.getNameDirtyFlag())
            this.setName(srfdomain.getName());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getPnameDirtyFlag())
            this.setPname(srfdomain.getPname());
        if(srfdomain.getSJZDXIdDirtyFlag())
            this.setSJZDXId(srfdomain.getSJZDXId());
        if(srfdomain.getSJZDXNameDirtyFlag())
            this.setSJZDXName(srfdomain.getSJZDXName());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getCodeDirtyFlag())
            this.setCode(srfdomain.getCode());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getPcodeDirtyFlag())
            this.setPcode(srfdomain.getPcode());
        if(srfdomain.getSJZDIdDirtyFlag())
            this.setSJZDId(srfdomain.getSJZDId());

    }

    public List<SJZDXDTO> fromDOPage(List<SJZDX> poPage)   {
        if(poPage == null)
            return null;
        List<SJZDXDTO> dtos=new ArrayList<SJZDXDTO>();
        for(SJZDX domain : poPage) {
            SJZDXDTO dto = new SJZDXDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

