package com.sinosig.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.external.valuerule.anno.orguser.*;
import com.sinosig.core.external.domain.ORGUSER;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 服务DTO对象[ORGUSERDTO]
 */
public class ORGUSERDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [ORGUSERNAME]
     *
     */

    @ORGUSERORGUSERNameDefault(info = "默认规则")
    private String ORGUSERName;

    @JsonIgnore
    private boolean ORGUSERNameDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */

    @ORGUSERCreateManDefault(info = "默认规则")
    private String CreateMan;

    @JsonIgnore
    private boolean CreateManDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */

    @ORGUSERCreateDateDefault(info = "默认规则")
    private Timestamp CreateDate;

    @JsonIgnore
    private boolean CreateDateDirtyFlag;

    /**
     * 属性 [ORGUSERID]
     *
     */

    @ORGUSERORGUSERIdDefault(info = "默认规则")
    private String ORGUSERId;

    @JsonIgnore
    private boolean ORGUSERIdDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */

    @ORGUSERUpdateDateDefault(info = "默认规则")
    private Timestamp UpdateDate;

    @JsonIgnore
    private boolean UpdateDateDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */

    @ORGUSERUpdateManDefault(info = "默认规则")
    private String UpdateMan;

    @JsonIgnore
    private boolean UpdateManDirtyFlag;

    /**
     * 属性 [ORGNAME]
     *
     */

    @ORGUSERORGNameDefault(info = "默认规则")
    private String ORGName;

    @JsonIgnore
    private boolean ORGNameDirtyFlag;

    /**
     * 属性 [ORGID]
     *
     */

    @ORGUSERORGIdDefault(info = "默认规则")
    private String ORGId;

    @JsonIgnore
    private boolean ORGIdDirtyFlag;


    /**
     * 获取 [ORGUSERNAME]
     */
    @JsonProperty("orgusername")
    public String getORGUSERName(){
        return ORGUSERName ;
    }

    /**
     * 设置 [ORGUSERNAME]
     */
    @JsonProperty("orgusername")
    public void setORGUSERName(String  oRGUSERName){
        this.ORGUSERName = oRGUSERName ;
        this.ORGUSERNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGUSERNAME]脏标记
     */
    @JsonIgnore
    public boolean getORGUSERNameDirtyFlag(){
        return ORGUSERNameDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return CreateMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.CreateMan = createMan ;
        this.CreateManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return CreateManDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return CreateDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.CreateDate = createDate ;
        this.CreateDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return CreateDateDirtyFlag ;
    }

    /**
     * 获取 [ORGUSERID]
     */
    @JsonProperty("orguserid")
    public String getORGUSERId(){
        return ORGUSERId ;
    }

    /**
     * 设置 [ORGUSERID]
     */
    @JsonProperty("orguserid")
    public void setORGUSERId(String  oRGUSERId){
        this.ORGUSERId = oRGUSERId ;
        this.ORGUSERIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGUSERID]脏标记
     */
    @JsonIgnore
    public boolean getORGUSERIdDirtyFlag(){
        return ORGUSERIdDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return UpdateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.UpdateDate = updateDate ;
        this.UpdateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return UpdateDateDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return UpdateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.UpdateMan = updateMan ;
        this.UpdateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return UpdateManDirtyFlag ;
    }

    /**
     * 获取 [ORGNAME]
     */
    @JsonProperty("orgname")
    public String getORGName(){
        return ORGName ;
    }

    /**
     * 设置 [ORGNAME]
     */
    @JsonProperty("orgname")
    public void setORGName(String  oRGName){
        this.ORGName = oRGName ;
        this.ORGNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGNAME]脏标记
     */
    @JsonIgnore
    public boolean getORGNameDirtyFlag(){
        return ORGNameDirtyFlag ;
    }

    /**
     * 获取 [ORGID]
     */
    @JsonProperty("orgid")
    public String getORGId(){
        return ORGId ;
    }

    /**
     * 设置 [ORGID]
     */
    @JsonProperty("orgid")
    public void setORGId(String  oRGId){
        this.ORGId = oRGId ;
        this.ORGIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGID]脏标记
     */
    @JsonIgnore
    public boolean getORGIdDirtyFlag(){
        return ORGIdDirtyFlag ;
    }



    public ORGUSER toDO() {

        ORGUSER srfdomain = new ORGUSER();
        if(getORGUSERNameDirtyFlag())
            srfdomain.setORGUSERName(ORGUSERName);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(CreateMan);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(CreateDate);
        if(getORGUSERIdDirtyFlag())
            srfdomain.setORGUSERId(ORGUSERId);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(UpdateDate);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(UpdateMan);
        if(getORGNameDirtyFlag())
            srfdomain.setORGName(ORGName);
        if(getORGIdDirtyFlag())
            srfdomain.setORGId(ORGId);
        return srfdomain;
    }

    public void fromDO(ORGUSER srfdomain) {

        if(srfdomain.getORGUSERNameDirtyFlag())
            this.setORGUSERName(srfdomain.getORGUSERName());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getORGUSERIdDirtyFlag())
            this.setORGUSERId(srfdomain.getORGUSERId());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getORGNameDirtyFlag())
            this.setORGName(srfdomain.getORGName());
        if(srfdomain.getORGIdDirtyFlag())
            this.setORGId(srfdomain.getORGId());

    }

    public List<ORGUSERDTO> fromDOPage(List<ORGUSER> poPage)   {
        if(poPage == null)
            return null;
        List<ORGUSERDTO> dtos=new ArrayList<ORGUSERDTO>();
        for(ORGUSER domain : poPage) {
            ORGUSERDTO dto = new ORGUSERDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

