package com.sinosig.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.external.valuerule.anno.syxbj.*;
import com.sinosig.core.external.domain.SYXBJ;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 服务DTO对象[SYXBJDTO]
 */
public class SYXBJDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [SYXBJNAME]
     *
     */

    @SYXBJSYXBJNameDefault(info = "默认规则")
    private String SYXBJName;

    @JsonIgnore
    private boolean SYXBJNameDirtyFlag;

    /**
     * 属性 [FL]
     *
     */

    @SYXBJFlDefault(info = "默认规则")
    private Double Fl;

    @JsonIgnore
    private boolean FlDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */

    @SYXBJUpdateManDefault(info = "默认规则")
    private String UpdateMan;

    @JsonIgnore
    private boolean UpdateManDirtyFlag;

    /**
     * 属性 [PTFHXS]
     *
     */

    @SYXBJPtfhxsDefault(info = "默认规则")
    private Double Ptfhxs;

    @JsonIgnore
    private boolean PtfhxsDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */

    @SYXBJCreateDateDefault(info = "默认规则")
    private Timestamp CreateDate;

    @JsonIgnore
    private boolean CreateDateDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */

    @SYXBJUpdateDateDefault(info = "默认规则")
    private Timestamp UpdateDate;

    @JsonIgnore
    private boolean UpdateDateDirtyFlag;

    /**
     * 属性 [JZBF]
     *
     */

    @SYXBJJzbfDefault(info = "默认规则")
    private BigDecimal Jzbf;

    @JsonIgnore
    private boolean JzbfDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */

    @SYXBJCreateManDefault(info = "默认规则")
    private String CreateMan;

    @JsonIgnore
    private boolean CreateManDirtyFlag;

    /**
     * 属性 [TKMC]
     *
     */

    @SYXBJTkmcDefault(info = "默认规则")
    private String Tkmc;

    @JsonIgnore
    private boolean TkmcDirtyFlag;

    /**
     * 属性 [MD]
     *
     */

    @SYXBJMdDefault(info = "默认规则")
    private String Md;

    @JsonIgnore
    private boolean MdDirtyFlag;

    /**
     * 属性 [TKDM]
     *
     */

    @SYXBJTkdmDefault(info = "默认规则")
    private String Tkdm;

    @JsonIgnore
    private boolean TkdmDirtyFlag;

    /**
     * 属性 [SJBF]
     *
     */

    @SYXBJSjbfDefault(info = "默认规则")
    private BigDecimal Sjbf;

    @JsonIgnore
    private boolean SjbfDirtyFlag;

    /**
     * 属性 [SYXBJID]
     *
     */

    @SYXBJSYXBJIdDefault(info = "默认规则")
    private String SYXBJId;

    @JsonIgnore
    private boolean SYXBJIdDirtyFlag;


    /**
     * 获取 [SYXBJNAME]
     */
    @JsonProperty("syxbjname")
    public String getSYXBJName(){
        return SYXBJName ;
    }

    /**
     * 设置 [SYXBJNAME]
     */
    @JsonProperty("syxbjname")
    public void setSYXBJName(String  sYXBJName){
        this.SYXBJName = sYXBJName ;
        this.SYXBJNameDirtyFlag = true ;
    }

    /**
     * 获取 [SYXBJNAME]脏标记
     */
    @JsonIgnore
    public boolean getSYXBJNameDirtyFlag(){
        return SYXBJNameDirtyFlag ;
    }

    /**
     * 获取 [FL]
     */
    @JsonProperty("fl")
    public Double getFl(){
        return Fl ;
    }

    /**
     * 设置 [FL]
     */
    @JsonProperty("fl")
    public void setFl(Double  fl){
        this.Fl = fl ;
        this.FlDirtyFlag = true ;
    }

    /**
     * 获取 [FL]脏标记
     */
    @JsonIgnore
    public boolean getFlDirtyFlag(){
        return FlDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return UpdateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.UpdateMan = updateMan ;
        this.UpdateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return UpdateManDirtyFlag ;
    }

    /**
     * 获取 [PTFHXS]
     */
    @JsonProperty("ptfhxs")
    public Double getPtfhxs(){
        return Ptfhxs ;
    }

    /**
     * 设置 [PTFHXS]
     */
    @JsonProperty("ptfhxs")
    public void setPtfhxs(Double  ptfhxs){
        this.Ptfhxs = ptfhxs ;
        this.PtfhxsDirtyFlag = true ;
    }

    /**
     * 获取 [PTFHXS]脏标记
     */
    @JsonIgnore
    public boolean getPtfhxsDirtyFlag(){
        return PtfhxsDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return CreateDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.CreateDate = createDate ;
        this.CreateDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return CreateDateDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return UpdateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.UpdateDate = updateDate ;
        this.UpdateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return UpdateDateDirtyFlag ;
    }

    /**
     * 获取 [JZBF]
     */
    @JsonProperty("jzbf")
    public BigDecimal getJzbf(){
        return Jzbf ;
    }

    /**
     * 设置 [JZBF]
     */
    @JsonProperty("jzbf")
    public void setJzbf(BigDecimal  jzbf){
        this.Jzbf = jzbf ;
        this.JzbfDirtyFlag = true ;
    }

    /**
     * 获取 [JZBF]脏标记
     */
    @JsonIgnore
    public boolean getJzbfDirtyFlag(){
        return JzbfDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return CreateMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.CreateMan = createMan ;
        this.CreateManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return CreateManDirtyFlag ;
    }

    /**
     * 获取 [TKMC]
     */
    @JsonProperty("tkmc")
    public String getTkmc(){
        return Tkmc ;
    }

    /**
     * 设置 [TKMC]
     */
    @JsonProperty("tkmc")
    public void setTkmc(String  tkmc){
        this.Tkmc = tkmc ;
        this.TkmcDirtyFlag = true ;
    }

    /**
     * 获取 [TKMC]脏标记
     */
    @JsonIgnore
    public boolean getTkmcDirtyFlag(){
        return TkmcDirtyFlag ;
    }

    /**
     * 获取 [MD]
     */
    @JsonProperty("md")
    public String getMd(){
        return Md ;
    }

    /**
     * 设置 [MD]
     */
    @JsonProperty("md")
    public void setMd(String  md){
        this.Md = md ;
        this.MdDirtyFlag = true ;
    }

    /**
     * 获取 [MD]脏标记
     */
    @JsonIgnore
    public boolean getMdDirtyFlag(){
        return MdDirtyFlag ;
    }

    /**
     * 获取 [TKDM]
     */
    @JsonProperty("tkdm")
    public String getTkdm(){
        return Tkdm ;
    }

    /**
     * 设置 [TKDM]
     */
    @JsonProperty("tkdm")
    public void setTkdm(String  tkdm){
        this.Tkdm = tkdm ;
        this.TkdmDirtyFlag = true ;
    }

    /**
     * 获取 [TKDM]脏标记
     */
    @JsonIgnore
    public boolean getTkdmDirtyFlag(){
        return TkdmDirtyFlag ;
    }

    /**
     * 获取 [SJBF]
     */
    @JsonProperty("sjbf")
    public BigDecimal getSjbf(){
        return Sjbf ;
    }

    /**
     * 设置 [SJBF]
     */
    @JsonProperty("sjbf")
    public void setSjbf(BigDecimal  sjbf){
        this.Sjbf = sjbf ;
        this.SjbfDirtyFlag = true ;
    }

    /**
     * 获取 [SJBF]脏标记
     */
    @JsonIgnore
    public boolean getSjbfDirtyFlag(){
        return SjbfDirtyFlag ;
    }

    /**
     * 获取 [SYXBJID]
     */
    @JsonProperty("syxbjid")
    public String getSYXBJId(){
        return SYXBJId ;
    }

    /**
     * 设置 [SYXBJID]
     */
    @JsonProperty("syxbjid")
    public void setSYXBJId(String  sYXBJId){
        this.SYXBJId = sYXBJId ;
        this.SYXBJIdDirtyFlag = true ;
    }

    /**
     * 获取 [SYXBJID]脏标记
     */
    @JsonIgnore
    public boolean getSYXBJIdDirtyFlag(){
        return SYXBJIdDirtyFlag ;
    }



    public SYXBJ toDO() {

        SYXBJ srfdomain = new SYXBJ();
        if(getSYXBJNameDirtyFlag())
            srfdomain.setSYXBJName(SYXBJName);
        if(getFlDirtyFlag())
            srfdomain.setFl(Fl);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(UpdateMan);
        if(getPtfhxsDirtyFlag())
            srfdomain.setPtfhxs(Ptfhxs);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(CreateDate);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(UpdateDate);
        if(getJzbfDirtyFlag())
            srfdomain.setJzbf(Jzbf);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(CreateMan);
        if(getTkmcDirtyFlag())
            srfdomain.setTkmc(Tkmc);
        if(getMdDirtyFlag())
            srfdomain.setMd(Md);
        if(getTkdmDirtyFlag())
            srfdomain.setTkdm(Tkdm);
        if(getSjbfDirtyFlag())
            srfdomain.setSjbf(Sjbf);
        if(getSYXBJIdDirtyFlag())
            srfdomain.setSYXBJId(SYXBJId);
        return srfdomain;
    }

    public void fromDO(SYXBJ srfdomain) {

        if(srfdomain.getSYXBJNameDirtyFlag())
            this.setSYXBJName(srfdomain.getSYXBJName());
        if(srfdomain.getFlDirtyFlag())
            this.setFl(srfdomain.getFl());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getPtfhxsDirtyFlag())
            this.setPtfhxs(srfdomain.getPtfhxs());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getJzbfDirtyFlag())
            this.setJzbf(srfdomain.getJzbf());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getTkmcDirtyFlag())
            this.setTkmc(srfdomain.getTkmc());
        if(srfdomain.getMdDirtyFlag())
            this.setMd(srfdomain.getMd());
        if(srfdomain.getTkdmDirtyFlag())
            this.setTkdm(srfdomain.getTkdm());
        if(srfdomain.getSjbfDirtyFlag())
            this.setSjbf(srfdomain.getSjbf());
        if(srfdomain.getSYXBJIdDirtyFlag())
            this.setSYXBJId(srfdomain.getSYXBJId());

    }

    public List<SYXBJDTO> fromDOPage(List<SYXBJ> poPage)   {
        if(poPage == null)
            return null;
        List<SYXBJDTO> dtos=new ArrayList<SYXBJDTO>();
        for(SYXBJ domain : poPage) {
            SYXBJDTO dto = new SYXBJDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

