package com.sinosig.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.module.valuerule.anno.jqxtbyd.*;
import com.sinosig.core.module.domain.JQXTBYD;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 服务DTO对象[JQXTBYDDTO]
 */
public class JQXTBYDDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [TYMC]
     *
     */

    @JQXTBYDTymcDefault(info = "默认规则")
    private String Tymc;

    @JsonIgnore
    private boolean TymcDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */

    @JQXTBYDCreateManDefault(info = "默认规则")
    private String CreateMan;

    @JsonIgnore
    private boolean CreateManDirtyFlag;

    /**
     * 属性 [JQXTBYDNAME]
     *
     */

    @JQXTBYDJQXTBYDNameDefault(info = "默认规则")
    private String JQXTBYDName;

    @JsonIgnore
    private boolean JQXTBYDNameDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */

    @JQXTBYDUpdateManDefault(info = "默认规则")
    private String UpdateMan;

    @JsonIgnore
    private boolean UpdateManDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */

    @JQXTBYDCreateDateDefault(info = "默认规则")
    private Timestamp CreateDate;

    @JsonIgnore
    private boolean CreateDateDirtyFlag;

    /**
     * 属性 [TYNR]
     *
     */

    @JQXTBYDTynrDefault(info = "默认规则")
    private String Tynr;

    @JsonIgnore
    private boolean TynrDirtyFlag;

    /**
     * 属性 [JQXTBYDID]
     *
     */

    @JQXTBYDJQXTBYDIdDefault(info = "默认规则")
    private String JQXTBYDId;

    @JsonIgnore
    private boolean JQXTBYDIdDirtyFlag;

    /**
     * 属性 [XH]
     *
     */

    @JQXTBYDXhDefault(info = "默认规则")
    private Integer Xh;

    @JsonIgnore
    private boolean XhDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */

    @JQXTBYDUpdateDateDefault(info = "默认规则")
    private Timestamp UpdateDate;

    @JsonIgnore
    private boolean UpdateDateDirtyFlag;

    /**
     * 属性 [TBYDKNAME]
     *
     */

    @JQXTBYDTBYDKNameDefault(info = "默认规则")
    private String TBYDKName;

    @JsonIgnore
    private boolean TBYDKNameDirtyFlag;

    /**
     * 属性 [TBYDKID]
     *
     */

    @JQXTBYDTBYDKIdDefault(info = "默认规则")
    private String TBYDKId;

    @JsonIgnore
    private boolean TBYDKIdDirtyFlag;

    /**
     * 属性 [CIDID]
     *
     */

    @JQXTBYDCIDIdDefault(info = "默认规则")
    private String CIDId;

    @JsonIgnore
    private boolean CIDIdDirtyFlag;


    /**
     * 获取 [TYMC]
     */
    @JsonProperty("tymc")
    public String getTymc(){
        return Tymc ;
    }

    /**
     * 设置 [TYMC]
     */
    @JsonProperty("tymc")
    public void setTymc(String  tymc){
        this.Tymc = tymc ;
        this.TymcDirtyFlag = true ;
    }

    /**
     * 获取 [TYMC]脏标记
     */
    @JsonIgnore
    public boolean getTymcDirtyFlag(){
        return TymcDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return CreateMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.CreateMan = createMan ;
        this.CreateManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return CreateManDirtyFlag ;
    }

    /**
     * 获取 [JQXTBYDNAME]
     */
    @JsonProperty("jqxtbydname")
    public String getJQXTBYDName(){
        return JQXTBYDName ;
    }

    /**
     * 设置 [JQXTBYDNAME]
     */
    @JsonProperty("jqxtbydname")
    public void setJQXTBYDName(String  jQXTBYDName){
        this.JQXTBYDName = jQXTBYDName ;
        this.JQXTBYDNameDirtyFlag = true ;
    }

    /**
     * 获取 [JQXTBYDNAME]脏标记
     */
    @JsonIgnore
    public boolean getJQXTBYDNameDirtyFlag(){
        return JQXTBYDNameDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return UpdateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.UpdateMan = updateMan ;
        this.UpdateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return UpdateManDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return CreateDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.CreateDate = createDate ;
        this.CreateDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return CreateDateDirtyFlag ;
    }

    /**
     * 获取 [TYNR]
     */
    @JsonProperty("tynr")
    public String getTynr(){
        return Tynr ;
    }

    /**
     * 设置 [TYNR]
     */
    @JsonProperty("tynr")
    public void setTynr(String  tynr){
        this.Tynr = tynr ;
        this.TynrDirtyFlag = true ;
    }

    /**
     * 获取 [TYNR]脏标记
     */
    @JsonIgnore
    public boolean getTynrDirtyFlag(){
        return TynrDirtyFlag ;
    }

    /**
     * 获取 [JQXTBYDID]
     */
    @JsonProperty("jqxtbydid")
    public String getJQXTBYDId(){
        return JQXTBYDId ;
    }

    /**
     * 设置 [JQXTBYDID]
     */
    @JsonProperty("jqxtbydid")
    public void setJQXTBYDId(String  jQXTBYDId){
        this.JQXTBYDId = jQXTBYDId ;
        this.JQXTBYDIdDirtyFlag = true ;
    }

    /**
     * 获取 [JQXTBYDID]脏标记
     */
    @JsonIgnore
    public boolean getJQXTBYDIdDirtyFlag(){
        return JQXTBYDIdDirtyFlag ;
    }

    /**
     * 获取 [XH]
     */
    @JsonProperty("xh")
    public Integer getXh(){
        return Xh ;
    }

    /**
     * 设置 [XH]
     */
    @JsonProperty("xh")
    public void setXh(Integer  xh){
        this.Xh = xh ;
        this.XhDirtyFlag = true ;
    }

    /**
     * 获取 [XH]脏标记
     */
    @JsonIgnore
    public boolean getXhDirtyFlag(){
        return XhDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return UpdateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.UpdateDate = updateDate ;
        this.UpdateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return UpdateDateDirtyFlag ;
    }

    /**
     * 获取 [TBYDKNAME]
     */
    @JsonProperty("tbydkname")
    public String getTBYDKName(){
        return TBYDKName ;
    }

    /**
     * 设置 [TBYDKNAME]
     */
    @JsonProperty("tbydkname")
    public void setTBYDKName(String  tBYDKName){
        this.TBYDKName = tBYDKName ;
        this.TBYDKNameDirtyFlag = true ;
    }

    /**
     * 获取 [TBYDKNAME]脏标记
     */
    @JsonIgnore
    public boolean getTBYDKNameDirtyFlag(){
        return TBYDKNameDirtyFlag ;
    }

    /**
     * 获取 [TBYDKID]
     */
    @JsonProperty("tbydkid")
    public String getTBYDKId(){
        return TBYDKId ;
    }

    /**
     * 设置 [TBYDKID]
     */
    @JsonProperty("tbydkid")
    public void setTBYDKId(String  tBYDKId){
        this.TBYDKId = tBYDKId ;
        this.TBYDKIdDirtyFlag = true ;
    }

    /**
     * 获取 [TBYDKID]脏标记
     */
    @JsonIgnore
    public boolean getTBYDKIdDirtyFlag(){
        return TBYDKIdDirtyFlag ;
    }

    /**
     * 获取 [CIDID]
     */
    @JsonProperty("cidid")
    public String getCIDId(){
        return CIDId ;
    }

    /**
     * 设置 [CIDID]
     */
    @JsonProperty("cidid")
    public void setCIDId(String  cIDId){
        this.CIDId = cIDId ;
        this.CIDIdDirtyFlag = true ;
    }

    /**
     * 获取 [CIDID]脏标记
     */
    @JsonIgnore
    public boolean getCIDIdDirtyFlag(){
        return CIDIdDirtyFlag ;
    }



    public JQXTBYD toDO() {

        JQXTBYD srfdomain = new JQXTBYD();
        if(getTymcDirtyFlag())
            srfdomain.setTymc(Tymc);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(CreateMan);
        if(getJQXTBYDNameDirtyFlag())
            srfdomain.setJQXTBYDName(JQXTBYDName);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(UpdateMan);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(CreateDate);
        if(getTynrDirtyFlag())
            srfdomain.setTynr(Tynr);
        if(getJQXTBYDIdDirtyFlag())
            srfdomain.setJQXTBYDId(JQXTBYDId);
        if(getXhDirtyFlag())
            srfdomain.setXh(Xh);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(UpdateDate);
        if(getTBYDKNameDirtyFlag())
            srfdomain.setTBYDKName(TBYDKName);
        if(getTBYDKIdDirtyFlag())
            srfdomain.setTBYDKId(TBYDKId);
        if(getCIDIdDirtyFlag())
            srfdomain.setCIDId(CIDId);
        return srfdomain;
    }

    public void fromDO(JQXTBYD srfdomain) {

        if(srfdomain.getTymcDirtyFlag())
            this.setTymc(srfdomain.getTymc());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getJQXTBYDNameDirtyFlag())
            this.setJQXTBYDName(srfdomain.getJQXTBYDName());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getTynrDirtyFlag())
            this.setTynr(srfdomain.getTynr());
        if(srfdomain.getJQXTBYDIdDirtyFlag())
            this.setJQXTBYDId(srfdomain.getJQXTBYDId());
        if(srfdomain.getXhDirtyFlag())
            this.setXh(srfdomain.getXh());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getTBYDKNameDirtyFlag())
            this.setTBYDKName(srfdomain.getTBYDKName());
        if(srfdomain.getTBYDKIdDirtyFlag())
            this.setTBYDKId(srfdomain.getTBYDKId());
        if(srfdomain.getCIDIdDirtyFlag())
            this.setCIDId(srfdomain.getCIDId());

    }

    public List<JQXTBYDDTO> fromDOPage(List<JQXTBYD> poPage)   {
        if(poPage == null)
            return null;
        List<JQXTBYDDTO> dtos=new ArrayList<JQXTBYDDTO>();
        for(JQXTBYD domain : poPage) {
            JQXTBYDDTO dto = new JQXTBYDDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

