package com.sinosig.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.module.valuerule.anno.dbd.*;
import com.sinosig.core.module.domain.DBD;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 服务DTO对象[DBDDTO]
 */
public class DBDDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [TBDH]
     *
     */

    @DBDTbdhDefault(info = "默认规则")
    private String Tbdh;

    @JsonIgnore
    private boolean TbdhDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */

    @DBDUpdateDateDefault(info = "默认规则")
    private Timestamp UpdateDate;

    @JsonIgnore
    private boolean UpdateDateDirtyFlag;

    /**
     * 属性 [HBXX]
     *
     */

    @DBDHbxxDefault(info = "默认规则")
    private String Hbxx;

    @JsonIgnore
    private boolean HbxxDirtyFlag;

    /**
     * 属性 [CZR]
     *
     */

    @DBDCzrDefault(info = "默认规则")
    private String Czr;

    @JsonIgnore
    private boolean CzrDirtyFlag;

    /**
     * 属性 [CPH]
     *
     */

    @DBDCphDefault(info = "默认规则")
    private String Cph;

    @JsonIgnore
    private boolean CphDirtyFlag;

    /**
     * 属性 [DBDID]
     *
     */

    @DBDDBDIdDefault(info = "默认规则")
    private String DBDId;

    @JsonIgnore
    private boolean DBDIdDirtyFlag;

    /**
     * 属性 [SRRQ]
     *
     */

    @DBDSrrqDefault(info = "默认规则")
    private Timestamp Srrq;

    @JsonIgnore
    private boolean SrrqDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */

    @DBDUpdateManDefault(info = "默认规则")
    private String UpdateMan;

    @JsonIgnore
    private boolean UpdateManDirtyFlag;

    /**
     * 属性 [DBDNAME]
     *
     */

    @DBDDBDNameDefault(info = "默认规则")
    private String DBDName;

    @JsonIgnore
    private boolean DBDNameDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */

    @DBDCreateManDefault(info = "默认规则")
    private String CreateMan;

    @JsonIgnore
    private boolean CreateManDirtyFlag;

    /**
     * 属性 [BXQQ]
     *
     */

    @DBDBxqqDefault(info = "默认规则")
    private Timestamp Bxqq;

    @JsonIgnore
    private boolean BxqqDirtyFlag;

    /**
     * 属性 [YX]
     *
     */

    @DBDYxDefault(info = "默认规则")
    private String Yx;

    @JsonIgnore
    private boolean YxDirtyFlag;

    /**
     * 属性 [HB]
     *
     */

    @DBDHbDefault(info = "默认规则")
    private String Hb;

    @JsonIgnore
    private boolean HbDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */

    @DBDCreateDateDefault(info = "默认规则")
    private Timestamp CreateDate;

    @JsonIgnore
    private boolean CreateDateDirtyFlag;

    /**
     * 属性 [BBXR]
     *
     */

    @DBDBbxrDefault(info = "默认规则")
    private String Bbxr;

    @JsonIgnore
    private boolean BbxrDirtyFlag;

    /**
     * 属性 [XYH]
     *
     */

    @DBDXyhDefault(info = "默认规则")
    private String Xyh;

    @JsonIgnore
    private boolean XyhDirtyFlag;


    /**
     * 获取 [TBDH]
     */
    @JsonProperty("tbdh")
    public String getTbdh(){
        return Tbdh ;
    }

    /**
     * 设置 [TBDH]
     */
    @JsonProperty("tbdh")
    public void setTbdh(String  tbdh){
        this.Tbdh = tbdh ;
        this.TbdhDirtyFlag = true ;
    }

    /**
     * 获取 [TBDH]脏标记
     */
    @JsonIgnore
    public boolean getTbdhDirtyFlag(){
        return TbdhDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return UpdateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.UpdateDate = updateDate ;
        this.UpdateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return UpdateDateDirtyFlag ;
    }

    /**
     * 获取 [HBXX]
     */
    @JsonProperty("hbxx")
    public String getHbxx(){
        return Hbxx ;
    }

    /**
     * 设置 [HBXX]
     */
    @JsonProperty("hbxx")
    public void setHbxx(String  hbxx){
        this.Hbxx = hbxx ;
        this.HbxxDirtyFlag = true ;
    }

    /**
     * 获取 [HBXX]脏标记
     */
    @JsonIgnore
    public boolean getHbxxDirtyFlag(){
        return HbxxDirtyFlag ;
    }

    /**
     * 获取 [CZR]
     */
    @JsonProperty("czr")
    public String getCzr(){
        return Czr ;
    }

    /**
     * 设置 [CZR]
     */
    @JsonProperty("czr")
    public void setCzr(String  czr){
        this.Czr = czr ;
        this.CzrDirtyFlag = true ;
    }

    /**
     * 获取 [CZR]脏标记
     */
    @JsonIgnore
    public boolean getCzrDirtyFlag(){
        return CzrDirtyFlag ;
    }

    /**
     * 获取 [CPH]
     */
    @JsonProperty("cph")
    public String getCph(){
        return Cph ;
    }

    /**
     * 设置 [CPH]
     */
    @JsonProperty("cph")
    public void setCph(String  cph){
        this.Cph = cph ;
        this.CphDirtyFlag = true ;
    }

    /**
     * 获取 [CPH]脏标记
     */
    @JsonIgnore
    public boolean getCphDirtyFlag(){
        return CphDirtyFlag ;
    }

    /**
     * 获取 [DBDID]
     */
    @JsonProperty("dbdid")
    public String getDBDId(){
        return DBDId ;
    }

    /**
     * 设置 [DBDID]
     */
    @JsonProperty("dbdid")
    public void setDBDId(String  dBDId){
        this.DBDId = dBDId ;
        this.DBDIdDirtyFlag = true ;
    }

    /**
     * 获取 [DBDID]脏标记
     */
    @JsonIgnore
    public boolean getDBDIdDirtyFlag(){
        return DBDIdDirtyFlag ;
    }

    /**
     * 获取 [SRRQ]
     */
    @JsonProperty("srrq")
    public Timestamp getSrrq(){
        return Srrq ;
    }

    /**
     * 设置 [SRRQ]
     */
    @JsonProperty("srrq")
    public void setSrrq(Timestamp  srrq){
        this.Srrq = srrq ;
        this.SrrqDirtyFlag = true ;
    }

    /**
     * 获取 [SRRQ]脏标记
     */
    @JsonIgnore
    public boolean getSrrqDirtyFlag(){
        return SrrqDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return UpdateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.UpdateMan = updateMan ;
        this.UpdateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return UpdateManDirtyFlag ;
    }

    /**
     * 获取 [DBDNAME]
     */
    @JsonProperty("dbdname")
    public String getDBDName(){
        return DBDName ;
    }

    /**
     * 设置 [DBDNAME]
     */
    @JsonProperty("dbdname")
    public void setDBDName(String  dBDName){
        this.DBDName = dBDName ;
        this.DBDNameDirtyFlag = true ;
    }

    /**
     * 获取 [DBDNAME]脏标记
     */
    @JsonIgnore
    public boolean getDBDNameDirtyFlag(){
        return DBDNameDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return CreateMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.CreateMan = createMan ;
        this.CreateManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return CreateManDirtyFlag ;
    }

    /**
     * 获取 [BXQQ]
     */
    @JsonProperty("bxqq")
    public Timestamp getBxqq(){
        return Bxqq ;
    }

    /**
     * 设置 [BXQQ]
     */
    @JsonProperty("bxqq")
    public void setBxqq(Timestamp  bxqq){
        this.Bxqq = bxqq ;
        this.BxqqDirtyFlag = true ;
    }

    /**
     * 获取 [BXQQ]脏标记
     */
    @JsonIgnore
    public boolean getBxqqDirtyFlag(){
        return BxqqDirtyFlag ;
    }

    /**
     * 获取 [YX]
     */
    @JsonProperty("yx")
    public String getYx(){
        return Yx ;
    }

    /**
     * 设置 [YX]
     */
    @JsonProperty("yx")
    public void setYx(String  yx){
        this.Yx = yx ;
        this.YxDirtyFlag = true ;
    }

    /**
     * 获取 [YX]脏标记
     */
    @JsonIgnore
    public boolean getYxDirtyFlag(){
        return YxDirtyFlag ;
    }

    /**
     * 获取 [HB]
     */
    @JsonProperty("hb")
    public String getHb(){
        return Hb ;
    }

    /**
     * 设置 [HB]
     */
    @JsonProperty("hb")
    public void setHb(String  hb){
        this.Hb = hb ;
        this.HbDirtyFlag = true ;
    }

    /**
     * 获取 [HB]脏标记
     */
    @JsonIgnore
    public boolean getHbDirtyFlag(){
        return HbDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return CreateDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.CreateDate = createDate ;
        this.CreateDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return CreateDateDirtyFlag ;
    }

    /**
     * 获取 [BBXR]
     */
    @JsonProperty("bbxr")
    public String getBbxr(){
        return Bbxr ;
    }

    /**
     * 设置 [BBXR]
     */
    @JsonProperty("bbxr")
    public void setBbxr(String  bbxr){
        this.Bbxr = bbxr ;
        this.BbxrDirtyFlag = true ;
    }

    /**
     * 获取 [BBXR]脏标记
     */
    @JsonIgnore
    public boolean getBbxrDirtyFlag(){
        return BbxrDirtyFlag ;
    }

    /**
     * 获取 [XYH]
     */
    @JsonProperty("xyh")
    public String getXyh(){
        return Xyh ;
    }

    /**
     * 设置 [XYH]
     */
    @JsonProperty("xyh")
    public void setXyh(String  xyh){
        this.Xyh = xyh ;
        this.XyhDirtyFlag = true ;
    }

    /**
     * 获取 [XYH]脏标记
     */
    @JsonIgnore
    public boolean getXyhDirtyFlag(){
        return XyhDirtyFlag ;
    }



    public DBD toDO() {

        DBD srfdomain = new DBD();
        if(getTbdhDirtyFlag())
            srfdomain.setTbdh(Tbdh);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(UpdateDate);
        if(getHbxxDirtyFlag())
            srfdomain.setHbxx(Hbxx);
        if(getCzrDirtyFlag())
            srfdomain.setCzr(Czr);
        if(getCphDirtyFlag())
            srfdomain.setCph(Cph);
        if(getDBDIdDirtyFlag())
            srfdomain.setDBDId(DBDId);
        if(getSrrqDirtyFlag())
            srfdomain.setSrrq(Srrq);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(UpdateMan);
        if(getDBDNameDirtyFlag())
            srfdomain.setDBDName(DBDName);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(CreateMan);
        if(getBxqqDirtyFlag())
            srfdomain.setBxqq(Bxqq);
        if(getYxDirtyFlag())
            srfdomain.setYx(Yx);
        if(getHbDirtyFlag())
            srfdomain.setHb(Hb);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(CreateDate);
        if(getBbxrDirtyFlag())
            srfdomain.setBbxr(Bbxr);
        if(getXyhDirtyFlag())
            srfdomain.setXyh(Xyh);
        return srfdomain;
    }

    public void fromDO(DBD srfdomain) {

        if(srfdomain.getTbdhDirtyFlag())
            this.setTbdh(srfdomain.getTbdh());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getHbxxDirtyFlag())
            this.setHbxx(srfdomain.getHbxx());
        if(srfdomain.getCzrDirtyFlag())
            this.setCzr(srfdomain.getCzr());
        if(srfdomain.getCphDirtyFlag())
            this.setCph(srfdomain.getCph());
        if(srfdomain.getDBDIdDirtyFlag())
            this.setDBDId(srfdomain.getDBDId());
        if(srfdomain.getSrrqDirtyFlag())
            this.setSrrq(srfdomain.getSrrq());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getDBDNameDirtyFlag())
            this.setDBDName(srfdomain.getDBDName());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getBxqqDirtyFlag())
            this.setBxqq(srfdomain.getBxqq());
        if(srfdomain.getYxDirtyFlag())
            this.setYx(srfdomain.getYx());
        if(srfdomain.getHbDirtyFlag())
            this.setHb(srfdomain.getHb());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getBbxrDirtyFlag())
            this.setBbxr(srfdomain.getBbxr());
        if(srfdomain.getXyhDirtyFlag())
            this.setXyh(srfdomain.getXyh());

    }

    public List<DBDDTO> fromDOPage(List<DBD> poPage)   {
        if(poPage == null)
            return null;
        List<DBDDTO> dtos=new ArrayList<DBDDTO>();
        for(DBD domain : poPage) {
            DBDDTO dto = new DBDDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

