package com.sinosig.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.module.valuerule.anno.customer.*;
import com.sinosig.core.module.domain.CUSTOMER;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 服务DTO对象[CUSTOMERDTO]
 */
public class CUSTOMERDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [KHLX]
     *
     */

    @CUSTOMERKhlxDefault(info = "默认规则")
    private String Khlx;

    @JsonIgnore
    private boolean KhlxDirtyFlag;

    /**
     * 属性 [ZJLX]
     *
     */

    @CUSTOMERZjlxDefault(info = "默认规则")
    private String Zjlx;

    @JsonIgnore
    private boolean ZjlxDirtyFlag;

    /**
     * 属性 [CUSTOMERID]
     *
     */

    @CUSTOMERCUSTOMERIdDefault(info = "默认规则")
    private String CUSTOMERId;

    @JsonIgnore
    private boolean CUSTOMERIdDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */

    @CUSTOMERUpdateManDefault(info = "默认规则")
    private String UpdateMan;

    @JsonIgnore
    private boolean UpdateManDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */

    @CUSTOMERCreateDateDefault(info = "默认规则")
    private Timestamp CreateDate;

    @JsonIgnore
    private boolean CreateDateDirtyFlag;

    /**
     * 属性 [XB]
     *
     */

    @CUSTOMERXbDefault(info = "默认规则")
    private String Xb;

    @JsonIgnore
    private boolean XbDirtyFlag;

    /**
     * 属性 [CUSTOMERNAME]
     *
     */

    @CUSTOMERCUSTOMERNameDefault(info = "默认规则")
    private String CUSTOMERName;

    @JsonIgnore
    private boolean CUSTOMERNameDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */

    @CUSTOMERCreateManDefault(info = "默认规则")
    private String CreateMan;

    @JsonIgnore
    private boolean CreateManDirtyFlag;

    /**
     * 属性 [CSNY]
     *
     */

    @CUSTOMERCsnyDefault(info = "默认规则")
    private Timestamp Csny;

    @JsonIgnore
    private boolean CsnyDirtyFlag;

    /**
     * 属性 [ZJHM]
     *
     */

    @CUSTOMERZjhmDefault(info = "默认规则")
    private String Zjhm;

    @JsonIgnore
    private boolean ZjhmDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */

    @CUSTOMERUpdateDateDefault(info = "默认规则")
    private Timestamp UpdateDate;

    @JsonIgnore
    private boolean UpdateDateDirtyFlag;

    /**
     * 属性 [NL]
     *
     */

    @CUSTOMERNlDefault(info = "默认规则")
    private Integer Nl;

    @JsonIgnore
    private boolean NlDirtyFlag;

    /**
     * 属性 [CIDID]
     *
     */

    @CUSTOMERCIDIdDefault(info = "默认规则")
    private String CIDId;

    @JsonIgnore
    private boolean CIDIdDirtyFlag;


    /**
     * 获取 [KHLX]
     */
    @JsonProperty("khlx")
    public String getKhlx(){
        return Khlx ;
    }

    /**
     * 设置 [KHLX]
     */
    @JsonProperty("khlx")
    public void setKhlx(String  khlx){
        this.Khlx = khlx ;
        this.KhlxDirtyFlag = true ;
    }

    /**
     * 获取 [KHLX]脏标记
     */
    @JsonIgnore
    public boolean getKhlxDirtyFlag(){
        return KhlxDirtyFlag ;
    }

    /**
     * 获取 [ZJLX]
     */
    @JsonProperty("zjlx")
    public String getZjlx(){
        return Zjlx ;
    }

    /**
     * 设置 [ZJLX]
     */
    @JsonProperty("zjlx")
    public void setZjlx(String  zjlx){
        this.Zjlx = zjlx ;
        this.ZjlxDirtyFlag = true ;
    }

    /**
     * 获取 [ZJLX]脏标记
     */
    @JsonIgnore
    public boolean getZjlxDirtyFlag(){
        return ZjlxDirtyFlag ;
    }

    /**
     * 获取 [CUSTOMERID]
     */
    @JsonProperty("customerid")
    public String getCUSTOMERId(){
        return CUSTOMERId ;
    }

    /**
     * 设置 [CUSTOMERID]
     */
    @JsonProperty("customerid")
    public void setCUSTOMERId(String  cUSTOMERId){
        this.CUSTOMERId = cUSTOMERId ;
        this.CUSTOMERIdDirtyFlag = true ;
    }

    /**
     * 获取 [CUSTOMERID]脏标记
     */
    @JsonIgnore
    public boolean getCUSTOMERIdDirtyFlag(){
        return CUSTOMERIdDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return UpdateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.UpdateMan = updateMan ;
        this.UpdateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return UpdateManDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return CreateDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.CreateDate = createDate ;
        this.CreateDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return CreateDateDirtyFlag ;
    }

    /**
     * 获取 [XB]
     */
    @JsonProperty("xb")
    public String getXb(){
        return Xb ;
    }

    /**
     * 设置 [XB]
     */
    @JsonProperty("xb")
    public void setXb(String  xb){
        this.Xb = xb ;
        this.XbDirtyFlag = true ;
    }

    /**
     * 获取 [XB]脏标记
     */
    @JsonIgnore
    public boolean getXbDirtyFlag(){
        return XbDirtyFlag ;
    }

    /**
     * 获取 [CUSTOMERNAME]
     */
    @JsonProperty("customername")
    public String getCUSTOMERName(){
        return CUSTOMERName ;
    }

    /**
     * 设置 [CUSTOMERNAME]
     */
    @JsonProperty("customername")
    public void setCUSTOMERName(String  cUSTOMERName){
        this.CUSTOMERName = cUSTOMERName ;
        this.CUSTOMERNameDirtyFlag = true ;
    }

    /**
     * 获取 [CUSTOMERNAME]脏标记
     */
    @JsonIgnore
    public boolean getCUSTOMERNameDirtyFlag(){
        return CUSTOMERNameDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return CreateMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.CreateMan = createMan ;
        this.CreateManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return CreateManDirtyFlag ;
    }

    /**
     * 获取 [CSNY]
     */
    @JsonProperty("csny")
    public Timestamp getCsny(){
        return Csny ;
    }

    /**
     * 设置 [CSNY]
     */
    @JsonProperty("csny")
    public void setCsny(Timestamp  csny){
        this.Csny = csny ;
        this.CsnyDirtyFlag = true ;
    }

    /**
     * 获取 [CSNY]脏标记
     */
    @JsonIgnore
    public boolean getCsnyDirtyFlag(){
        return CsnyDirtyFlag ;
    }

    /**
     * 获取 [ZJHM]
     */
    @JsonProperty("zjhm")
    public String getZjhm(){
        return Zjhm ;
    }

    /**
     * 设置 [ZJHM]
     */
    @JsonProperty("zjhm")
    public void setZjhm(String  zjhm){
        this.Zjhm = zjhm ;
        this.ZjhmDirtyFlag = true ;
    }

    /**
     * 获取 [ZJHM]脏标记
     */
    @JsonIgnore
    public boolean getZjhmDirtyFlag(){
        return ZjhmDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return UpdateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.UpdateDate = updateDate ;
        this.UpdateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return UpdateDateDirtyFlag ;
    }

    /**
     * 获取 [NL]
     */
    @JsonProperty("nl")
    public Integer getNl(){
        return Nl ;
    }

    /**
     * 设置 [NL]
     */
    @JsonProperty("nl")
    public void setNl(Integer  nl){
        this.Nl = nl ;
        this.NlDirtyFlag = true ;
    }

    /**
     * 获取 [NL]脏标记
     */
    @JsonIgnore
    public boolean getNlDirtyFlag(){
        return NlDirtyFlag ;
    }

    /**
     * 获取 [CIDID]
     */
    @JsonProperty("cidid")
    public String getCIDId(){
        return CIDId ;
    }

    /**
     * 设置 [CIDID]
     */
    @JsonProperty("cidid")
    public void setCIDId(String  cIDId){
        this.CIDId = cIDId ;
        this.CIDIdDirtyFlag = true ;
    }

    /**
     * 获取 [CIDID]脏标记
     */
    @JsonIgnore
    public boolean getCIDIdDirtyFlag(){
        return CIDIdDirtyFlag ;
    }



    public CUSTOMER toDO() {

        CUSTOMER srfdomain = new CUSTOMER();
        if(getKhlxDirtyFlag())
            srfdomain.setKhlx(Khlx);
        if(getZjlxDirtyFlag())
            srfdomain.setZjlx(Zjlx);
        if(getCUSTOMERIdDirtyFlag())
            srfdomain.setCUSTOMERId(CUSTOMERId);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(UpdateMan);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(CreateDate);
        if(getXbDirtyFlag())
            srfdomain.setXb(Xb);
        if(getCUSTOMERNameDirtyFlag())
            srfdomain.setCUSTOMERName(CUSTOMERName);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(CreateMan);
        if(getCsnyDirtyFlag())
            srfdomain.setCsny(Csny);
        if(getZjhmDirtyFlag())
            srfdomain.setZjhm(Zjhm);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(UpdateDate);
        if(getNlDirtyFlag())
            srfdomain.setNl(Nl);
        if(getCIDIdDirtyFlag())
            srfdomain.setCIDId(CIDId);
        return srfdomain;
    }

    public void fromDO(CUSTOMER srfdomain) {

        if(srfdomain.getKhlxDirtyFlag())
            this.setKhlx(srfdomain.getKhlx());
        if(srfdomain.getZjlxDirtyFlag())
            this.setZjlx(srfdomain.getZjlx());
        if(srfdomain.getCUSTOMERIdDirtyFlag())
            this.setCUSTOMERId(srfdomain.getCUSTOMERId());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getXbDirtyFlag())
            this.setXb(srfdomain.getXb());
        if(srfdomain.getCUSTOMERNameDirtyFlag())
            this.setCUSTOMERName(srfdomain.getCUSTOMERName());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getCsnyDirtyFlag())
            this.setCsny(srfdomain.getCsny());
        if(srfdomain.getZjhmDirtyFlag())
            this.setZjhm(srfdomain.getZjhm());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getNlDirtyFlag())
            this.setNl(srfdomain.getNl());
        if(srfdomain.getCIDIdDirtyFlag())
            this.setCIDId(srfdomain.getCIDId());

    }

    public List<CUSTOMERDTO> fromDOPage(List<CUSTOMER> poPage)   {
        if(poPage == null)
            return null;
        List<CUSTOMERDTO> dtos=new ArrayList<CUSTOMERDTO>();
        for(CUSTOMER domain : poPage) {
            CUSTOMERDTO dto = new CUSTOMERDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

