package com.sinosig.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.sinosig.service.web.dto.CPXHDTO;
import com.sinosig.core.external.domain.CPXH;
import com.sinosig.core.external.service.ICPXHService;
import com.sinosig.util.SearchContext;
import com.sinosig.core.external.filter.CPXHSearchContext;

@Api(tags = {"CPXH" })
@RestController
@RequestMapping("")
public class CPXHResource {

    @Autowired
    private ICPXHService cpxhService;

    public ICPXHService getCpxhService() {
        return this.cpxhService;
    }

    @ApiOperation(value = "Create", tags = {"CPXH" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/cpxhs")

    public ResponseEntity<CPXHDTO> create(@RequestBody CPXHDTO cpxhdto) {
        CPXHDTO dto = new CPXHDTO();
        CPXH domain = cpxhdto.toDO();
		cpxhService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Update", tags = {"CPXH" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/cpxhs/{cpxh_id}")

    public ResponseEntity<CPXHDTO> update(@PathVariable("cpxh_id") String cpxh_id, @RequestBody CPXHDTO cpxhdto) {
		CPXH domain = cpxhdto.toDO();
        domain.setCPXHId(cpxh_id);
		cpxhService.update(domain);
		CPXHDTO dto = new CPXHDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"CPXH" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/cpxhs/{cpxh_id}/getdraft")

    public ResponseEntity<CPXHDTO> getDraft(@PathVariable("cpxh_id") String cpxh_id, @RequestBody CPXHDTO cpxhdto) {
        CPXH cpxh = cpxhdto.toDO();
    	cpxh = cpxhService.getDraft(cpxh) ;
    	cpxhdto.fromDO(cpxh);
        return ResponseEntity.status(HttpStatus.OK).body(cpxhdto);
    }

    @ApiOperation(value = "Remove", tags = {"CPXH" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/cpxhs/{cpxh_id}")

    public ResponseEntity<Boolean> remove(@PathVariable("cpxh_id") String cpxh_id) {
        CPXHDTO cpxhdto = new CPXHDTO();
		CPXH domain = new CPXH();
		cpxhdto.setCPXHId(cpxh_id);
		domain.setCPXHId(cpxh_id);

        Boolean rst = cpxhService.remove(domain.getCPXHId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "CheckKey", tags = {"CPXH" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/cpxhs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody CPXHDTO cpxhdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Save", tags = {"CPXH" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/cpxhs/save")
    public ResponseEntity<Boolean> save(@RequestBody CPXHDTO cpxhdto) {
        CPXH cpxh = cpxhdto.toDO();
    	Boolean b = cpxhService.save(cpxh) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Get", tags = {"CPXH" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/cpxhs/{cpxh_id}")
    public ResponseEntity<CPXHDTO> get(@PathVariable("cpxh_id") String cpxh_id) {
        CPXHDTO dto = new CPXHDTO();
        CPXH domain =new CPXH();
        domain.setCPXHId(cpxh_id);
		cpxhService.get(domain);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"CPXH" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/cpxhs/fetchdefault")
	public ResponseEntity<Page<CPXHDTO>> fetchDefault(CPXHSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<CPXHDTO> list = new ArrayList<CPXHDTO>();
        
        Page<CPXH> domains = cpxhService.searchDefault(context) ;
        for(CPXH cpxh : domains.getContent()){
            CPXHDTO dto = new CPXHDTO();
            dto.fromDO(cpxh);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
