package com.sinosig.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.external.valuerule.anno.jqxbj.*;
import com.sinosig.core.external.domain.JQXBJ;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 服务DTO对象[JQXBJDTO]
 */
public class JQXBJDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [FLXS]
     *
     */

    @JQXBJFlxsDefault(info = "默认规则")
    private Double Flxs;

    @JsonIgnore
    private boolean FlxsDirtyFlag;

    /**
     * 属性 [JQXBJNAME]
     *
     */

    @JQXBJJQXBJNameDefault(info = "默认规则")
    private String JQXBJName;

    @JsonIgnore
    private boolean JQXBJNameDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */

    @JQXBJCreateDateDefault(info = "默认规则")
    private Timestamp CreateDate;

    @JsonIgnore
    private boolean CreateDateDirtyFlag;

    /**
     * 属性 [SJBF]
     *
     */

    @JQXBJSjbfDefault(info = "默认规则")
    private BigDecimal Sjbf;

    @JsonIgnore
    private boolean SjbfDirtyFlag;

    /**
     * 属性 [ZRXE]
     *
     */

    @JQXBJZrxeDefault(info = "默认规则")
    private BigDecimal Zrxe;

    @JsonIgnore
    private boolean ZrxeDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */

    @JQXBJUpdateDateDefault(info = "默认规则")
    private Timestamp UpdateDate;

    @JsonIgnore
    private boolean UpdateDateDirtyFlag;

    /**
     * 属性 [JQXBJID]
     *
     */

    @JQXBJJQXBJIdDefault(info = "默认规则")
    private String JQXBJId;

    @JsonIgnore
    private boolean JQXBJIdDirtyFlag;

    /**
     * 属性 [TKDM]
     *
     */

    @JQXBJTkdmDefault(info = "默认规则")
    private String Tkdm;

    @JsonIgnore
    private boolean TkdmDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */

    @JQXBJCreateManDefault(info = "默认规则")
    private String CreateMan;

    @JsonIgnore
    private boolean CreateManDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */

    @JQXBJUpdateManDefault(info = "默认规则")
    private String UpdateMan;

    @JsonIgnore
    private boolean UpdateManDirtyFlag;

    /**
     * 属性 [TKMC]
     *
     */

    @JQXBJTkmcDefault(info = "默认规则")
    private String Tkmc;

    @JsonIgnore
    private boolean TkmcDirtyFlag;

    /**
     * 属性 [JZBF]
     *
     */

    @JQXBJJzbfDefault(info = "默认规则")
    private BigDecimal Jzbf;

    @JsonIgnore
    private boolean JzbfDirtyFlag;


    /**
     * 获取 [FLXS]
     */
    @JsonProperty("flxs")
    public Double getFlxs(){
        return Flxs ;
    }

    /**
     * 设置 [FLXS]
     */
    @JsonProperty("flxs")
    public void setFlxs(Double  flxs){
        this.Flxs = flxs ;
        this.FlxsDirtyFlag = true ;
    }

    /**
     * 获取 [FLXS]脏标记
     */
    @JsonIgnore
    public boolean getFlxsDirtyFlag(){
        return FlxsDirtyFlag ;
    }

    /**
     * 获取 [JQXBJNAME]
     */
    @JsonProperty("jqxbjname")
    public String getJQXBJName(){
        return JQXBJName ;
    }

    /**
     * 设置 [JQXBJNAME]
     */
    @JsonProperty("jqxbjname")
    public void setJQXBJName(String  jQXBJName){
        this.JQXBJName = jQXBJName ;
        this.JQXBJNameDirtyFlag = true ;
    }

    /**
     * 获取 [JQXBJNAME]脏标记
     */
    @JsonIgnore
    public boolean getJQXBJNameDirtyFlag(){
        return JQXBJNameDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return CreateDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.CreateDate = createDate ;
        this.CreateDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return CreateDateDirtyFlag ;
    }

    /**
     * 获取 [SJBF]
     */
    @JsonProperty("sjbf")
    public BigDecimal getSjbf(){
        return Sjbf ;
    }

    /**
     * 设置 [SJBF]
     */
    @JsonProperty("sjbf")
    public void setSjbf(BigDecimal  sjbf){
        this.Sjbf = sjbf ;
        this.SjbfDirtyFlag = true ;
    }

    /**
     * 获取 [SJBF]脏标记
     */
    @JsonIgnore
    public boolean getSjbfDirtyFlag(){
        return SjbfDirtyFlag ;
    }

    /**
     * 获取 [ZRXE]
     */
    @JsonProperty("zrxe")
    public BigDecimal getZrxe(){
        return Zrxe ;
    }

    /**
     * 设置 [ZRXE]
     */
    @JsonProperty("zrxe")
    public void setZrxe(BigDecimal  zrxe){
        this.Zrxe = zrxe ;
        this.ZrxeDirtyFlag = true ;
    }

    /**
     * 获取 [ZRXE]脏标记
     */
    @JsonIgnore
    public boolean getZrxeDirtyFlag(){
        return ZrxeDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return UpdateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.UpdateDate = updateDate ;
        this.UpdateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return UpdateDateDirtyFlag ;
    }

    /**
     * 获取 [JQXBJID]
     */
    @JsonProperty("jqxbjid")
    public String getJQXBJId(){
        return JQXBJId ;
    }

    /**
     * 设置 [JQXBJID]
     */
    @JsonProperty("jqxbjid")
    public void setJQXBJId(String  jQXBJId){
        this.JQXBJId = jQXBJId ;
        this.JQXBJIdDirtyFlag = true ;
    }

    /**
     * 获取 [JQXBJID]脏标记
     */
    @JsonIgnore
    public boolean getJQXBJIdDirtyFlag(){
        return JQXBJIdDirtyFlag ;
    }

    /**
     * 获取 [TKDM]
     */
    @JsonProperty("tkdm")
    public String getTkdm(){
        return Tkdm ;
    }

    /**
     * 设置 [TKDM]
     */
    @JsonProperty("tkdm")
    public void setTkdm(String  tkdm){
        this.Tkdm = tkdm ;
        this.TkdmDirtyFlag = true ;
    }

    /**
     * 获取 [TKDM]脏标记
     */
    @JsonIgnore
    public boolean getTkdmDirtyFlag(){
        return TkdmDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return CreateMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.CreateMan = createMan ;
        this.CreateManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return CreateManDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return UpdateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.UpdateMan = updateMan ;
        this.UpdateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return UpdateManDirtyFlag ;
    }

    /**
     * 获取 [TKMC]
     */
    @JsonProperty("tkmc")
    public String getTkmc(){
        return Tkmc ;
    }

    /**
     * 设置 [TKMC]
     */
    @JsonProperty("tkmc")
    public void setTkmc(String  tkmc){
        this.Tkmc = tkmc ;
        this.TkmcDirtyFlag = true ;
    }

    /**
     * 获取 [TKMC]脏标记
     */
    @JsonIgnore
    public boolean getTkmcDirtyFlag(){
        return TkmcDirtyFlag ;
    }

    /**
     * 获取 [JZBF]
     */
    @JsonProperty("jzbf")
    public BigDecimal getJzbf(){
        return Jzbf ;
    }

    /**
     * 设置 [JZBF]
     */
    @JsonProperty("jzbf")
    public void setJzbf(BigDecimal  jzbf){
        this.Jzbf = jzbf ;
        this.JzbfDirtyFlag = true ;
    }

    /**
     * 获取 [JZBF]脏标记
     */
    @JsonIgnore
    public boolean getJzbfDirtyFlag(){
        return JzbfDirtyFlag ;
    }



    public JQXBJ toDO() {

        JQXBJ srfdomain = new JQXBJ();
        if(getFlxsDirtyFlag())
            srfdomain.setFlxs(Flxs);
        if(getJQXBJNameDirtyFlag())
            srfdomain.setJQXBJName(JQXBJName);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(CreateDate);
        if(getSjbfDirtyFlag())
            srfdomain.setSjbf(Sjbf);
        if(getZrxeDirtyFlag())
            srfdomain.setZrxe(Zrxe);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(UpdateDate);
        if(getJQXBJIdDirtyFlag())
            srfdomain.setJQXBJId(JQXBJId);
        if(getTkdmDirtyFlag())
            srfdomain.setTkdm(Tkdm);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(CreateMan);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(UpdateMan);
        if(getTkmcDirtyFlag())
            srfdomain.setTkmc(Tkmc);
        if(getJzbfDirtyFlag())
            srfdomain.setJzbf(Jzbf);
        return srfdomain;
    }

    public void fromDO(JQXBJ srfdomain) {

        if(srfdomain.getFlxsDirtyFlag())
            this.setFlxs(srfdomain.getFlxs());
        if(srfdomain.getJQXBJNameDirtyFlag())
            this.setJQXBJName(srfdomain.getJQXBJName());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getSjbfDirtyFlag())
            this.setSjbf(srfdomain.getSjbf());
        if(srfdomain.getZrxeDirtyFlag())
            this.setZrxe(srfdomain.getZrxe());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getJQXBJIdDirtyFlag())
            this.setJQXBJId(srfdomain.getJQXBJId());
        if(srfdomain.getTkdmDirtyFlag())
            this.setTkdm(srfdomain.getTkdm());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getTkmcDirtyFlag())
            this.setTkmc(srfdomain.getTkmc());
        if(srfdomain.getJzbfDirtyFlag())
            this.setJzbf(srfdomain.getJzbf());

    }

    public List<JQXBJDTO> fromDOPage(List<JQXBJ> poPage)   {
        if(poPage == null)
            return null;
        List<JQXBJDTO> dtos=new ArrayList<JQXBJDTO>();
        for(JQXBJ domain : poPage) {
            JQXBJDTO dto = new JQXBJDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

