package com.sinosig.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.sinosig.service.web.dto.TBYDKDTO;
import com.sinosig.core.module.domain.TBYDK;
import com.sinosig.core.module.service.ITBYDKService;
import com.sinosig.util.SearchContext;
import com.sinosig.core.module.filter.TBYDKSearchContext;

@Api(tags = {"TBYDK" })
@RestController
@RequestMapping("")
public class TBYDKResource {

    @Autowired
    private ITBYDKService tbydkService;

    public ITBYDKService getTbydkService() {
        return this.tbydkService;
    }

    @ApiOperation(value = "Create", tags = {"TBYDK" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/tbydks")
    @Transactional
    public ResponseEntity<TBYDKDTO> create(@RequestBody TBYDKDTO tbydkdto) {
        TBYDKDTO dto = new TBYDKDTO();
        TBYDK domain = tbydkdto.toDO();
		tbydkService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Get", tags = {"TBYDK" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/tbydks/{tbydk_id}")
    public ResponseEntity<TBYDKDTO> get(@PathVariable("tbydk_id") String tbydk_id) {
        TBYDKDTO dto = new TBYDKDTO();
        TBYDK domain =new TBYDK();
        domain.setTBYDKId(tbydk_id);
		tbydkService.get(domain);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Update", tags = {"TBYDK" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/tbydks/{tbydk_id}")
    @Transactional
    public ResponseEntity<TBYDKDTO> update(@PathVariable("tbydk_id") String tbydk_id, @RequestBody TBYDKDTO tbydkdto) {
		TBYDK domain = tbydkdto.toDO();
        domain.setTBYDKId(tbydk_id);
		tbydkService.update(domain);
		TBYDKDTO dto = new TBYDKDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKey", tags = {"TBYDK" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/tbydks/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody TBYDKDTO tbydkdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Save", tags = {"TBYDK" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/tbydks/save")
    public ResponseEntity<Boolean> save(@RequestBody TBYDKDTO tbydkdto) {
        TBYDK tbydk = tbydkdto.toDO();
    	Boolean b = tbydkService.save(tbydk) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "GetDraft", tags = {"TBYDK" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/tbydks/{tbydk_id}/getdraft")
    @Transactional
    public ResponseEntity<TBYDKDTO> getDraft(@PathVariable("tbydk_id") String tbydk_id, @RequestBody TBYDKDTO tbydkdto) {
        TBYDK tbydk = tbydkdto.toDO();
    	tbydk = tbydkService.getDraft(tbydk) ;
    	tbydkdto.fromDO(tbydk);
        return ResponseEntity.status(HttpStatus.OK).body(tbydkdto);
    }

    @ApiOperation(value = "Remove", tags = {"TBYDK" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/tbydks/{tbydk_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("tbydk_id") String tbydk_id) {
        TBYDKDTO tbydkdto = new TBYDKDTO();
		TBYDK domain = new TBYDK();
		tbydkdto.setTBYDKId(tbydk_id);
		domain.setTBYDKId(tbydk_id);

        Boolean rst = tbydkService.remove(domain.getTBYDKId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"TBYDK" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/tbydks/fetchdefault")
	public ResponseEntity<Page<TBYDKDTO>> fetchDefault(TBYDKSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<TBYDKDTO> list = new ArrayList<TBYDKDTO>();
        
        Page<TBYDK> domains = tbydkService.searchDefault(context) ;
        for(TBYDK tbydk : domains.getContent()){
            TBYDKDTO dto = new TBYDKDTO();
            dto.fromDO(tbydk);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}

	@ApiOperation(value = "获取JQX", tags = {"TBYDK" } ,notes = "获取JQX")
    @RequestMapping(method= RequestMethod.GET , value="/web/tbydks/fetchjqx")
	public ResponseEntity<Page<TBYDKDTO>> fetchJQX(TBYDKSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<TBYDKDTO> list = new ArrayList<TBYDKDTO>();
        
        Page<TBYDK> domains = tbydkService.searchJQX(context) ;
        for(TBYDK tbydk : domains.getContent()){
            TBYDKDTO dto = new TBYDKDTO();
            dto.fromDO(tbydk);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}

	@ApiOperation(value = "获取SYX", tags = {"TBYDK" } ,notes = "获取SYX")
    @RequestMapping(method= RequestMethod.GET , value="/web/tbydks/fetchsyx")
	public ResponseEntity<Page<TBYDKDTO>> fetchSYX(TBYDKSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<TBYDKDTO> list = new ArrayList<TBYDKDTO>();
        
        Page<TBYDK> domains = tbydkService.searchSYX(context) ;
        for(TBYDK tbydk : domains.getContent()){
            TBYDKDTO dto = new TBYDKDTO();
            dto.fromDO(tbydk);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
