package com.sinosig.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.sinosig.service.web.dto.SJZDDTO;
import com.sinosig.core.module.domain.SJZD;
import com.sinosig.core.module.service.ISJZDService;
import com.sinosig.util.SearchContext;
import com.sinosig.core.module.filter.SJZDSearchContext;

@Api(tags = {"SJZD" })
@RestController
@RequestMapping("")
public class SJZDResource {

    @Autowired
    private ISJZDService sjzdService;

    public ISJZDService getSjzdService() {
        return this.sjzdService;
    }

    @ApiOperation(value = "Update", tags = {"SJZD" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/sjzds/{sjzd_id}")
    @Transactional
    public ResponseEntity<SJZDDTO> update(@PathVariable("sjzd_id") String sjzd_id, @RequestBody SJZDDTO sjzddto) {
		SJZD domain = sjzddto.toDO();
        domain.setSJZDId(sjzd_id);
		sjzdService.update(domain);
		SJZDDTO dto = new SJZDDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Remove", tags = {"SJZD" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/sjzds/{sjzd_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("sjzd_id") String sjzd_id) {
        SJZDDTO sjzddto = new SJZDDTO();
		SJZD domain = new SJZD();
		sjzddto.setSJZDId(sjzd_id);
		domain.setSJZDId(sjzd_id);

        Boolean rst = sjzdService.remove(domain.getSJZDId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "GetDraft", tags = {"SJZD" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/sjzds/{sjzd_id}/getdraft")
    @Transactional
    public ResponseEntity<SJZDDTO> getDraft(@PathVariable("sjzd_id") String sjzd_id, @RequestBody SJZDDTO sjzddto) {
        SJZD sjzd = sjzddto.toDO();
    	sjzd = sjzdService.getDraft(sjzd) ;
    	sjzddto.fromDO(sjzd);
        return ResponseEntity.status(HttpStatus.OK).body(sjzddto);
    }

    @ApiOperation(value = "Get", tags = {"SJZD" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/sjzds/{sjzd_id}")
    public ResponseEntity<SJZDDTO> get(@PathVariable("sjzd_id") String sjzd_id) {
        SJZDDTO dto = new SJZDDTO();
        SJZD domain =new SJZD();
        domain.setSJZDId(sjzd_id);
		sjzdService.get(domain);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKey", tags = {"SJZD" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/sjzds/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody SJZDDTO sjzddto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Create", tags = {"SJZD" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/sjzds")
    @Transactional
    public ResponseEntity<SJZDDTO> create(@RequestBody SJZDDTO sjzddto) {
        SJZDDTO dto = new SJZDDTO();
        SJZD domain = sjzddto.toDO();
		sjzdService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Save", tags = {"SJZD" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/sjzds/save")
    public ResponseEntity<Boolean> save(@RequestBody SJZDDTO sjzddto) {
        SJZD sjzd = sjzddto.toDO();
    	Boolean b = sjzdService.save(sjzd) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"SJZD" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/sjzds/fetchdefault")
	public ResponseEntity<Page<SJZDDTO>> fetchDefault(SJZDSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<SJZDDTO> list = new ArrayList<SJZDDTO>();
        
        Page<SJZD> domains = sjzdService.searchDefault(context) ;
        for(SJZD sjzd : domains.getContent()){
            SJZDDTO dto = new SJZDDTO();
            dto.fromDO(sjzd);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
