package com.sinosig.service.web.resource;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.domain.PageRequest;
import com.sinosig.service.web.dto.ORGDTO;
import com.sinosig.core.external.domain.ORG;
import com.sinosig.core.external.service.IORGService;
import com.sinosig.util.SearchContext;
import com.sinosig.core.external.filter.ORGSearchContext;

@Api(tags = {"ORG" })
@RestController
@RequestMapping("")
public class ORGResource {

    @Autowired
    private IORGService orgService;

    public IORGService getOrgService() {
        return this.orgService;
    }

	@ApiOperation(value = "获取顶级组织", tags = {"ORG" } ,notes = "获取顶级组织")
    @RequestMapping(method= RequestMethod.GET , value="/web/orgs/fetchtoporg")
	public ResponseEntity<Page<ORGDTO>> fetchTopOrg(ORGSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<ORGDTO> list = new ArrayList<ORGDTO>();
        
        Page<ORG> domains = orgService.searchTopOrg(context) ;
        for(ORG org : domains.getContent()){
            ORGDTO dto = new ORGDTO();
            dto.fromDO(org);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}

	@ApiOperation(value = "获取当前组织", tags = {"ORG" } ,notes = "获取当前组织")
    @RequestMapping(method= RequestMethod.GET , value="/web/orgs/fetchcurorg")
	public ResponseEntity<Page<ORGDTO>> fetchCurOrg(ORGSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<ORGDTO> list = new ArrayList<ORGDTO>();
        
        Page<ORG> domains = orgService.searchCurOrg(context) ;
        for(ORG org : domains.getContent()){
            ORGDTO dto = new ORGDTO();
            dto.fromDO(org);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}

    @ApiOperation(value = "CheckKey", tags = {"ORG" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody ORGDTO orgdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "Create", tags = {"ORG" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgs")

    public ResponseEntity<ORGDTO> create(@RequestBody ORGDTO orgdto) {
        ORGDTO dto = new ORGDTO();
        ORG domain = orgdto.toDO();
		orgService.create(domain);
        dto.fromDO(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Get", tags = {"ORG" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgs/{org_id}")
    public ResponseEntity<ORGDTO> get(@PathVariable("org_id") String org_id) {
        ORGDTO dto = new ORGDTO();
        ORG domain =new ORG();
        domain.setORGId(org_id);
		orgService.get(domain);
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "Save", tags = {"ORG" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/web/orgs/save")
    public ResponseEntity<Boolean> save(@RequestBody ORGDTO orgdto) {
        ORG org = orgdto.toDO();
    	Boolean b = orgService.save(org) ;
        return ResponseEntity.status(HttpStatus.OK).body(b);
    }

    @ApiOperation(value = "Remove", tags = {"ORG" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/web/orgs/{org_id}")

    public ResponseEntity<Boolean> remove(@PathVariable("org_id") String org_id) {
        ORGDTO orgdto = new ORGDTO();
		ORG domain = new ORG();
		orgdto.setORGId(org_id);
		domain.setORGId(org_id);

        Boolean rst = orgService.remove(domain.getORGId());
        if(rst){
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}else{
			return ResponseEntity.status(HttpStatus.OK).body(rst);
		}
    }

    @ApiOperation(value = "Update", tags = {"ORG" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/web/orgs/{org_id}")

    public ResponseEntity<ORGDTO> update(@PathVariable("org_id") String org_id, @RequestBody ORGDTO orgdto) {
		ORG domain = orgdto.toDO();
        domain.setORGId(org_id);
		orgService.update(domain);
		ORGDTO dto = new ORGDTO();
		dto.fromDO(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"ORG" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/web/orgs/{org_id}/getdraft")

    public ResponseEntity<ORGDTO> getDraft(@PathVariable("org_id") String org_id, @RequestBody ORGDTO orgdto) {
        ORG org = orgdto.toDO();
    	org = orgService.getDraft(org) ;
    	orgdto.fromDO(org);
        return ResponseEntity.status(HttpStatus.OK).body(orgdto);
    }

	@ApiOperation(value = "获取DEFAULT", tags = {"ORG" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/web/orgs/fetchdefault")
	public ResponseEntity<Page<ORGDTO>> fetchDefault(ORGSearchContext context,Pageable pageable ,ServletRequest request) {
        context.setPageable(pageable);
        List<ORGDTO> list = new ArrayList<ORGDTO>();
        
        Page<ORG> domains = orgService.searchDefault(context) ;
        for(ORG org : domains.getContent()){
            ORGDTO dto = new ORGDTO();
            dto.fromDO(org);
            list.add(dto);
        }
	    return ResponseEntity.status(HttpStatus.OK).body(new PageImpl(list,context.getPageable(),domains.getTotalElements()));
	}


}
