package com.sinosig.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.module.valuerule.anno.sjzd.*;
import com.sinosig.core.module.domain.SJZD;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 服务DTO对象[SJZDDTO]
 */
public class SJZDDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [UPDATEDATE]
     *
     */

    @SJZDUpdateDateDefault(info = "默认规则")
    private Timestamp UpdateDate;

    @JsonIgnore
    private boolean UpdateDateDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */

    @SJZDUpdateManDefault(info = "默认规则")
    private String UpdateMan;

    @JsonIgnore
    private boolean UpdateManDirtyFlag;

    /**
     * 属性 [SJZDNAME]
     *
     */

    @SJZDSJZDNameDefault(info = "默认规则")
    private String SJZDName;

    @JsonIgnore
    private boolean SJZDNameDirtyFlag;

    /**
     * 属性 [SJZDID]
     *
     */

    @SJZDSJZDIdDefault(info = "默认规则")
    private String SJZDId;

    @JsonIgnore
    private boolean SJZDIdDirtyFlag;

    /**
     * 属性 [BH]
     *
     */

    @SJZDBhDefault(info = "默认规则")
    private String Bh;

    @JsonIgnore
    private boolean BhDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */

    @SJZDCreateManDefault(info = "默认规则")
    private String CreateMan;

    @JsonIgnore
    private boolean CreateManDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */

    @SJZDCreateDateDefault(info = "默认规则")
    private Timestamp CreateDate;

    @JsonIgnore
    private boolean CreateDateDirtyFlag;


    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return UpdateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.UpdateDate = updateDate ;
        this.UpdateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return UpdateDateDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return UpdateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.UpdateMan = updateMan ;
        this.UpdateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return UpdateManDirtyFlag ;
    }

    /**
     * 获取 [SJZDNAME]
     */
    @JsonProperty("sjzdname")
    public String getSJZDName(){
        return SJZDName ;
    }

    /**
     * 设置 [SJZDNAME]
     */
    @JsonProperty("sjzdname")
    public void setSJZDName(String  sJZDName){
        this.SJZDName = sJZDName ;
        this.SJZDNameDirtyFlag = true ;
    }

    /**
     * 获取 [SJZDNAME]脏标记
     */
    @JsonIgnore
    public boolean getSJZDNameDirtyFlag(){
        return SJZDNameDirtyFlag ;
    }

    /**
     * 获取 [SJZDID]
     */
    @JsonProperty("sjzdid")
    public String getSJZDId(){
        return SJZDId ;
    }

    /**
     * 设置 [SJZDID]
     */
    @JsonProperty("sjzdid")
    public void setSJZDId(String  sJZDId){
        this.SJZDId = sJZDId ;
        this.SJZDIdDirtyFlag = true ;
    }

    /**
     * 获取 [SJZDID]脏标记
     */
    @JsonIgnore
    public boolean getSJZDIdDirtyFlag(){
        return SJZDIdDirtyFlag ;
    }

    /**
     * 获取 [BH]
     */
    @JsonProperty("bh")
    public String getBh(){
        return Bh ;
    }

    /**
     * 设置 [BH]
     */
    @JsonProperty("bh")
    public void setBh(String  bh){
        this.Bh = bh ;
        this.BhDirtyFlag = true ;
    }

    /**
     * 获取 [BH]脏标记
     */
    @JsonIgnore
    public boolean getBhDirtyFlag(){
        return BhDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return CreateMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.CreateMan = createMan ;
        this.CreateManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return CreateManDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return CreateDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.CreateDate = createDate ;
        this.CreateDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return CreateDateDirtyFlag ;
    }



    public SJZD toDO() {

        SJZD srfdomain = new SJZD();
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(UpdateDate);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(UpdateMan);
        if(getSJZDNameDirtyFlag())
            srfdomain.setSJZDName(SJZDName);
        if(getSJZDIdDirtyFlag())
            srfdomain.setSJZDId(SJZDId);
        if(getBhDirtyFlag())
            srfdomain.setBh(Bh);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(CreateMan);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(CreateDate);
        return srfdomain;
    }

    public void fromDO(SJZD srfdomain) {

        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getSJZDNameDirtyFlag())
            this.setSJZDName(srfdomain.getSJZDName());
        if(srfdomain.getSJZDIdDirtyFlag())
            this.setSJZDId(srfdomain.getSJZDId());
        if(srfdomain.getBhDirtyFlag())
            this.setBh(srfdomain.getBh());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());

    }

    public List<SJZDDTO> fromDOPage(List<SJZD> poPage)   {
        if(poPage == null)
            return null;
        List<SJZDDTO> dtos=new ArrayList<SJZDDTO>();
        for(SJZD domain : poPage) {
            SJZDDTO dto = new SJZDDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

