package com.sinosig.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.external.valuerule.anno.org.*;
import com.sinosig.core.external.domain.ORG;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 服务DTO对象[ORGDTO]
 */
public class ORGDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [ORGID]
     *
     */

    @ORGORGIdDefault(info = "默认规则")
    private String ORGId;

    @JsonIgnore
    private boolean ORGIdDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */

    @ORGUpdateDateDefault(info = "默认规则")
    private Timestamp UpdateDate;

    @JsonIgnore
    private boolean UpdateDateDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */

    @ORGCreateManDefault(info = "默认规则")
    private String CreateMan;

    @JsonIgnore
    private boolean CreateManDirtyFlag;

    /**
     * 属性 [ORGNAME]
     *
     */

    @ORGORGNameDefault(info = "默认规则")
    private String ORGName;

    @JsonIgnore
    private boolean ORGNameDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */

    @ORGUpdateManDefault(info = "默认规则")
    private String UpdateMan;

    @JsonIgnore
    private boolean UpdateManDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */

    @ORGCreateDateDefault(info = "默认规则")
    private Timestamp CreateDate;

    @JsonIgnore
    private boolean CreateDateDirtyFlag;

    /**
     * 属性 [PORGNAME]
     *
     */

    @ORGPorgnameDefault(info = "默认规则")
    private String Porgname;

    @JsonIgnore
    private boolean PorgnameDirtyFlag;

    /**
     * 属性 [PORGID]
     *
     */

    @ORGPorgidDefault(info = "默认规则")
    private String Porgid;

    @JsonIgnore
    private boolean PorgidDirtyFlag;


    /**
     * 获取 [ORGID]
     */
    @JsonProperty("orgid")
    public String getORGId(){
        return ORGId ;
    }

    /**
     * 设置 [ORGID]
     */
    @JsonProperty("orgid")
    public void setORGId(String  oRGId){
        this.ORGId = oRGId ;
        this.ORGIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGID]脏标记
     */
    @JsonIgnore
    public boolean getORGIdDirtyFlag(){
        return ORGIdDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return UpdateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.UpdateDate = updateDate ;
        this.UpdateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return UpdateDateDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return CreateMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.CreateMan = createMan ;
        this.CreateManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return CreateManDirtyFlag ;
    }

    /**
     * 获取 [ORGNAME]
     */
    @JsonProperty("orgname")
    public String getORGName(){
        return ORGName ;
    }

    /**
     * 设置 [ORGNAME]
     */
    @JsonProperty("orgname")
    public void setORGName(String  oRGName){
        this.ORGName = oRGName ;
        this.ORGNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGNAME]脏标记
     */
    @JsonIgnore
    public boolean getORGNameDirtyFlag(){
        return ORGNameDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return UpdateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.UpdateMan = updateMan ;
        this.UpdateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return UpdateManDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return CreateDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.CreateDate = createDate ;
        this.CreateDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return CreateDateDirtyFlag ;
    }

    /**
     * 获取 [PORGNAME]
     */
    @JsonProperty("porgname")
    public String getPorgname(){
        return Porgname ;
    }

    /**
     * 设置 [PORGNAME]
     */
    @JsonProperty("porgname")
    public void setPorgname(String  porgname){
        this.Porgname = porgname ;
        this.PorgnameDirtyFlag = true ;
    }

    /**
     * 获取 [PORGNAME]脏标记
     */
    @JsonIgnore
    public boolean getPorgnameDirtyFlag(){
        return PorgnameDirtyFlag ;
    }

    /**
     * 获取 [PORGID]
     */
    @JsonProperty("porgid")
    public String getPorgid(){
        return Porgid ;
    }

    /**
     * 设置 [PORGID]
     */
    @JsonProperty("porgid")
    public void setPorgid(String  porgid){
        this.Porgid = porgid ;
        this.PorgidDirtyFlag = true ;
    }

    /**
     * 获取 [PORGID]脏标记
     */
    @JsonIgnore
    public boolean getPorgidDirtyFlag(){
        return PorgidDirtyFlag ;
    }



    public ORG toDO() {

        ORG srfdomain = new ORG();
        if(getORGIdDirtyFlag())
            srfdomain.setORGId(ORGId);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(UpdateDate);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(CreateMan);
        if(getORGNameDirtyFlag())
            srfdomain.setORGName(ORGName);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(UpdateMan);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(CreateDate);
        if(getPorgnameDirtyFlag())
            srfdomain.setPorgname(Porgname);
        if(getPorgidDirtyFlag())
            srfdomain.setPorgid(Porgid);
        return srfdomain;
    }

    public void fromDO(ORG srfdomain) {

        if(srfdomain.getORGIdDirtyFlag())
            this.setORGId(srfdomain.getORGId());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getORGNameDirtyFlag())
            this.setORGName(srfdomain.getORGName());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getPorgnameDirtyFlag())
            this.setPorgname(srfdomain.getPorgname());
        if(srfdomain.getPorgidDirtyFlag())
            this.setPorgid(srfdomain.getPorgid());

    }

    public List<ORGDTO> fromDOPage(List<ORG> poPage)   {
        if(poPage == null)
            return null;
        List<ORGDTO> dtos=new ArrayList<ORGDTO>();
        for(ORG domain : poPage) {
            ORGDTO dto = new ORGDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

