package com.sinosig.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.external.valuerule.anno.cpxh.*;
import com.sinosig.core.external.domain.CPXH;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 服务DTO对象[CPXHDTO]
 */
public class CPXHDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [GL]
     *
     */

    @CPXHGlDefault(info = "默认规则")
    private Double Gl;

    @JsonIgnore
    private boolean GlDirtyFlag;

    /**
     * 属性 [BM]
     *
     */

    @CPXHBmDefault(info = "默认规则")
    private String Bm;

    @JsonIgnore
    private boolean BmDirtyFlag;

    /**
     * 属性 [HPDS]
     *
     */

    @CPXHHpdsDefault(info = "默认规则")
    private String Hpds;

    @JsonIgnore
    private boolean HpdsDirtyFlag;

    /**
     * 属性 [BZ]
     *
     */

    @CPXHBzDefault(info = "默认规则")
    private String Bz;

    @JsonIgnore
    private boolean BzDirtyFlag;

    /**
     * 属性 [CPXHNAME]
     *
     */

    @CPXHCPXHNameDefault(info = "默认规则")
    private String CPXHName;

    @JsonIgnore
    private boolean CPXHNameDirtyFlag;

    /**
     * 属性 [XCGZJ]
     *
     */

    @CPXHXcgzjDefault(info = "默认规则")
    private BigDecimal Xcgzj;

    @JsonIgnore
    private boolean XcgzjDirtyFlag;

    /**
     * 属性 [SSNF]
     *
     */

    @CPXHSsnfDefault(info = "默认规则")
    private String Ssnf;

    @JsonIgnore
    private boolean SsnfDirtyFlag;

    /**
     * 属性 [HDZZL]
     *
     */

    @CPXHHdzzlDefault(info = "默认规则")
    private Double Hdzzl;

    @JsonIgnore
    private boolean HdzzlDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */

    @CPXHCreateDateDefault(info = "默认规则")
    private Timestamp CreateDate;

    @JsonIgnore
    private boolean CreateDateDirtyFlag;

    /**
     * 属性 [ABL]
     *
     */

    @CPXHAblDefault(info = "默认规则")
    private String Abl;

    @JsonIgnore
    private boolean AblDirtyFlag;

    /**
     * 属性 [CLLXMS]
     *
     */

    @CPXHCllxmsDefault(info = "默认规则")
    private String Cllxms;

    @JsonIgnore
    private boolean CllxmsDirtyFlag;

    /**
     * 属性 [HDZK]
     *
     */

    @CPXHHdzkDefault(info = "默认规则")
    private Integer Hdzk;

    @JsonIgnore
    private boolean HdzkDirtyFlag;

    /**
     * 属性 [ZBZL]
     *
     */

    @CPXHZbzlDefault(info = "默认规则")
    private Double Zbzl;

    @JsonIgnore
    private boolean ZbzlDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */

    @CPXHUpdateDateDefault(info = "默认规则")
    private Timestamp UpdateDate;

    @JsonIgnore
    private boolean UpdateDateDirtyFlag;

    /**
     * 属性 [PP]
     *
     */

    @CPXHPpDefault(info = "默认规则")
    private String Pp;

    @JsonIgnore
    private boolean PpDirtyFlag;

    /**
     * 属性 [DYCPXH]
     *
     */

    @CPXHDycpxhDefault(info = "默认规则")
    private String Dycpxh;

    @JsonIgnore
    private boolean DycpxhDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */

    @CPXHCreateManDefault(info = "默认规则")
    private String CreateMan;

    @JsonIgnore
    private boolean CreateManDirtyFlag;

    /**
     * 属性 [CXDM]
     *
     */

    @CPXHCxdmDefault(info = "默认规则")
    private String Cxdm;

    @JsonIgnore
    private boolean CxdmDirtyFlag;

    /**
     * 属性 [PL]
     *
     */

    @CPXHPlDefault(info = "默认规则")
    private Double Pl;

    @JsonIgnore
    private boolean PlDirtyFlag;

    /**
     * 属性 [CPXHID]
     *
     */

    @CPXHCPXHIdDefault(info = "默认规则")
    private String CPXHId;

    @JsonIgnore
    private boolean CPXHIdDirtyFlag;

    /**
     * 属性 [SCCS]
     *
     */

    @CPXHSccsDefault(info = "默认规则")
    private String Sccs;

    @JsonIgnore
    private boolean SccsDirtyFlag;

    /**
     * 属性 [CLSJJZ]
     *
     */

    @CPXHClsjjzDefault(info = "默认规则")
    private BigDecimal Clsjjz;

    @JsonIgnore
    private boolean ClsjjzDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */

    @CPXHUpdateManDefault(info = "默认规则")
    private String UpdateMan;

    @JsonIgnore
    private boolean UpdateManDirtyFlag;

    /**
     * 属性 [CX]
     *
     */

    @CPXHCxDefault(info = "默认规则")
    private String Cx;

    @JsonIgnore
    private boolean CxDirtyFlag;


    /**
     * 获取 [GL]
     */
    @JsonProperty("gl")
    public Double getGl(){
        return Gl ;
    }

    /**
     * 设置 [GL]
     */
    @JsonProperty("gl")
    public void setGl(Double  gl){
        this.Gl = gl ;
        this.GlDirtyFlag = true ;
    }

    /**
     * 获取 [GL]脏标记
     */
    @JsonIgnore
    public boolean getGlDirtyFlag(){
        return GlDirtyFlag ;
    }

    /**
     * 获取 [BM]
     */
    @JsonProperty("bm")
    public String getBm(){
        return Bm ;
    }

    /**
     * 设置 [BM]
     */
    @JsonProperty("bm")
    public void setBm(String  bm){
        this.Bm = bm ;
        this.BmDirtyFlag = true ;
    }

    /**
     * 获取 [BM]脏标记
     */
    @JsonIgnore
    public boolean getBmDirtyFlag(){
        return BmDirtyFlag ;
    }

    /**
     * 获取 [HPDS]
     */
    @JsonProperty("hpds")
    public String getHpds(){
        return Hpds ;
    }

    /**
     * 设置 [HPDS]
     */
    @JsonProperty("hpds")
    public void setHpds(String  hpds){
        this.Hpds = hpds ;
        this.HpdsDirtyFlag = true ;
    }

    /**
     * 获取 [HPDS]脏标记
     */
    @JsonIgnore
    public boolean getHpdsDirtyFlag(){
        return HpdsDirtyFlag ;
    }

    /**
     * 获取 [BZ]
     */
    @JsonProperty("bz")
    public String getBz(){
        return Bz ;
    }

    /**
     * 设置 [BZ]
     */
    @JsonProperty("bz")
    public void setBz(String  bz){
        this.Bz = bz ;
        this.BzDirtyFlag = true ;
    }

    /**
     * 获取 [BZ]脏标记
     */
    @JsonIgnore
    public boolean getBzDirtyFlag(){
        return BzDirtyFlag ;
    }

    /**
     * 获取 [CPXHNAME]
     */
    @JsonProperty("cpxhname")
    public String getCPXHName(){
        return CPXHName ;
    }

    /**
     * 设置 [CPXHNAME]
     */
    @JsonProperty("cpxhname")
    public void setCPXHName(String  cPXHName){
        this.CPXHName = cPXHName ;
        this.CPXHNameDirtyFlag = true ;
    }

    /**
     * 获取 [CPXHNAME]脏标记
     */
    @JsonIgnore
    public boolean getCPXHNameDirtyFlag(){
        return CPXHNameDirtyFlag ;
    }

    /**
     * 获取 [XCGZJ]
     */
    @JsonProperty("xcgzj")
    public BigDecimal getXcgzj(){
        return Xcgzj ;
    }

    /**
     * 设置 [XCGZJ]
     */
    @JsonProperty("xcgzj")
    public void setXcgzj(BigDecimal  xcgzj){
        this.Xcgzj = xcgzj ;
        this.XcgzjDirtyFlag = true ;
    }

    /**
     * 获取 [XCGZJ]脏标记
     */
    @JsonIgnore
    public boolean getXcgzjDirtyFlag(){
        return XcgzjDirtyFlag ;
    }

    /**
     * 获取 [SSNF]
     */
    @JsonProperty("ssnf")
    public String getSsnf(){
        return Ssnf ;
    }

    /**
     * 设置 [SSNF]
     */
    @JsonProperty("ssnf")
    public void setSsnf(String  ssnf){
        this.Ssnf = ssnf ;
        this.SsnfDirtyFlag = true ;
    }

    /**
     * 获取 [SSNF]脏标记
     */
    @JsonIgnore
    public boolean getSsnfDirtyFlag(){
        return SsnfDirtyFlag ;
    }

    /**
     * 获取 [HDZZL]
     */
    @JsonProperty("hdzzl")
    public Double getHdzzl(){
        return Hdzzl ;
    }

    /**
     * 设置 [HDZZL]
     */
    @JsonProperty("hdzzl")
    public void setHdzzl(Double  hdzzl){
        this.Hdzzl = hdzzl ;
        this.HdzzlDirtyFlag = true ;
    }

    /**
     * 获取 [HDZZL]脏标记
     */
    @JsonIgnore
    public boolean getHdzzlDirtyFlag(){
        return HdzzlDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return CreateDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.CreateDate = createDate ;
        this.CreateDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return CreateDateDirtyFlag ;
    }

    /**
     * 获取 [ABL]
     */
    @JsonProperty("abl")
    public String getAbl(){
        return Abl ;
    }

    /**
     * 设置 [ABL]
     */
    @JsonProperty("abl")
    public void setAbl(String  abl){
        this.Abl = abl ;
        this.AblDirtyFlag = true ;
    }

    /**
     * 获取 [ABL]脏标记
     */
    @JsonIgnore
    public boolean getAblDirtyFlag(){
        return AblDirtyFlag ;
    }

    /**
     * 获取 [CLLXMS]
     */
    @JsonProperty("cllxms")
    public String getCllxms(){
        return Cllxms ;
    }

    /**
     * 设置 [CLLXMS]
     */
    @JsonProperty("cllxms")
    public void setCllxms(String  cllxms){
        this.Cllxms = cllxms ;
        this.CllxmsDirtyFlag = true ;
    }

    /**
     * 获取 [CLLXMS]脏标记
     */
    @JsonIgnore
    public boolean getCllxmsDirtyFlag(){
        return CllxmsDirtyFlag ;
    }

    /**
     * 获取 [HDZK]
     */
    @JsonProperty("hdzk")
    public Integer getHdzk(){
        return Hdzk ;
    }

    /**
     * 设置 [HDZK]
     */
    @JsonProperty("hdzk")
    public void setHdzk(Integer  hdzk){
        this.Hdzk = hdzk ;
        this.HdzkDirtyFlag = true ;
    }

    /**
     * 获取 [HDZK]脏标记
     */
    @JsonIgnore
    public boolean getHdzkDirtyFlag(){
        return HdzkDirtyFlag ;
    }

    /**
     * 获取 [ZBZL]
     */
    @JsonProperty("zbzl")
    public Double getZbzl(){
        return Zbzl ;
    }

    /**
     * 设置 [ZBZL]
     */
    @JsonProperty("zbzl")
    public void setZbzl(Double  zbzl){
        this.Zbzl = zbzl ;
        this.ZbzlDirtyFlag = true ;
    }

    /**
     * 获取 [ZBZL]脏标记
     */
    @JsonIgnore
    public boolean getZbzlDirtyFlag(){
        return ZbzlDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return UpdateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.UpdateDate = updateDate ;
        this.UpdateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return UpdateDateDirtyFlag ;
    }

    /**
     * 获取 [PP]
     */
    @JsonProperty("pp")
    public String getPp(){
        return Pp ;
    }

    /**
     * 设置 [PP]
     */
    @JsonProperty("pp")
    public void setPp(String  pp){
        this.Pp = pp ;
        this.PpDirtyFlag = true ;
    }

    /**
     * 获取 [PP]脏标记
     */
    @JsonIgnore
    public boolean getPpDirtyFlag(){
        return PpDirtyFlag ;
    }

    /**
     * 获取 [DYCPXH]
     */
    @JsonProperty("dycpxh")
    public String getDycpxh(){
        return Dycpxh ;
    }

    /**
     * 设置 [DYCPXH]
     */
    @JsonProperty("dycpxh")
    public void setDycpxh(String  dycpxh){
        this.Dycpxh = dycpxh ;
        this.DycpxhDirtyFlag = true ;
    }

    /**
     * 获取 [DYCPXH]脏标记
     */
    @JsonIgnore
    public boolean getDycpxhDirtyFlag(){
        return DycpxhDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return CreateMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.CreateMan = createMan ;
        this.CreateManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return CreateManDirtyFlag ;
    }

    /**
     * 获取 [CXDM]
     */
    @JsonProperty("cxdm")
    public String getCxdm(){
        return Cxdm ;
    }

    /**
     * 设置 [CXDM]
     */
    @JsonProperty("cxdm")
    public void setCxdm(String  cxdm){
        this.Cxdm = cxdm ;
        this.CxdmDirtyFlag = true ;
    }

    /**
     * 获取 [CXDM]脏标记
     */
    @JsonIgnore
    public boolean getCxdmDirtyFlag(){
        return CxdmDirtyFlag ;
    }

    /**
     * 获取 [PL]
     */
    @JsonProperty("pl")
    public Double getPl(){
        return Pl ;
    }

    /**
     * 设置 [PL]
     */
    @JsonProperty("pl")
    public void setPl(Double  pl){
        this.Pl = pl ;
        this.PlDirtyFlag = true ;
    }

    /**
     * 获取 [PL]脏标记
     */
    @JsonIgnore
    public boolean getPlDirtyFlag(){
        return PlDirtyFlag ;
    }

    /**
     * 获取 [CPXHID]
     */
    @JsonProperty("cpxhid")
    public String getCPXHId(){
        return CPXHId ;
    }

    /**
     * 设置 [CPXHID]
     */
    @JsonProperty("cpxhid")
    public void setCPXHId(String  cPXHId){
        this.CPXHId = cPXHId ;
        this.CPXHIdDirtyFlag = true ;
    }

    /**
     * 获取 [CPXHID]脏标记
     */
    @JsonIgnore
    public boolean getCPXHIdDirtyFlag(){
        return CPXHIdDirtyFlag ;
    }

    /**
     * 获取 [SCCS]
     */
    @JsonProperty("sccs")
    public String getSccs(){
        return Sccs ;
    }

    /**
     * 设置 [SCCS]
     */
    @JsonProperty("sccs")
    public void setSccs(String  sccs){
        this.Sccs = sccs ;
        this.SccsDirtyFlag = true ;
    }

    /**
     * 获取 [SCCS]脏标记
     */
    @JsonIgnore
    public boolean getSccsDirtyFlag(){
        return SccsDirtyFlag ;
    }

    /**
     * 获取 [CLSJJZ]
     */
    @JsonProperty("clsjjz")
    public BigDecimal getClsjjz(){
        return Clsjjz ;
    }

    /**
     * 设置 [CLSJJZ]
     */
    @JsonProperty("clsjjz")
    public void setClsjjz(BigDecimal  clsjjz){
        this.Clsjjz = clsjjz ;
        this.ClsjjzDirtyFlag = true ;
    }

    /**
     * 获取 [CLSJJZ]脏标记
     */
    @JsonIgnore
    public boolean getClsjjzDirtyFlag(){
        return ClsjjzDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return UpdateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.UpdateMan = updateMan ;
        this.UpdateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return UpdateManDirtyFlag ;
    }

    /**
     * 获取 [CX]
     */
    @JsonProperty("cx")
    public String getCx(){
        return Cx ;
    }

    /**
     * 设置 [CX]
     */
    @JsonProperty("cx")
    public void setCx(String  cx){
        this.Cx = cx ;
        this.CxDirtyFlag = true ;
    }

    /**
     * 获取 [CX]脏标记
     */
    @JsonIgnore
    public boolean getCxDirtyFlag(){
        return CxDirtyFlag ;
    }



    public CPXH toDO() {

        CPXH srfdomain = new CPXH();
        if(getGlDirtyFlag())
            srfdomain.setGl(Gl);
        if(getBmDirtyFlag())
            srfdomain.setBm(Bm);
        if(getHpdsDirtyFlag())
            srfdomain.setHpds(Hpds);
        if(getBzDirtyFlag())
            srfdomain.setBz(Bz);
        if(getCPXHNameDirtyFlag())
            srfdomain.setCPXHName(CPXHName);
        if(getXcgzjDirtyFlag())
            srfdomain.setXcgzj(Xcgzj);
        if(getSsnfDirtyFlag())
            srfdomain.setSsnf(Ssnf);
        if(getHdzzlDirtyFlag())
            srfdomain.setHdzzl(Hdzzl);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(CreateDate);
        if(getAblDirtyFlag())
            srfdomain.setAbl(Abl);
        if(getCllxmsDirtyFlag())
            srfdomain.setCllxms(Cllxms);
        if(getHdzkDirtyFlag())
            srfdomain.setHdzk(Hdzk);
        if(getZbzlDirtyFlag())
            srfdomain.setZbzl(Zbzl);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(UpdateDate);
        if(getPpDirtyFlag())
            srfdomain.setPp(Pp);
        if(getDycpxhDirtyFlag())
            srfdomain.setDycpxh(Dycpxh);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(CreateMan);
        if(getCxdmDirtyFlag())
            srfdomain.setCxdm(Cxdm);
        if(getPlDirtyFlag())
            srfdomain.setPl(Pl);
        if(getCPXHIdDirtyFlag())
            srfdomain.setCPXHId(CPXHId);
        if(getSccsDirtyFlag())
            srfdomain.setSccs(Sccs);
        if(getClsjjzDirtyFlag())
            srfdomain.setClsjjz(Clsjjz);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(UpdateMan);
        if(getCxDirtyFlag())
            srfdomain.setCx(Cx);
        return srfdomain;
    }

    public void fromDO(CPXH srfdomain) {

        if(srfdomain.getGlDirtyFlag())
            this.setGl(srfdomain.getGl());
        if(srfdomain.getBmDirtyFlag())
            this.setBm(srfdomain.getBm());
        if(srfdomain.getHpdsDirtyFlag())
            this.setHpds(srfdomain.getHpds());
        if(srfdomain.getBzDirtyFlag())
            this.setBz(srfdomain.getBz());
        if(srfdomain.getCPXHNameDirtyFlag())
            this.setCPXHName(srfdomain.getCPXHName());
        if(srfdomain.getXcgzjDirtyFlag())
            this.setXcgzj(srfdomain.getXcgzj());
        if(srfdomain.getSsnfDirtyFlag())
            this.setSsnf(srfdomain.getSsnf());
        if(srfdomain.getHdzzlDirtyFlag())
            this.setHdzzl(srfdomain.getHdzzl());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getAblDirtyFlag())
            this.setAbl(srfdomain.getAbl());
        if(srfdomain.getCllxmsDirtyFlag())
            this.setCllxms(srfdomain.getCllxms());
        if(srfdomain.getHdzkDirtyFlag())
            this.setHdzk(srfdomain.getHdzk());
        if(srfdomain.getZbzlDirtyFlag())
            this.setZbzl(srfdomain.getZbzl());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getPpDirtyFlag())
            this.setPp(srfdomain.getPp());
        if(srfdomain.getDycpxhDirtyFlag())
            this.setDycpxh(srfdomain.getDycpxh());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getCxdmDirtyFlag())
            this.setCxdm(srfdomain.getCxdm());
        if(srfdomain.getPlDirtyFlag())
            this.setPl(srfdomain.getPl());
        if(srfdomain.getCPXHIdDirtyFlag())
            this.setCPXHId(srfdomain.getCPXHId());
        if(srfdomain.getSccsDirtyFlag())
            this.setSccs(srfdomain.getSccs());
        if(srfdomain.getClsjjzDirtyFlag())
            this.setClsjjz(srfdomain.getClsjjz());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getCxDirtyFlag())
            this.setCx(srfdomain.getCx());

    }

    public List<CPXHDTO> fromDOPage(List<CPXH> poPage)   {
        if(poPage == null)
            return null;
        List<CPXHDTO> dtos=new ArrayList<CPXHDTO>();
        for(CPXH domain : poPage) {
            CPXHDTO dto = new CPXHDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

