package com.sinosig.service.web.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.sinosig.core.module.valuerule.anno.cid.*;
import com.sinosig.core.module.domain.CID;
import org.springframework.cglib.beans.BeanCopier;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 服务DTO对象[CIDDTO]
 */
public class CIDDTO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [SYXDE]
     *
     */

    @CIDSyxdeCheckDBE(info = "起止日期规则")
    @CIDSyxdeDefault(info = "默认规则")
    private Timestamp Syxde;

    @JsonIgnore
    private boolean SyxdeDirtyFlag;

    /**
     * 属性 [ABL]
     *
     */

    @CIDAblDefault(info = "默认规则")
    private String Abl;

    @JsonIgnore
    private boolean AblDirtyFlag;

    /**
     * 属性 [FDJH]
     *
     */

    @CIDFdjhDefault(info = "默认规则")
    private String Fdjh;

    @JsonIgnore
    private boolean FdjhDirtyFlag;

    /**
     * 属性 [HPDS]
     *
     */

    @CIDHpdsDefault(info = "默认规则")
    private String Hpds;

    @JsonIgnore
    private boolean HpdsDirtyFlag;

    /**
     * 属性 [CCS_JQX]
     *
     */

    @CIDCcs_jqxDefault(info = "默认规则")
    private BigDecimal Ccs_jqx;

    @JsonIgnore
    private boolean Ccs_jqxDirtyFlag;

    /**
     * 属性 [SYX]
     *
     */

    @CIDSyxDefault(info = "默认规则")
    private Integer Syx;

    @JsonIgnore
    private boolean SyxDirtyFlag;

    /**
     * 属性 [HDZZL]
     *
     */

    @CIDHdzzlDefault(info = "默认规则")
    private Double Hdzzl;

    @JsonIgnore
    private boolean HdzzlDirtyFlag;

    /**
     * 属性 [UPDATEDATE]
     *
     */

    @CIDUpdateDateDefault(info = "默认规则")
    private Timestamp UpdateDate;

    @JsonIgnore
    private boolean UpdateDateDirtyFlag;

    /**
     * 属性 [GL]
     *
     */

    @CIDGlDefault(info = "默认规则")
    private Double Gl;

    @JsonIgnore
    private boolean GlDirtyFlag;

    /**
     * 属性 [CIDNAME]
     *
     */

    @CIDCIDNameDefault(info = "默认规则")
    private String CIDName;

    @JsonIgnore
    private boolean CIDNameDirtyFlag;

    /**
     * 属性 [QDLX]
     *
     */

    @CIDQdlxDefault(info = "默认规则")
    private String Qdlx;

    @JsonIgnore
    private boolean QdlxDirtyFlag;

    /**
     * 属性 [SYXDB]
     *
     */

    @CIDSyxdbDefault(info = "默认规则")
    private Timestamp Syxdb;

    @JsonIgnore
    private boolean SyxdbDirtyFlag;

    /**
     * 属性 [CREATEDATE]
     *
     */

    @CIDCreateDateDefault(info = "默认规则")
    private Timestamp CreateDate;

    @JsonIgnore
    private boolean CreateDateDirtyFlag;

    /**
     * 属性 [DYCPXH]
     *
     */

    @CIDDycpxhDefault(info = "默认规则")
    private String Dycpxh;

    @JsonIgnore
    private boolean DycpxhDirtyFlag;

    /**
     * 属性 [CLDL]
     *
     */

    @CIDCldlDefault(info = "默认规则")
    private String Cldl;

    @JsonIgnore
    private boolean CldlDirtyFlag;

    /**
     * 属性 [JQX]
     *
     */

    @CIDJqxDefault(info = "默认规则")
    private Integer Jqx;

    @JsonIgnore
    private boolean JqxDirtyFlag;

    /**
     * 属性 [JQXDQFL]
     *
     */

    @CIDJqxdqflDefault(info = "默认规则")
    private BigDecimal Jqxdqfl;

    @JsonIgnore
    private boolean JqxdqflDirtyFlag;

    /**
     * 属性 [HSBF_SYX]
     *
     */

    @CIDHsbf_syxDefault(info = "默认规则")
    private BigDecimal Hsbf_syx;

    @JsonIgnore
    private boolean Hsbf_syxDirtyFlag;

    /**
     * 属性 [SYXDQFS]
     *
     */

    @CIDSyxdqfsDefault(info = "默认规则")
    private String Syxdqfs;

    @JsonIgnore
    private boolean SyxdqfsDirtyFlag;

    /**
     * 属性 [HDZK]
     *
     */

    @CIDHdzkDefault(info = "默认规则")
    private Integer Hdzk;

    @JsonIgnore
    private boolean HdzkDirtyFlag;

    /**
     * 属性 [SYXZ]
     *
     */

    @CIDSyxzDefault(info = "默认规则")
    private String Syxz;

    @JsonIgnore
    private boolean SyxzDirtyFlag;

    /**
     * 属性 [CREATEMAN]
     *
     */

    @CIDCreateManDefault(info = "默认规则")
    private String CreateMan;

    @JsonIgnore
    private boolean CreateManDirtyFlag;

    /**
     * 属性 [CLLXMS]
     *
     */

    @CIDCllxmsDefault(info = "默认规则")
    private String Cllxms;

    @JsonIgnore
    private boolean CllxmsDirtyFlag;

    /**
     * 属性 [XCGZJ]
     *
     */

    @CIDXcgzjDefault(info = "默认规则")
    private BigDecimal Xcgzj;

    @JsonIgnore
    private boolean XcgzjDirtyFlag;

    /**
     * 属性 [BHSBF_SYX]
     *
     */

    @CIDBhsbf_syxDefault(info = "默认规则")
    private BigDecimal Bhsbf_syx;

    @JsonIgnore
    private boolean Bhsbf_syxDirtyFlag;

    /**
     * 属性 [JQXDB]
     *
     */

    @CIDJqxdbDefault(info = "默认规则")
    private Timestamp Jqxdb;

    @JsonIgnore
    private boolean JqxdbDirtyFlag;

    /**
     * 属性 [CLSJJZ]
     *
     */

    @CIDClsjjzDefault(info = "默认规则")
    private BigDecimal Clsjjz;

    @JsonIgnore
    private boolean ClsjjzDirtyFlag;

    /**
     * 属性 [SE_SYX]
     *
     */

    @CIDSe_syxDefault(info = "默认规则")
    private BigDecimal Se_syx;

    @JsonIgnore
    private boolean Se_syxDirtyFlag;

    /**
     * 属性 [HJ]
     *
     */

    @CIDHjDefault(info = "默认规则")
    private BigDecimal Hj;

    @JsonIgnore
    private boolean HjDirtyFlag;

    /**
     * 属性 [YWLY]
     *
     */

    @CIDYwlyDefault(info = "默认规则")
    private String Ywly;

    @JsonIgnore
    private boolean YwlyDirtyFlag;

    /**
     * 属性 [HPZL]
     *
     */

    @CIDHpzlDefault(info = "默认规则")
    private String Hpzl;

    @JsonIgnore
    private boolean HpzlDirtyFlag;

    /**
     * 属性 [JQXDQFS]
     *
     */

    @CIDJqxdqfsDefault(info = "默认规则")
    private String Jqxdqfs;

    @JsonIgnore
    private boolean JqxdqfsDirtyFlag;

    /**
     * 属性 [CLZL]
     *
     */

    @CIDClzlDefault(info = "默认规则")
    private String Clzl;

    @JsonIgnore
    private boolean ClzlDirtyFlag;

    /**
     * 属性 [SYXDQFL]
     *
     */

    @CIDSyxdqflDefault(info = "默认规则")
    private BigDecimal Syxdqfl;

    @JsonIgnore
    private boolean SyxdqflDirtyFlag;

    /**
     * 属性 [CJH]
     *
     */

    @CIDCjhDefault(info = "默认规则")
    private String Cjh;

    @JsonIgnore
    private boolean CjhDirtyFlag;

    /**
     * 属性 [CPHM]
     *
     */

    @CIDCphmDefault(info = "默认规则")
    private String Cphm;

    @JsonIgnore
    private boolean CphmDirtyFlag;

    /**
     * 属性 [PL]
     *
     */

    @CIDPlDefault(info = "默认规则")
    private Double Pl;

    @JsonIgnore
    private boolean PlDirtyFlag;

    /**
     * 属性 [HSBF_JQX]
     *
     */

    @CIDHsbf_jqxDefault(info = "默认规则")
    private BigDecimal Hsbf_jqx;

    @JsonIgnore
    private boolean Hsbf_jqxDirtyFlag;

    /**
     * 属性 [JQXDE]
     *
     */

    @CIDJqxdeDefault(info = "默认规则")
    private Timestamp Jqxde;

    @JsonIgnore
    private boolean JqxdeDirtyFlag;

    /**
     * 属性 [CIDID]
     *
     */

    @CIDCIDIdDefault(info = "默认规则")
    private String CIDId;

    @JsonIgnore
    private boolean CIDIdDirtyFlag;

    /**
     * 属性 [BHSBF_JQX]
     *
     */

    @CIDBhsbf_jqxDefault(info = "默认规则")
    private BigDecimal Bhsbf_jqx;

    @JsonIgnore
    private boolean Bhsbf_jqxDirtyFlag;

    /**
     * 属性 [UPDATEMAN]
     *
     */

    @CIDUpdateManDefault(info = "默认规则")
    private String UpdateMan;

    @JsonIgnore
    private boolean UpdateManDirtyFlag;

    /**
     * 属性 [CDRQ]
     *
     */

    @CIDCdrqDefault(info = "默认规则")
    private Timestamp Cdrq;

    @JsonIgnore
    private boolean CdrqDirtyFlag;

    /**
     * 属性 [ZBZL]
     *
     */

    @CIDZbzlDefault(info = "默认规则")
    private Double Zbzl;

    @JsonIgnore
    private boolean ZbzlDirtyFlag;

    /**
     * 属性 [SE_JQX]
     *
     */

    @CIDSe_jqxDefault(info = "默认规则")
    private BigDecimal Se_jqx;

    @JsonIgnore
    private boolean Se_jqxDirtyFlag;

    /**
     * 属性 [CPXHNAME]
     *
     */

    @CIDCPXHNameDefault(info = "默认规则")
    private String CPXHName;

    @JsonIgnore
    private boolean CPXHNameDirtyFlag;

    /**
     * 属性 [ORGUSERNAME]
     *
     */

    @CIDORGUSERNameDefault(info = "默认规则")
    private String ORGUSERName;

    @JsonIgnore
    private boolean ORGUSERNameDirtyFlag;

    /**
     * 属性 [ORGNAME]
     *
     */

    @CIDORGNameDefault(info = "默认规则")
    private String ORGName;

    @JsonIgnore
    private boolean ORGNameDirtyFlag;

    /**
     * 属性 [ORGUSERID]
     *
     */

    @CIDORGUSERIdDefault(info = "默认规则")
    private String ORGUSERId;

    @JsonIgnore
    private boolean ORGUSERIdDirtyFlag;

    /**
     * 属性 [CPXHID]
     *
     */

    @CIDCPXHIdDefault(info = "默认规则")
    private String CPXHId;

    @JsonIgnore
    private boolean CPXHIdDirtyFlag;

    /**
     * 属性 [ORGID]
     *
     */

    @CIDORGIdDefault(info = "默认规则")
    private String ORGId;

    @JsonIgnore
    private boolean ORGIdDirtyFlag;


    /**
     * 获取 [SYXDE]
     */
    @JsonProperty("syxde")
    public Timestamp getSyxde(){
        return Syxde ;
    }

    /**
     * 设置 [SYXDE]
     */
    @JsonProperty("syxde")
    public void setSyxde(Timestamp  syxde){
        this.Syxde = syxde ;
        this.SyxdeDirtyFlag = true ;
    }

    /**
     * 获取 [SYXDE]脏标记
     */
    @JsonIgnore
    public boolean getSyxdeDirtyFlag(){
        return SyxdeDirtyFlag ;
    }

    /**
     * 获取 [ABL]
     */
    @JsonProperty("abl")
    public String getAbl(){
        return Abl ;
    }

    /**
     * 设置 [ABL]
     */
    @JsonProperty("abl")
    public void setAbl(String  abl){
        this.Abl = abl ;
        this.AblDirtyFlag = true ;
    }

    /**
     * 获取 [ABL]脏标记
     */
    @JsonIgnore
    public boolean getAblDirtyFlag(){
        return AblDirtyFlag ;
    }

    /**
     * 获取 [FDJH]
     */
    @JsonProperty("fdjh")
    public String getFdjh(){
        return Fdjh ;
    }

    /**
     * 设置 [FDJH]
     */
    @JsonProperty("fdjh")
    public void setFdjh(String  fdjh){
        this.Fdjh = fdjh ;
        this.FdjhDirtyFlag = true ;
    }

    /**
     * 获取 [FDJH]脏标记
     */
    @JsonIgnore
    public boolean getFdjhDirtyFlag(){
        return FdjhDirtyFlag ;
    }

    /**
     * 获取 [HPDS]
     */
    @JsonProperty("hpds")
    public String getHpds(){
        return Hpds ;
    }

    /**
     * 设置 [HPDS]
     */
    @JsonProperty("hpds")
    public void setHpds(String  hpds){
        this.Hpds = hpds ;
        this.HpdsDirtyFlag = true ;
    }

    /**
     * 获取 [HPDS]脏标记
     */
    @JsonIgnore
    public boolean getHpdsDirtyFlag(){
        return HpdsDirtyFlag ;
    }

    /**
     * 获取 [CCS_JQX]
     */
    @JsonProperty("ccs_jqx")
    public BigDecimal getCcs_jqx(){
        return Ccs_jqx ;
    }

    /**
     * 设置 [CCS_JQX]
     */
    @JsonProperty("ccs_jqx")
    public void setCcs_jqx(BigDecimal  ccs_jqx){
        this.Ccs_jqx = ccs_jqx ;
        this.Ccs_jqxDirtyFlag = true ;
    }

    /**
     * 获取 [CCS_JQX]脏标记
     */
    @JsonIgnore
    public boolean getCcs_jqxDirtyFlag(){
        return Ccs_jqxDirtyFlag ;
    }

    /**
     * 获取 [SYX]
     */
    @JsonProperty("syx")
    public Integer getSyx(){
        return Syx ;
    }

    /**
     * 设置 [SYX]
     */
    @JsonProperty("syx")
    public void setSyx(Integer  syx){
        this.Syx = syx ;
        this.SyxDirtyFlag = true ;
    }

    /**
     * 获取 [SYX]脏标记
     */
    @JsonIgnore
    public boolean getSyxDirtyFlag(){
        return SyxDirtyFlag ;
    }

    /**
     * 获取 [HDZZL]
     */
    @JsonProperty("hdzzl")
    public Double getHdzzl(){
        return Hdzzl ;
    }

    /**
     * 设置 [HDZZL]
     */
    @JsonProperty("hdzzl")
    public void setHdzzl(Double  hdzzl){
        this.Hdzzl = hdzzl ;
        this.HdzzlDirtyFlag = true ;
    }

    /**
     * 获取 [HDZZL]脏标记
     */
    @JsonIgnore
    public boolean getHdzzlDirtyFlag(){
        return HdzzlDirtyFlag ;
    }

    /**
     * 获取 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public Timestamp getUpdateDate(){
        return UpdateDate ;
    }

    /**
     * 设置 [UPDATEDATE]
     */
    @JsonProperty("updatedate")
    public void setUpdateDate(Timestamp  updateDate){
        this.UpdateDate = updateDate ;
        this.UpdateDateDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getUpdateDateDirtyFlag(){
        return UpdateDateDirtyFlag ;
    }

    /**
     * 获取 [GL]
     */
    @JsonProperty("gl")
    public Double getGl(){
        return Gl ;
    }

    /**
     * 设置 [GL]
     */
    @JsonProperty("gl")
    public void setGl(Double  gl){
        this.Gl = gl ;
        this.GlDirtyFlag = true ;
    }

    /**
     * 获取 [GL]脏标记
     */
    @JsonIgnore
    public boolean getGlDirtyFlag(){
        return GlDirtyFlag ;
    }

    /**
     * 获取 [CIDNAME]
     */
    @JsonProperty("cidname")
    public String getCIDName(){
        return CIDName ;
    }

    /**
     * 设置 [CIDNAME]
     */
    @JsonProperty("cidname")
    public void setCIDName(String  cIDName){
        this.CIDName = cIDName ;
        this.CIDNameDirtyFlag = true ;
    }

    /**
     * 获取 [CIDNAME]脏标记
     */
    @JsonIgnore
    public boolean getCIDNameDirtyFlag(){
        return CIDNameDirtyFlag ;
    }

    /**
     * 获取 [QDLX]
     */
    @JsonProperty("qdlx")
    public String getQdlx(){
        return Qdlx ;
    }

    /**
     * 设置 [QDLX]
     */
    @JsonProperty("qdlx")
    public void setQdlx(String  qdlx){
        this.Qdlx = qdlx ;
        this.QdlxDirtyFlag = true ;
    }

    /**
     * 获取 [QDLX]脏标记
     */
    @JsonIgnore
    public boolean getQdlxDirtyFlag(){
        return QdlxDirtyFlag ;
    }

    /**
     * 获取 [SYXDB]
     */
    @JsonProperty("syxdb")
    public Timestamp getSyxdb(){
        return Syxdb ;
    }

    /**
     * 设置 [SYXDB]
     */
    @JsonProperty("syxdb")
    public void setSyxdb(Timestamp  syxdb){
        this.Syxdb = syxdb ;
        this.SyxdbDirtyFlag = true ;
    }

    /**
     * 获取 [SYXDB]脏标记
     */
    @JsonIgnore
    public boolean getSyxdbDirtyFlag(){
        return SyxdbDirtyFlag ;
    }

    /**
     * 获取 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public Timestamp getCreateDate(){
        return CreateDate ;
    }

    /**
     * 设置 [CREATEDATE]
     */
    @JsonProperty("createdate")
    public void setCreateDate(Timestamp  createDate){
        this.CreateDate = createDate ;
        this.CreateDateDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEDATE]脏标记
     */
    @JsonIgnore
    public boolean getCreateDateDirtyFlag(){
        return CreateDateDirtyFlag ;
    }

    /**
     * 获取 [DYCPXH]
     */
    @JsonProperty("dycpxh")
    public String getDycpxh(){
        return Dycpxh ;
    }

    /**
     * 设置 [DYCPXH]
     */
    @JsonProperty("dycpxh")
    public void setDycpxh(String  dycpxh){
        this.Dycpxh = dycpxh ;
        this.DycpxhDirtyFlag = true ;
    }

    /**
     * 获取 [DYCPXH]脏标记
     */
    @JsonIgnore
    public boolean getDycpxhDirtyFlag(){
        return DycpxhDirtyFlag ;
    }

    /**
     * 获取 [CLDL]
     */
    @JsonProperty("cldl")
    public String getCldl(){
        return Cldl ;
    }

    /**
     * 设置 [CLDL]
     */
    @JsonProperty("cldl")
    public void setCldl(String  cldl){
        this.Cldl = cldl ;
        this.CldlDirtyFlag = true ;
    }

    /**
     * 获取 [CLDL]脏标记
     */
    @JsonIgnore
    public boolean getCldlDirtyFlag(){
        return CldlDirtyFlag ;
    }

    /**
     * 获取 [JQX]
     */
    @JsonProperty("jqx")
    public Integer getJqx(){
        return Jqx ;
    }

    /**
     * 设置 [JQX]
     */
    @JsonProperty("jqx")
    public void setJqx(Integer  jqx){
        this.Jqx = jqx ;
        this.JqxDirtyFlag = true ;
    }

    /**
     * 获取 [JQX]脏标记
     */
    @JsonIgnore
    public boolean getJqxDirtyFlag(){
        return JqxDirtyFlag ;
    }

    /**
     * 获取 [JQXDQFL]
     */
    @JsonProperty("jqxdqfl")
    public BigDecimal getJqxdqfl(){
        return Jqxdqfl ;
    }

    /**
     * 设置 [JQXDQFL]
     */
    @JsonProperty("jqxdqfl")
    public void setJqxdqfl(BigDecimal  jqxdqfl){
        this.Jqxdqfl = jqxdqfl ;
        this.JqxdqflDirtyFlag = true ;
    }

    /**
     * 获取 [JQXDQFL]脏标记
     */
    @JsonIgnore
    public boolean getJqxdqflDirtyFlag(){
        return JqxdqflDirtyFlag ;
    }

    /**
     * 获取 [HSBF_SYX]
     */
    @JsonProperty("hsbf_syx")
    public BigDecimal getHsbf_syx(){
        return Hsbf_syx ;
    }

    /**
     * 设置 [HSBF_SYX]
     */
    @JsonProperty("hsbf_syx")
    public void setHsbf_syx(BigDecimal  hsbf_syx){
        this.Hsbf_syx = hsbf_syx ;
        this.Hsbf_syxDirtyFlag = true ;
    }

    /**
     * 获取 [HSBF_SYX]脏标记
     */
    @JsonIgnore
    public boolean getHsbf_syxDirtyFlag(){
        return Hsbf_syxDirtyFlag ;
    }

    /**
     * 获取 [SYXDQFS]
     */
    @JsonProperty("syxdqfs")
    public String getSyxdqfs(){
        return Syxdqfs ;
    }

    /**
     * 设置 [SYXDQFS]
     */
    @JsonProperty("syxdqfs")
    public void setSyxdqfs(String  syxdqfs){
        this.Syxdqfs = syxdqfs ;
        this.SyxdqfsDirtyFlag = true ;
    }

    /**
     * 获取 [SYXDQFS]脏标记
     */
    @JsonIgnore
    public boolean getSyxdqfsDirtyFlag(){
        return SyxdqfsDirtyFlag ;
    }

    /**
     * 获取 [HDZK]
     */
    @JsonProperty("hdzk")
    public Integer getHdzk(){
        return Hdzk ;
    }

    /**
     * 设置 [HDZK]
     */
    @JsonProperty("hdzk")
    public void setHdzk(Integer  hdzk){
        this.Hdzk = hdzk ;
        this.HdzkDirtyFlag = true ;
    }

    /**
     * 获取 [HDZK]脏标记
     */
    @JsonIgnore
    public boolean getHdzkDirtyFlag(){
        return HdzkDirtyFlag ;
    }

    /**
     * 获取 [SYXZ]
     */
    @JsonProperty("syxz")
    public String getSyxz(){
        return Syxz ;
    }

    /**
     * 设置 [SYXZ]
     */
    @JsonProperty("syxz")
    public void setSyxz(String  syxz){
        this.Syxz = syxz ;
        this.SyxzDirtyFlag = true ;
    }

    /**
     * 获取 [SYXZ]脏标记
     */
    @JsonIgnore
    public boolean getSyxzDirtyFlag(){
        return SyxzDirtyFlag ;
    }

    /**
     * 获取 [CREATEMAN]
     */
    @JsonProperty("createman")
    public String getCreateMan(){
        return CreateMan ;
    }

    /**
     * 设置 [CREATEMAN]
     */
    @JsonProperty("createman")
    public void setCreateMan(String  createMan){
        this.CreateMan = createMan ;
        this.CreateManDirtyFlag = true ;
    }

    /**
     * 获取 [CREATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getCreateManDirtyFlag(){
        return CreateManDirtyFlag ;
    }

    /**
     * 获取 [CLLXMS]
     */
    @JsonProperty("cllxms")
    public String getCllxms(){
        return Cllxms ;
    }

    /**
     * 设置 [CLLXMS]
     */
    @JsonProperty("cllxms")
    public void setCllxms(String  cllxms){
        this.Cllxms = cllxms ;
        this.CllxmsDirtyFlag = true ;
    }

    /**
     * 获取 [CLLXMS]脏标记
     */
    @JsonIgnore
    public boolean getCllxmsDirtyFlag(){
        return CllxmsDirtyFlag ;
    }

    /**
     * 获取 [XCGZJ]
     */
    @JsonProperty("xcgzj")
    public BigDecimal getXcgzj(){
        return Xcgzj ;
    }

    /**
     * 设置 [XCGZJ]
     */
    @JsonProperty("xcgzj")
    public void setXcgzj(BigDecimal  xcgzj){
        this.Xcgzj = xcgzj ;
        this.XcgzjDirtyFlag = true ;
    }

    /**
     * 获取 [XCGZJ]脏标记
     */
    @JsonIgnore
    public boolean getXcgzjDirtyFlag(){
        return XcgzjDirtyFlag ;
    }

    /**
     * 获取 [BHSBF_SYX]
     */
    @JsonProperty("bhsbf_syx")
    public BigDecimal getBhsbf_syx(){
        return Bhsbf_syx ;
    }

    /**
     * 设置 [BHSBF_SYX]
     */
    @JsonProperty("bhsbf_syx")
    public void setBhsbf_syx(BigDecimal  bhsbf_syx){
        this.Bhsbf_syx = bhsbf_syx ;
        this.Bhsbf_syxDirtyFlag = true ;
    }

    /**
     * 获取 [BHSBF_SYX]脏标记
     */
    @JsonIgnore
    public boolean getBhsbf_syxDirtyFlag(){
        return Bhsbf_syxDirtyFlag ;
    }

    /**
     * 获取 [JQXDB]
     */
    @JsonProperty("jqxdb")
    public Timestamp getJqxdb(){
        return Jqxdb ;
    }

    /**
     * 设置 [JQXDB]
     */
    @JsonProperty("jqxdb")
    public void setJqxdb(Timestamp  jqxdb){
        this.Jqxdb = jqxdb ;
        this.JqxdbDirtyFlag = true ;
    }

    /**
     * 获取 [JQXDB]脏标记
     */
    @JsonIgnore
    public boolean getJqxdbDirtyFlag(){
        return JqxdbDirtyFlag ;
    }

    /**
     * 获取 [CLSJJZ]
     */
    @JsonProperty("clsjjz")
    public BigDecimal getClsjjz(){
        return Clsjjz ;
    }

    /**
     * 设置 [CLSJJZ]
     */
    @JsonProperty("clsjjz")
    public void setClsjjz(BigDecimal  clsjjz){
        this.Clsjjz = clsjjz ;
        this.ClsjjzDirtyFlag = true ;
    }

    /**
     * 获取 [CLSJJZ]脏标记
     */
    @JsonIgnore
    public boolean getClsjjzDirtyFlag(){
        return ClsjjzDirtyFlag ;
    }

    /**
     * 获取 [SE_SYX]
     */
    @JsonProperty("se_syx")
    public BigDecimal getSe_syx(){
        return Se_syx ;
    }

    /**
     * 设置 [SE_SYX]
     */
    @JsonProperty("se_syx")
    public void setSe_syx(BigDecimal  se_syx){
        this.Se_syx = se_syx ;
        this.Se_syxDirtyFlag = true ;
    }

    /**
     * 获取 [SE_SYX]脏标记
     */
    @JsonIgnore
    public boolean getSe_syxDirtyFlag(){
        return Se_syxDirtyFlag ;
    }

    /**
     * 获取 [HJ]
     */
    @JsonProperty("hj")
    public BigDecimal getHj(){
        return Hj ;
    }

    /**
     * 设置 [HJ]
     */
    @JsonProperty("hj")
    public void setHj(BigDecimal  hj){
        this.Hj = hj ;
        this.HjDirtyFlag = true ;
    }

    /**
     * 获取 [HJ]脏标记
     */
    @JsonIgnore
    public boolean getHjDirtyFlag(){
        return HjDirtyFlag ;
    }

    /**
     * 获取 [YWLY]
     */
    @JsonProperty("ywly")
    public String getYwly(){
        return Ywly ;
    }

    /**
     * 设置 [YWLY]
     */
    @JsonProperty("ywly")
    public void setYwly(String  ywly){
        this.Ywly = ywly ;
        this.YwlyDirtyFlag = true ;
    }

    /**
     * 获取 [YWLY]脏标记
     */
    @JsonIgnore
    public boolean getYwlyDirtyFlag(){
        return YwlyDirtyFlag ;
    }

    /**
     * 获取 [HPZL]
     */
    @JsonProperty("hpzl")
    public String getHpzl(){
        return Hpzl ;
    }

    /**
     * 设置 [HPZL]
     */
    @JsonProperty("hpzl")
    public void setHpzl(String  hpzl){
        this.Hpzl = hpzl ;
        this.HpzlDirtyFlag = true ;
    }

    /**
     * 获取 [HPZL]脏标记
     */
    @JsonIgnore
    public boolean getHpzlDirtyFlag(){
        return HpzlDirtyFlag ;
    }

    /**
     * 获取 [JQXDQFS]
     */
    @JsonProperty("jqxdqfs")
    public String getJqxdqfs(){
        return Jqxdqfs ;
    }

    /**
     * 设置 [JQXDQFS]
     */
    @JsonProperty("jqxdqfs")
    public void setJqxdqfs(String  jqxdqfs){
        this.Jqxdqfs = jqxdqfs ;
        this.JqxdqfsDirtyFlag = true ;
    }

    /**
     * 获取 [JQXDQFS]脏标记
     */
    @JsonIgnore
    public boolean getJqxdqfsDirtyFlag(){
        return JqxdqfsDirtyFlag ;
    }

    /**
     * 获取 [CLZL]
     */
    @JsonProperty("clzl")
    public String getClzl(){
        return Clzl ;
    }

    /**
     * 设置 [CLZL]
     */
    @JsonProperty("clzl")
    public void setClzl(String  clzl){
        this.Clzl = clzl ;
        this.ClzlDirtyFlag = true ;
    }

    /**
     * 获取 [CLZL]脏标记
     */
    @JsonIgnore
    public boolean getClzlDirtyFlag(){
        return ClzlDirtyFlag ;
    }

    /**
     * 获取 [SYXDQFL]
     */
    @JsonProperty("syxdqfl")
    public BigDecimal getSyxdqfl(){
        return Syxdqfl ;
    }

    /**
     * 设置 [SYXDQFL]
     */
    @JsonProperty("syxdqfl")
    public void setSyxdqfl(BigDecimal  syxdqfl){
        this.Syxdqfl = syxdqfl ;
        this.SyxdqflDirtyFlag = true ;
    }

    /**
     * 获取 [SYXDQFL]脏标记
     */
    @JsonIgnore
    public boolean getSyxdqflDirtyFlag(){
        return SyxdqflDirtyFlag ;
    }

    /**
     * 获取 [CJH]
     */
    @JsonProperty("cjh")
    public String getCjh(){
        return Cjh ;
    }

    /**
     * 设置 [CJH]
     */
    @JsonProperty("cjh")
    public void setCjh(String  cjh){
        this.Cjh = cjh ;
        this.CjhDirtyFlag = true ;
    }

    /**
     * 获取 [CJH]脏标记
     */
    @JsonIgnore
    public boolean getCjhDirtyFlag(){
        return CjhDirtyFlag ;
    }

    /**
     * 获取 [CPHM]
     */
    @JsonProperty("cphm")
    public String getCphm(){
        return Cphm ;
    }

    /**
     * 设置 [CPHM]
     */
    @JsonProperty("cphm")
    public void setCphm(String  cphm){
        this.Cphm = cphm ;
        this.CphmDirtyFlag = true ;
    }

    /**
     * 获取 [CPHM]脏标记
     */
    @JsonIgnore
    public boolean getCphmDirtyFlag(){
        return CphmDirtyFlag ;
    }

    /**
     * 获取 [PL]
     */
    @JsonProperty("pl")
    public Double getPl(){
        return Pl ;
    }

    /**
     * 设置 [PL]
     */
    @JsonProperty("pl")
    public void setPl(Double  pl){
        this.Pl = pl ;
        this.PlDirtyFlag = true ;
    }

    /**
     * 获取 [PL]脏标记
     */
    @JsonIgnore
    public boolean getPlDirtyFlag(){
        return PlDirtyFlag ;
    }

    /**
     * 获取 [HSBF_JQX]
     */
    @JsonProperty("hsbf_jqx")
    public BigDecimal getHsbf_jqx(){
        return Hsbf_jqx ;
    }

    /**
     * 设置 [HSBF_JQX]
     */
    @JsonProperty("hsbf_jqx")
    public void setHsbf_jqx(BigDecimal  hsbf_jqx){
        this.Hsbf_jqx = hsbf_jqx ;
        this.Hsbf_jqxDirtyFlag = true ;
    }

    /**
     * 获取 [HSBF_JQX]脏标记
     */
    @JsonIgnore
    public boolean getHsbf_jqxDirtyFlag(){
        return Hsbf_jqxDirtyFlag ;
    }

    /**
     * 获取 [JQXDE]
     */
    @JsonProperty("jqxde")
    public Timestamp getJqxde(){
        return Jqxde ;
    }

    /**
     * 设置 [JQXDE]
     */
    @JsonProperty("jqxde")
    public void setJqxde(Timestamp  jqxde){
        this.Jqxde = jqxde ;
        this.JqxdeDirtyFlag = true ;
    }

    /**
     * 获取 [JQXDE]脏标记
     */
    @JsonIgnore
    public boolean getJqxdeDirtyFlag(){
        return JqxdeDirtyFlag ;
    }

    /**
     * 获取 [CIDID]
     */
    @JsonProperty("cidid")
    public String getCIDId(){
        return CIDId ;
    }

    /**
     * 设置 [CIDID]
     */
    @JsonProperty("cidid")
    public void setCIDId(String  cIDId){
        this.CIDId = cIDId ;
        this.CIDIdDirtyFlag = true ;
    }

    /**
     * 获取 [CIDID]脏标记
     */
    @JsonIgnore
    public boolean getCIDIdDirtyFlag(){
        return CIDIdDirtyFlag ;
    }

    /**
     * 获取 [BHSBF_JQX]
     */
    @JsonProperty("bhsbf_jqx")
    public BigDecimal getBhsbf_jqx(){
        return Bhsbf_jqx ;
    }

    /**
     * 设置 [BHSBF_JQX]
     */
    @JsonProperty("bhsbf_jqx")
    public void setBhsbf_jqx(BigDecimal  bhsbf_jqx){
        this.Bhsbf_jqx = bhsbf_jqx ;
        this.Bhsbf_jqxDirtyFlag = true ;
    }

    /**
     * 获取 [BHSBF_JQX]脏标记
     */
    @JsonIgnore
    public boolean getBhsbf_jqxDirtyFlag(){
        return Bhsbf_jqxDirtyFlag ;
    }

    /**
     * 获取 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public String getUpdateMan(){
        return UpdateMan ;
    }

    /**
     * 设置 [UPDATEMAN]
     */
    @JsonProperty("updateman")
    public void setUpdateMan(String  updateMan){
        this.UpdateMan = updateMan ;
        this.UpdateManDirtyFlag = true ;
    }

    /**
     * 获取 [UPDATEMAN]脏标记
     */
    @JsonIgnore
    public boolean getUpdateManDirtyFlag(){
        return UpdateManDirtyFlag ;
    }

    /**
     * 获取 [CDRQ]
     */
    @JsonProperty("cdrq")
    public Timestamp getCdrq(){
        return Cdrq ;
    }

    /**
     * 设置 [CDRQ]
     */
    @JsonProperty("cdrq")
    public void setCdrq(Timestamp  cdrq){
        this.Cdrq = cdrq ;
        this.CdrqDirtyFlag = true ;
    }

    /**
     * 获取 [CDRQ]脏标记
     */
    @JsonIgnore
    public boolean getCdrqDirtyFlag(){
        return CdrqDirtyFlag ;
    }

    /**
     * 获取 [ZBZL]
     */
    @JsonProperty("zbzl")
    public Double getZbzl(){
        return Zbzl ;
    }

    /**
     * 设置 [ZBZL]
     */
    @JsonProperty("zbzl")
    public void setZbzl(Double  zbzl){
        this.Zbzl = zbzl ;
        this.ZbzlDirtyFlag = true ;
    }

    /**
     * 获取 [ZBZL]脏标记
     */
    @JsonIgnore
    public boolean getZbzlDirtyFlag(){
        return ZbzlDirtyFlag ;
    }

    /**
     * 获取 [SE_JQX]
     */
    @JsonProperty("se_jqx")
    public BigDecimal getSe_jqx(){
        return Se_jqx ;
    }

    /**
     * 设置 [SE_JQX]
     */
    @JsonProperty("se_jqx")
    public void setSe_jqx(BigDecimal  se_jqx){
        this.Se_jqx = se_jqx ;
        this.Se_jqxDirtyFlag = true ;
    }

    /**
     * 获取 [SE_JQX]脏标记
     */
    @JsonIgnore
    public boolean getSe_jqxDirtyFlag(){
        return Se_jqxDirtyFlag ;
    }

    /**
     * 获取 [CPXHNAME]
     */
    @JsonProperty("cpxhname")
    public String getCPXHName(){
        return CPXHName ;
    }

    /**
     * 设置 [CPXHNAME]
     */
    @JsonProperty("cpxhname")
    public void setCPXHName(String  cPXHName){
        this.CPXHName = cPXHName ;
        this.CPXHNameDirtyFlag = true ;
    }

    /**
     * 获取 [CPXHNAME]脏标记
     */
    @JsonIgnore
    public boolean getCPXHNameDirtyFlag(){
        return CPXHNameDirtyFlag ;
    }

    /**
     * 获取 [ORGUSERNAME]
     */
    @JsonProperty("orgusername")
    public String getORGUSERName(){
        return ORGUSERName ;
    }

    /**
     * 设置 [ORGUSERNAME]
     */
    @JsonProperty("orgusername")
    public void setORGUSERName(String  oRGUSERName){
        this.ORGUSERName = oRGUSERName ;
        this.ORGUSERNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGUSERNAME]脏标记
     */
    @JsonIgnore
    public boolean getORGUSERNameDirtyFlag(){
        return ORGUSERNameDirtyFlag ;
    }

    /**
     * 获取 [ORGNAME]
     */
    @JsonProperty("orgname")
    public String getORGName(){
        return ORGName ;
    }

    /**
     * 设置 [ORGNAME]
     */
    @JsonProperty("orgname")
    public void setORGName(String  oRGName){
        this.ORGName = oRGName ;
        this.ORGNameDirtyFlag = true ;
    }

    /**
     * 获取 [ORGNAME]脏标记
     */
    @JsonIgnore
    public boolean getORGNameDirtyFlag(){
        return ORGNameDirtyFlag ;
    }

    /**
     * 获取 [ORGUSERID]
     */
    @JsonProperty("orguserid")
    public String getORGUSERId(){
        return ORGUSERId ;
    }

    /**
     * 设置 [ORGUSERID]
     */
    @JsonProperty("orguserid")
    public void setORGUSERId(String  oRGUSERId){
        this.ORGUSERId = oRGUSERId ;
        this.ORGUSERIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGUSERID]脏标记
     */
    @JsonIgnore
    public boolean getORGUSERIdDirtyFlag(){
        return ORGUSERIdDirtyFlag ;
    }

    /**
     * 获取 [CPXHID]
     */
    @JsonProperty("cpxhid")
    public String getCPXHId(){
        return CPXHId ;
    }

    /**
     * 设置 [CPXHID]
     */
    @JsonProperty("cpxhid")
    public void setCPXHId(String  cPXHId){
        this.CPXHId = cPXHId ;
        this.CPXHIdDirtyFlag = true ;
    }

    /**
     * 获取 [CPXHID]脏标记
     */
    @JsonIgnore
    public boolean getCPXHIdDirtyFlag(){
        return CPXHIdDirtyFlag ;
    }

    /**
     * 获取 [ORGID]
     */
    @JsonProperty("orgid")
    public String getORGId(){
        return ORGId ;
    }

    /**
     * 设置 [ORGID]
     */
    @JsonProperty("orgid")
    public void setORGId(String  oRGId){
        this.ORGId = oRGId ;
        this.ORGIdDirtyFlag = true ;
    }

    /**
     * 获取 [ORGID]脏标记
     */
    @JsonIgnore
    public boolean getORGIdDirtyFlag(){
        return ORGIdDirtyFlag ;
    }


    /**
     *  [车险单-交强险特别约定]
     */
	private List<JQXTBYDDTO> jqxtbyds = new ArrayList<JQXTBYDDTO>();

    public List<JQXTBYDDTO> getJqxtbyds(){
        return jqxtbyds ;
    }

    public void setJqxtbyds(List <JQXTBYDDTO> jqxtbyds){
        this.jqxtbyds = jqxtbyds ;
    }

    /**
     *  [车险单-商业险特别约定]
     */
	private List<SYXTBYDDTO> syxtbyds = new ArrayList<SYXTBYDDTO>();

    public List<SYXTBYDDTO> getSyxtbyds(){
        return syxtbyds ;
    }

    public void setSyxtbyds(List <SYXTBYDDTO> syxtbyds){
        this.syxtbyds = syxtbyds ;
    }

    /**
     *  [车险单-客户]
     */
	private List<CUSTOMERDTO> customers = new ArrayList<CUSTOMERDTO>();

    public List<CUSTOMERDTO> getCustomers(){
        return customers ;
    }

    public void setCustomers(List <CUSTOMERDTO> customers){
        this.customers = customers ;
    }

    /**
     *  [车险单-交强险信息]
     */
	private List<JQXXXDTO> jqxxxes = new ArrayList<JQXXXDTO>();

    public List<JQXXXDTO> getJqxxxes(){
        return jqxxxes ;
    }

    public void setJqxxxes(List <JQXXXDTO> jqxxxes){
        this.jqxxxes = jqxxxes ;
    }

    /**
     *  [车险单-商业险信息]
     */
	private List<SYXXXDTO> syxxxes = new ArrayList<SYXXXDTO>();

    public List<SYXXXDTO> getSyxxxes(){
        return syxxxes ;
    }

    public void setSyxxxes(List <SYXXXDTO> syxxxes){
        this.syxxxes = syxxxes ;
    }


    public CID toDO() {

        CID srfdomain = new CID();
        if(getSyxdeDirtyFlag())
            srfdomain.setSyxde(Syxde);
        if(getAblDirtyFlag())
            srfdomain.setAbl(Abl);
        if(getFdjhDirtyFlag())
            srfdomain.setFdjh(Fdjh);
        if(getHpdsDirtyFlag())
            srfdomain.setHpds(Hpds);
        if(getCcs_jqxDirtyFlag())
            srfdomain.setCcs_jqx(Ccs_jqx);
        if(getSyxDirtyFlag())
            srfdomain.setSyx(Syx);
        if(getHdzzlDirtyFlag())
            srfdomain.setHdzzl(Hdzzl);
        if(getUpdateDateDirtyFlag())
            srfdomain.setUpdateDate(UpdateDate);
        if(getGlDirtyFlag())
            srfdomain.setGl(Gl);
        if(getCIDNameDirtyFlag())
            srfdomain.setCIDName(CIDName);
        if(getQdlxDirtyFlag())
            srfdomain.setQdlx(Qdlx);
        if(getSyxdbDirtyFlag())
            srfdomain.setSyxdb(Syxdb);
        if(getCreateDateDirtyFlag())
            srfdomain.setCreateDate(CreateDate);
        if(getDycpxhDirtyFlag())
            srfdomain.setDycpxh(Dycpxh);
        if(getCldlDirtyFlag())
            srfdomain.setCldl(Cldl);
        if(getJqxDirtyFlag())
            srfdomain.setJqx(Jqx);
        if(getJqxdqflDirtyFlag())
            srfdomain.setJqxdqfl(Jqxdqfl);
        if(getHsbf_syxDirtyFlag())
            srfdomain.setHsbf_syx(Hsbf_syx);
        if(getSyxdqfsDirtyFlag())
            srfdomain.setSyxdqfs(Syxdqfs);
        if(getHdzkDirtyFlag())
            srfdomain.setHdzk(Hdzk);
        if(getSyxzDirtyFlag())
            srfdomain.setSyxz(Syxz);
        if(getCreateManDirtyFlag())
            srfdomain.setCreateMan(CreateMan);
        if(getCllxmsDirtyFlag())
            srfdomain.setCllxms(Cllxms);
        if(getXcgzjDirtyFlag())
            srfdomain.setXcgzj(Xcgzj);
        if(getBhsbf_syxDirtyFlag())
            srfdomain.setBhsbf_syx(Bhsbf_syx);
        if(getJqxdbDirtyFlag())
            srfdomain.setJqxdb(Jqxdb);
        if(getClsjjzDirtyFlag())
            srfdomain.setClsjjz(Clsjjz);
        if(getSe_syxDirtyFlag())
            srfdomain.setSe_syx(Se_syx);
        if(getHjDirtyFlag())
            srfdomain.setHj(Hj);
        if(getYwlyDirtyFlag())
            srfdomain.setYwly(Ywly);
        if(getHpzlDirtyFlag())
            srfdomain.setHpzl(Hpzl);
        if(getJqxdqfsDirtyFlag())
            srfdomain.setJqxdqfs(Jqxdqfs);
        if(getClzlDirtyFlag())
            srfdomain.setClzl(Clzl);
        if(getSyxdqflDirtyFlag())
            srfdomain.setSyxdqfl(Syxdqfl);
        if(getCjhDirtyFlag())
            srfdomain.setCjh(Cjh);
        if(getCphmDirtyFlag())
            srfdomain.setCphm(Cphm);
        if(getPlDirtyFlag())
            srfdomain.setPl(Pl);
        if(getHsbf_jqxDirtyFlag())
            srfdomain.setHsbf_jqx(Hsbf_jqx);
        if(getJqxdeDirtyFlag())
            srfdomain.setJqxde(Jqxde);
        if(getCIDIdDirtyFlag())
            srfdomain.setCIDId(CIDId);
        if(getBhsbf_jqxDirtyFlag())
            srfdomain.setBhsbf_jqx(Bhsbf_jqx);
        if(getUpdateManDirtyFlag())
            srfdomain.setUpdateMan(UpdateMan);
        if(getCdrqDirtyFlag())
            srfdomain.setCdrq(Cdrq);
        if(getZbzlDirtyFlag())
            srfdomain.setZbzl(Zbzl);
        if(getSe_jqxDirtyFlag())
            srfdomain.setSe_jqx(Se_jqx);
        if(getCPXHNameDirtyFlag())
            srfdomain.setCPXHName(CPXHName);
        if(getORGUSERNameDirtyFlag())
            srfdomain.setORGUSERName(ORGUSERName);
        if(getORGNameDirtyFlag())
            srfdomain.setORGName(ORGName);
        if(getORGUSERIdDirtyFlag())
            srfdomain.setORGUSERId(ORGUSERId);
        if(getCPXHIdDirtyFlag())
            srfdomain.setCPXHId(CPXHId);
        if(getORGIdDirtyFlag())
            srfdomain.setORGId(ORGId);
        return srfdomain;
    }

    public void fromDO(CID srfdomain) {

        if(srfdomain.getSyxdeDirtyFlag())
            this.setSyxde(srfdomain.getSyxde());
        if(srfdomain.getAblDirtyFlag())
            this.setAbl(srfdomain.getAbl());
        if(srfdomain.getFdjhDirtyFlag())
            this.setFdjh(srfdomain.getFdjh());
        if(srfdomain.getHpdsDirtyFlag())
            this.setHpds(srfdomain.getHpds());
        if(srfdomain.getCcs_jqxDirtyFlag())
            this.setCcs_jqx(srfdomain.getCcs_jqx());
        if(srfdomain.getSyxDirtyFlag())
            this.setSyx(srfdomain.getSyx());
        if(srfdomain.getHdzzlDirtyFlag())
            this.setHdzzl(srfdomain.getHdzzl());
        if(srfdomain.getUpdateDateDirtyFlag())
            this.setUpdateDate(srfdomain.getUpdateDate());
        if(srfdomain.getGlDirtyFlag())
            this.setGl(srfdomain.getGl());
        if(srfdomain.getCIDNameDirtyFlag())
            this.setCIDName(srfdomain.getCIDName());
        if(srfdomain.getQdlxDirtyFlag())
            this.setQdlx(srfdomain.getQdlx());
        if(srfdomain.getSyxdbDirtyFlag())
            this.setSyxdb(srfdomain.getSyxdb());
        if(srfdomain.getCreateDateDirtyFlag())
            this.setCreateDate(srfdomain.getCreateDate());
        if(srfdomain.getDycpxhDirtyFlag())
            this.setDycpxh(srfdomain.getDycpxh());
        if(srfdomain.getCldlDirtyFlag())
            this.setCldl(srfdomain.getCldl());
        if(srfdomain.getJqxDirtyFlag())
            this.setJqx(srfdomain.getJqx());
        if(srfdomain.getJqxdqflDirtyFlag())
            this.setJqxdqfl(srfdomain.getJqxdqfl());
        if(srfdomain.getHsbf_syxDirtyFlag())
            this.setHsbf_syx(srfdomain.getHsbf_syx());
        if(srfdomain.getSyxdqfsDirtyFlag())
            this.setSyxdqfs(srfdomain.getSyxdqfs());
        if(srfdomain.getHdzkDirtyFlag())
            this.setHdzk(srfdomain.getHdzk());
        if(srfdomain.getSyxzDirtyFlag())
            this.setSyxz(srfdomain.getSyxz());
        if(srfdomain.getCreateManDirtyFlag())
            this.setCreateMan(srfdomain.getCreateMan());
        if(srfdomain.getCllxmsDirtyFlag())
            this.setCllxms(srfdomain.getCllxms());
        if(srfdomain.getXcgzjDirtyFlag())
            this.setXcgzj(srfdomain.getXcgzj());
        if(srfdomain.getBhsbf_syxDirtyFlag())
            this.setBhsbf_syx(srfdomain.getBhsbf_syx());
        if(srfdomain.getJqxdbDirtyFlag())
            this.setJqxdb(srfdomain.getJqxdb());
        if(srfdomain.getClsjjzDirtyFlag())
            this.setClsjjz(srfdomain.getClsjjz());
        if(srfdomain.getSe_syxDirtyFlag())
            this.setSe_syx(srfdomain.getSe_syx());
        if(srfdomain.getHjDirtyFlag())
            this.setHj(srfdomain.getHj());
        if(srfdomain.getYwlyDirtyFlag())
            this.setYwly(srfdomain.getYwly());
        if(srfdomain.getHpzlDirtyFlag())
            this.setHpzl(srfdomain.getHpzl());
        if(srfdomain.getJqxdqfsDirtyFlag())
            this.setJqxdqfs(srfdomain.getJqxdqfs());
        if(srfdomain.getClzlDirtyFlag())
            this.setClzl(srfdomain.getClzl());
        if(srfdomain.getSyxdqflDirtyFlag())
            this.setSyxdqfl(srfdomain.getSyxdqfl());
        if(srfdomain.getCjhDirtyFlag())
            this.setCjh(srfdomain.getCjh());
        if(srfdomain.getCphmDirtyFlag())
            this.setCphm(srfdomain.getCphm());
        if(srfdomain.getPlDirtyFlag())
            this.setPl(srfdomain.getPl());
        if(srfdomain.getHsbf_jqxDirtyFlag())
            this.setHsbf_jqx(srfdomain.getHsbf_jqx());
        if(srfdomain.getJqxdeDirtyFlag())
            this.setJqxde(srfdomain.getJqxde());
        if(srfdomain.getCIDIdDirtyFlag())
            this.setCIDId(srfdomain.getCIDId());
        if(srfdomain.getBhsbf_jqxDirtyFlag())
            this.setBhsbf_jqx(srfdomain.getBhsbf_jqx());
        if(srfdomain.getUpdateManDirtyFlag())
            this.setUpdateMan(srfdomain.getUpdateMan());
        if(srfdomain.getCdrqDirtyFlag())
            this.setCdrq(srfdomain.getCdrq());
        if(srfdomain.getZbzlDirtyFlag())
            this.setZbzl(srfdomain.getZbzl());
        if(srfdomain.getSe_jqxDirtyFlag())
            this.setSe_jqx(srfdomain.getSe_jqx());
        if(srfdomain.getCPXHNameDirtyFlag())
            this.setCPXHName(srfdomain.getCPXHName());
        if(srfdomain.getORGUSERNameDirtyFlag())
            this.setORGUSERName(srfdomain.getORGUSERName());
        if(srfdomain.getORGNameDirtyFlag())
            this.setORGName(srfdomain.getORGName());
        if(srfdomain.getORGUSERIdDirtyFlag())
            this.setORGUSERId(srfdomain.getORGUSERId());
        if(srfdomain.getCPXHIdDirtyFlag())
            this.setCPXHId(srfdomain.getCPXHId());
        if(srfdomain.getORGIdDirtyFlag())
            this.setORGId(srfdomain.getORGId());

    }

    public List<CIDDTO> fromDOPage(List<CID> poPage)   {
        if(poPage == null)
            return null;
        List<CIDDTO> dtos=new ArrayList<CIDDTO>();
        for(CID domain : poPage) {
            CIDDTO dto = new CIDDTO();
            dto.fromDO(domain);
            dtos.add(dto);
        }
        return dtos;
    }
}

