package com.sinosig.mongodb;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.UUID;
import java.util.HashMap;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.WriteResult;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import com.sinosig.core.repository.SYXXXRepository;
import com.sinosig.core.repository.po.SYXXX;
import com.sinosig.mongodb.po.HSYXXXImpl;
import com.sinosig.core.module.filter.SYXXXSearchContext;

/**
 * 关系型数据实体表[SYXXX] 对象
 */
@Repository
@ConditionalOnProperty(prefix = "syxxx", value="store" , havingValue = "nosql", matchIfMissing = false)
public class HSYXXXRepositoryImpl implements SYXXXRepository{

    @Autowired
    private MongoTemplate mongoTemplate;

    public SYXXX createPO() {
		return new HSYXXXImpl();
	}

	public SYXXX get(String key) {
        Query query = new Query(Criteria.where("syxxxid").is(key));
		return mongoTemplate.findOne(query, HSYXXXImpl.class,"hsyxxx");
	}

	public boolean create(SYXXX po) {
        if(po.getSYXXXId()==null){
			po.setSYXXXId(UUID.randomUUID().toString());
		}
		mongoTemplate.save(po,"hsyxxx");
		return true;
	}

	public boolean update(SYXXX po) {
		Query query = new Query(Criteria.where("syxxxid").is(po.getSYXXXId()));
        Update update = new Update();
        String str = JSON.toJSONString(po);
        JSONObject jQuery = JSON.parseObject(str);
        jQuery.forEach((key, value) -> {
            if (!key.equals("syxxxid")) {
                update.set(key, value);
            }
        });
        UpdateResult updateResult = mongoTemplate.updateFirst(query, update, SYXXX.class, "hsyxxx");
        if(updateResult!=null && updateResult.getMatchedCount()>0)
        	return true ;
		return false;
	}

	public boolean remove(String key) {
		Query query = new Query(Criteria.where("syxxxid").is(key));
        DeleteResult deleteResult = mongoTemplate.remove(query,SYXXX.class,"hsyxxx");
        if(deleteResult != null && deleteResult.getDeletedCount()>0)
        	return true ;
        return false ;
	}

    public Page<SYXXX> searchDefault(SYXXXSearchContext context){
        List<SYXXX> list = new ArrayList<SYXXX>() ;
        Map<String, String> conditions = null ;
    	if (ObjectUtils.isEmpty(conditions)) {
            List<HSYXXXImpl> listImpl = mongoTemplate.findAll(HSYXXXImpl.class,"hsyxxx");
            for (HSYXXXImpl hsyxxxImpl : listImpl) {
				list.add(hsyxxxImpl);
			}
        } else {
            //设置分页参数
            Query query = new Query();
            query.limit(100);
            query.skip(1);
            // 往query中注入查询条件
            conditions.forEach((key, value) -> query.addCriteria(Criteria.where(key).is(value)));
            list = mongoTemplate.find(query, SYXXX.class,"hsyxxx");
        }
        return new PageImpl<SYXXX>(list, context.getPageable(), 10000);
    }


    public com.sinosig.core.module.domain.SYXXX convert2Domain( SYXXX po ,com.sinosig.core.module.domain.SYXXX domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module.domain.SYXXX();
              }
              BeanCopier copier=BeanCopier.create(po.getClass(), domain.getClass(), false);
              copier.copy(po, domain, null);
              return domain ;
    }

    public SYXXX convert2PO(com.sinosig.core.module.domain.SYXXX domain , SYXXX po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        BeanCopier copier=BeanCopier.create(domain.getClass(), po.getClass(), false);
        copier.copy(domain, po, null);
        return po ;
    }

}

