package com.sinosig.mybatis.module;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import com.sinosig.core.repository.CUSTOMERRepository;
import com.sinosig.core.repository.po.CUSTOMER;
import com.sinosig.core.module.filter.CUSTOMERSearchContext;
import com.sinosig.mybatis.module.mapper.T_CUSTOMERMapper;
import com.sinosig.mybatis.module.po.T_CUSTOMERImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosig.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_CUSTOMER] 存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "customer", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_CUSTOMERRepositoryImpl extends ServiceImpl<T_CUSTOMERMapper, T_CUSTOMERImpl> implements CUSTOMERRepository {

    @Autowired
    QueryBuilder queryBuilder;

    private boolean isLogicValid = false ;

    @Autowired
	T_CUSTOMERMapper t_CUSTOMERMapper;

    public CUSTOMER createPO(){
        return new T_CUSTOMERImpl();
    }

    public CUSTOMER get(String key){
        return this.getById(key);
    }


    public boolean create(CUSTOMER po){
        return this.save((T_CUSTOMERImpl)po);
    }

    public boolean update(CUSTOMER po){
        return this.updateById((T_CUSTOMERImpl)po);
    }

    public boolean remove(String key){
        return this.removeById(key);
    }

    public Page<CUSTOMER> searchDefault(CUSTOMERSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<CUSTOMER> page_datas=t_CUSTOMERMapper.searchDefault(page,context,qw);
        List<CUSTOMER> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<CUSTOMER>(list_datas, context.getPageable(), page_datas.getTotal());
    }


    public com.sinosig.core.module.domain.CUSTOMER convert2Domain( CUSTOMER po ,com.sinosig.core.module.domain.CUSTOMER domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module.domain.CUSTOMER();
              }
            //if(po.getKhlxDirtyFlag())
                domain.setKhlx(po.getKhlx());
            //if(po.getZjlxDirtyFlag())
                domain.setZjlx(po.getZjlx());
            //if(po.getCUSTOMERIdDirtyFlag())
                domain.setCUSTOMERId(po.getCUSTOMERId());
            //if(po.getUpdateManDirtyFlag())
                domain.setUpdateMan(po.getUpdateMan());
            //if(po.getCreateDateDirtyFlag())
                domain.setCreateDate(po.getCreateDate());
            //if(po.getXbDirtyFlag())
                domain.setXb(po.getXb());
            //if(po.getCUSTOMERNameDirtyFlag())
                domain.setCUSTOMERName(po.getCUSTOMERName());
            //if(po.getCreateManDirtyFlag())
                domain.setCreateMan(po.getCreateMan());
            //if(po.getCsnyDirtyFlag())
                domain.setCsny(po.getCsny());
            //if(po.getZjhmDirtyFlag())
                domain.setZjhm(po.getZjhm());
            //if(po.getUpdateDateDirtyFlag())
                domain.setUpdateDate(po.getUpdateDate());
            //if(po.getNlDirtyFlag())
                domain.setNl(po.getNl());
            //if(po.getCIDIdDirtyFlag())
                domain.setCIDId(po.getCIDId());
              return domain ;
    }

    public CUSTOMER convert2PO(com.sinosig.core.module.domain.CUSTOMER domain , CUSTOMER po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getKhlxDirtyFlag())
            po.setKhlx(domain.getKhlx());
        if(domain.getZjlxDirtyFlag())
            po.setZjlx(domain.getZjlx());
        if(domain.getCUSTOMERIdDirtyFlag())
            po.setCUSTOMERId(domain.getCUSTOMERId());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getXbDirtyFlag())
            po.setXb(domain.getXb());
        if(domain.getCUSTOMERNameDirtyFlag())
            po.setCUSTOMERName(domain.getCUSTOMERName());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getCsnyDirtyFlag())
            po.setCsny(domain.getCsny());
        if(domain.getZjhmDirtyFlag())
            po.setZjhm(domain.getZjhm());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getNlDirtyFlag())
            po.setNl(domain.getNl());
        if(domain.getCIDIdDirtyFlag())
            po.setCIDId(domain.getCIDId());

        return po ;
    }
}
