package com.sinosig.mongodb;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.UUID;
import java.util.HashMap;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.WriteResult;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import com.sinosig.core.repository.JQXXXRepository;
import com.sinosig.core.repository.po.JQXXX;
import com.sinosig.mongodb.po.HJQXXXImpl;
import com.sinosig.core.module.filter.JQXXXSearchContext;

/**
 * 关系型数据实体表[JQXXX] 对象
 */
@Repository
@ConditionalOnProperty(prefix = "jqxxx", value="store" , havingValue = "nosql", matchIfMissing = false)
public class HJQXXXRepositoryImpl implements JQXXXRepository{

    @Autowired
    private MongoTemplate mongoTemplate;

    public JQXXX createPO() {
		return new HJQXXXImpl();
	}

	public JQXXX get(String key) {
        Query query = new Query(Criteria.where("jqxxxid").is(key));
		return mongoTemplate.findOne(query, HJQXXXImpl.class,"hjqxxx");
	}

	public boolean create(JQXXX po) {
        if(po.getJQXXXId()==null){
			po.setJQXXXId(UUID.randomUUID().toString());
		}
		mongoTemplate.save(po,"hjqxxx");
		return true;
	}

	public boolean update(JQXXX po) {
		Query query = new Query(Criteria.where("jqxxxid").is(po.getJQXXXId()));
        Update update = new Update();
        String str = JSON.toJSONString(po);
        JSONObject jQuery = JSON.parseObject(str);
        jQuery.forEach((key, value) -> {
            if (!key.equals("jqxxxid")) {
                update.set(key, value);
            }
        });
        UpdateResult updateResult = mongoTemplate.updateFirst(query, update, JQXXX.class, "hjqxxx");
        if(updateResult!=null && updateResult.getMatchedCount()>0)
        	return true ;
		return false;
	}

	public boolean remove(String key) {
		Query query = new Query(Criteria.where("jqxxxid").is(key));
        DeleteResult deleteResult = mongoTemplate.remove(query,JQXXX.class,"hjqxxx");
        if(deleteResult != null && deleteResult.getDeletedCount()>0)
        	return true ;
        return false ;
	}

    public Page<JQXXX> searchDefault(JQXXXSearchContext context){
        List<JQXXX> list = new ArrayList<JQXXX>() ;
        Map<String, String> conditions = null ;
    	if (ObjectUtils.isEmpty(conditions)) {
            List<HJQXXXImpl> listImpl = mongoTemplate.findAll(HJQXXXImpl.class,"hjqxxx");
            for (HJQXXXImpl hjqxxxImpl : listImpl) {
				list.add(hjqxxxImpl);
			}
        } else {
            //设置分页参数
            Query query = new Query();
            query.limit(100);
            query.skip(1);
            // 往query中注入查询条件
            conditions.forEach((key, value) -> query.addCriteria(Criteria.where(key).is(value)));
            list = mongoTemplate.find(query, JQXXX.class,"hjqxxx");
        }
        return new PageImpl<JQXXX>(list, context.getPageable(), 10000);
    }


    public com.sinosig.core.module.domain.JQXXX convert2Domain( JQXXX po ,com.sinosig.core.module.domain.JQXXX domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module.domain.JQXXX();
              }
              BeanCopier copier=BeanCopier.create(po.getClass(), domain.getClass(), false);
              copier.copy(po, domain, null);
              return domain ;
    }

    public JQXXX convert2PO(com.sinosig.core.module.domain.JQXXX domain , JQXXX po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        BeanCopier copier=BeanCopier.create(domain.getClass(), po.getClass(), false);
        copier.copy(domain, po, null);
        return po ;
    }

}

