package com.sinosig.mongodb;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.UUID;
import java.util.HashMap;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.WriteResult;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import com.sinosig.core.repository.YDJJDCRepository;
import com.sinosig.core.repository.po.YDJJDC;
import com.sinosig.mongodb.po.HYDJJDCImpl;
import com.sinosig.core.module2.filter.YDJJDCSearchContext;

/**
 * 关系型数据实体表[YDJJDC] 对象
 */
@Repository
@ConditionalOnProperty(prefix = "ydjjdc", value="store" , havingValue = "nosql", matchIfMissing = false)
public class HYDJJDCRepositoryImpl implements YDJJDCRepository{

    @Autowired
    private MongoTemplate mongoTemplate;

    public YDJJDC createPO() {
		return new HYDJJDCImpl();
	}

	public YDJJDC get(String key) {
        Query query = new Query(Criteria.where("ydjjdcid").is(key));
		return mongoTemplate.findOne(query, HYDJJDCImpl.class,"hydjjdc");
	}

	public boolean create(YDJJDC po) {
        if(po.getYDJJDCId()==null){
			po.setYDJJDCId(UUID.randomUUID().toString());
		}
		mongoTemplate.save(po,"hydjjdc");
		return true;
	}

	public boolean update(YDJJDC po) {
		Query query = new Query(Criteria.where("ydjjdcid").is(po.getYDJJDCId()));
        Update update = new Update();
        String str = JSON.toJSONString(po);
        JSONObject jQuery = JSON.parseObject(str);
        jQuery.forEach((key, value) -> {
            if (!key.equals("ydjjdcid")) {
                update.set(key, value);
            }
        });
        UpdateResult updateResult = mongoTemplate.updateFirst(query, update, YDJJDC.class, "hydjjdc");
        if(updateResult!=null && updateResult.getMatchedCount()>0)
        	return true ;
		return false;
	}

	public boolean remove(String key) {
		Query query = new Query(Criteria.where("ydjjdcid").is(key));
        DeleteResult deleteResult = mongoTemplate.remove(query,YDJJDC.class,"hydjjdc");
        if(deleteResult != null && deleteResult.getDeletedCount()>0)
        	return true ;
        return false ;
	}

    public Page<YDJJDC> searchDefault(YDJJDCSearchContext context){
        List<YDJJDC> list = new ArrayList<YDJJDC>() ;
        Map<String, String> conditions = null ;
    	if (ObjectUtils.isEmpty(conditions)) {
            List<HYDJJDCImpl> listImpl = mongoTemplate.findAll(HYDJJDCImpl.class,"hydjjdc");
            for (HYDJJDCImpl hydjjdcImpl : listImpl) {
				list.add(hydjjdcImpl);
			}
        } else {
            //设置分页参数
            Query query = new Query();
            query.limit(100);
            query.skip(1);
            // 往query中注入查询条件
            conditions.forEach((key, value) -> query.addCriteria(Criteria.where(key).is(value)));
            list = mongoTemplate.find(query, YDJJDC.class,"hydjjdc");
        }
        return new PageImpl<YDJJDC>(list, context.getPageable(), 10000);
    }


    public com.sinosig.core.module2.domain.YDJJDC convert2Domain( YDJJDC po ,com.sinosig.core.module2.domain.YDJJDC domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module2.domain.YDJJDC();
              }
              BeanCopier copier=BeanCopier.create(po.getClass(), domain.getClass(), false);
              copier.copy(po, domain, null);
              return domain ;
    }

    public YDJJDC convert2PO(com.sinosig.core.module2.domain.YDJJDC domain , YDJJDC po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        BeanCopier copier=BeanCopier.create(domain.getClass(), po.getClass(), false);
        copier.copy(domain, po, null);
        return po ;
    }

}

