package com.sinosig.mybatis.module;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import com.sinosig.core.repository.DBDRepository;
import com.sinosig.core.repository.po.DBD;
import com.sinosig.core.module.filter.DBDSearchContext;
import com.sinosig.mybatis.module.mapper.T_DBDMapper;
import com.sinosig.mybatis.module.po.T_DBDImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosig.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_DBD] 存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "dbd", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_DBDRepositoryImpl extends ServiceImpl<T_DBDMapper, T_DBDImpl> implements DBDRepository {

    @Autowired
    QueryBuilder queryBuilder;

    private boolean isLogicValid = false ;

    @Autowired
	T_DBDMapper t_DBDMapper;

    public DBD createPO(){
        return new T_DBDImpl();
    }

    public DBD get(String key){
        return this.getById(key);
    }


    public boolean create(DBD po){
        return this.save((T_DBDImpl)po);
    }

    public boolean update(DBD po){
        return this.updateById((T_DBDImpl)po);
    }

    public boolean remove(String key){
        return this.removeById(key);
    }

    public Page<DBD> searchDefault(DBDSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<DBD> page_datas=t_DBDMapper.searchDefault(page,context,qw);
        List<DBD> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<DBD>(list_datas, context.getPageable(), page_datas.getTotal());
    }


    public com.sinosig.core.module.domain.DBD convert2Domain( DBD po ,com.sinosig.core.module.domain.DBD domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module.domain.DBD();
              }
            //if(po.getTbdhDirtyFlag())
                domain.setTbdh(po.getTbdh());
            //if(po.getUpdateDateDirtyFlag())
                domain.setUpdateDate(po.getUpdateDate());
            //if(po.getHbxxDirtyFlag())
                domain.setHbxx(po.getHbxx());
            //if(po.getCzrDirtyFlag())
                domain.setCzr(po.getCzr());
            //if(po.getCphDirtyFlag())
                domain.setCph(po.getCph());
            //if(po.getDBDIdDirtyFlag())
                domain.setDBDId(po.getDBDId());
            //if(po.getSrrqDirtyFlag())
                domain.setSrrq(po.getSrrq());
            //if(po.getUpdateManDirtyFlag())
                domain.setUpdateMan(po.getUpdateMan());
            //if(po.getDBDNameDirtyFlag())
                domain.setDBDName(po.getDBDName());
            //if(po.getCreateManDirtyFlag())
                domain.setCreateMan(po.getCreateMan());
            //if(po.getBxqqDirtyFlag())
                domain.setBxqq(po.getBxqq());
            //if(po.getYxDirtyFlag())
                domain.setYx(po.getYx());
            //if(po.getHbDirtyFlag())
                domain.setHb(po.getHb());
            //if(po.getCreateDateDirtyFlag())
                domain.setCreateDate(po.getCreateDate());
            //if(po.getBbxrDirtyFlag())
                domain.setBbxr(po.getBbxr());
            //if(po.getXyhDirtyFlag())
                domain.setXyh(po.getXyh());
              return domain ;
    }

    public DBD convert2PO(com.sinosig.core.module.domain.DBD domain , DBD po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getTbdhDirtyFlag())
            po.setTbdh(domain.getTbdh());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getHbxxDirtyFlag())
            po.setHbxx(domain.getHbxx());
        if(domain.getCzrDirtyFlag())
            po.setCzr(domain.getCzr());
        if(domain.getCphDirtyFlag())
            po.setCph(domain.getCph());
        if(domain.getDBDIdDirtyFlag())
            po.setDBDId(domain.getDBDId());
        if(domain.getSrrqDirtyFlag())
            po.setSrrq(domain.getSrrq());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getDBDNameDirtyFlag())
            po.setDBDName(domain.getDBDName());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getBxqqDirtyFlag())
            po.setBxqq(domain.getBxqq());
        if(domain.getYxDirtyFlag())
            po.setYx(domain.getYx());
        if(domain.getHbDirtyFlag())
            po.setHb(domain.getHb());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getBbxrDirtyFlag())
            po.setBbxr(domain.getBbxr());
        if(domain.getXyhDirtyFlag())
            po.setXyh(domain.getXyh());

        return po ;
    }
}
