package com.sinosig.mybatis.module2;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import com.sinosig.core.repository.YDJJDCRepository;
import com.sinosig.core.repository.po.YDJJDC;
import com.sinosig.core.module2.filter.YDJJDCSearchContext;
import com.sinosig.mybatis.module2.mapper.T_YDJJDCMapper;
import com.sinosig.mybatis.module2.po.T_YDJJDCImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosig.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_YDJJDC] 存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "ydjjdc", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_YDJJDCRepositoryImpl extends ServiceImpl<T_YDJJDCMapper, T_YDJJDCImpl> implements YDJJDCRepository {

    @Autowired
    QueryBuilder queryBuilder;

    private boolean isLogicValid = false ;

    @Autowired
	T_YDJJDCMapper t_YDJJDCMapper;

    public YDJJDC createPO(){
        return new T_YDJJDCImpl();
    }

    public YDJJDC get(String key){
        return this.getById(key);
    }


    public boolean create(YDJJDC po){
        return this.save((T_YDJJDCImpl)po);
    }

    public boolean update(YDJJDC po){
        return this.updateById((T_YDJJDCImpl)po);
    }

    public boolean remove(String key){
        return this.removeById(key);
    }

    public Page<YDJJDC> searchDefault(YDJJDCSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<YDJJDC> page_datas=t_YDJJDCMapper.searchDefault(page,context,qw);
        List<YDJJDC> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<YDJJDC>(list_datas, context.getPageable(), page_datas.getTotal());
    }


    public com.sinosig.core.module2.domain.YDJJDC convert2Domain( YDJJDC po ,com.sinosig.core.module2.domain.YDJJDC domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module2.domain.YDJJDC();
              }
            //if(po.getCreateDateDirtyFlag())
                domain.setCreateDate(po.getCreateDate());
            //if(po.getCreateManDirtyFlag())
                domain.setCreateMan(po.getCreateMan());
            //if(po.getCPXHDirtyFlag())
                domain.setCPXH(po.getCPXH());
            //if(po.getFdjhDirtyFlag())
                domain.setFdjh(po.getFdjh());
            //if(po.getCldlDirtyFlag())
                domain.setCldl(po.getCldl());
            //if(po.getUpdateManDirtyFlag())
                domain.setUpdateMan(po.getUpdateMan());
            //if(po.getGlDirtyFlag())
                domain.setGl(po.getGl());
            //if(po.getHpzlDirtyFlag())
                domain.setHpzl(po.getHpzl());
            //if(po.getCphmDirtyFlag())
                domain.setCphm(po.getCphm());
            //if(po.getCdrqDirtyFlag())
                domain.setCdrq(po.getCdrq());
            //if(po.getHdzkDirtyFlag())
                domain.setHdzk(po.getHdzk());
            //if(po.getPlDirtyFlag())
                domain.setPl(po.getPl());
            //if(po.getClsjjzDirtyFlag())
                domain.setClsjjz(po.getClsjjz());
            //if(po.getDycpxhDirtyFlag())
                domain.setDycpxh(po.getDycpxh());
            //if(po.getSyxzDirtyFlag())
                domain.setSyxz(po.getSyxz());
            //if(po.getClzlDirtyFlag())
                domain.setClzl(po.getClzl());
            //if(po.getZbzlDirtyFlag())
                domain.setZbzl(po.getZbzl());
            //if(po.getYDJJDCNameDirtyFlag())
                domain.setYDJJDCName(po.getYDJJDCName());
            //if(po.getXcgzjDirtyFlag())
                domain.setXcgzj(po.getXcgzj());
            //if(po.getUpdateDateDirtyFlag())
                domain.setUpdateDate(po.getUpdateDate());
            //if(po.getHdzzlDirtyFlag())
                domain.setHdzzl(po.getHdzzl());
            //if(po.getAblDirtyFlag())
                domain.setAbl(po.getAbl());
            //if(po.getCllxmsDirtyFlag())
                domain.setCllxms(po.getCllxms());
            //if(po.getCjhDirtyFlag())
                domain.setCjh(po.getCjh());
            //if(po.getHpdsDirtyFlag())
                domain.setHpds(po.getHpds());
            //if(po.getYDJJDCIdDirtyFlag())
                domain.setYDJJDCId(po.getYDJJDCId());
              return domain ;
    }

    public YDJJDC convert2PO(com.sinosig.core.module2.domain.YDJJDC domain , YDJJDC po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getCPXHDirtyFlag())
            po.setCPXH(domain.getCPXH());
        if(domain.getFdjhDirtyFlag())
            po.setFdjh(domain.getFdjh());
        if(domain.getCldlDirtyFlag())
            po.setCldl(domain.getCldl());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getGlDirtyFlag())
            po.setGl(domain.getGl());
        if(domain.getHpzlDirtyFlag())
            po.setHpzl(domain.getHpzl());
        if(domain.getCphmDirtyFlag())
            po.setCphm(domain.getCphm());
        if(domain.getCdrqDirtyFlag())
            po.setCdrq(domain.getCdrq());
        if(domain.getHdzkDirtyFlag())
            po.setHdzk(domain.getHdzk());
        if(domain.getPlDirtyFlag())
            po.setPl(domain.getPl());
        if(domain.getClsjjzDirtyFlag())
            po.setClsjjz(domain.getClsjjz());
        if(domain.getDycpxhDirtyFlag())
            po.setDycpxh(domain.getDycpxh());
        if(domain.getSyxzDirtyFlag())
            po.setSyxz(domain.getSyxz());
        if(domain.getClzlDirtyFlag())
            po.setClzl(domain.getClzl());
        if(domain.getZbzlDirtyFlag())
            po.setZbzl(domain.getZbzl());
        if(domain.getYDJJDCNameDirtyFlag())
            po.setYDJJDCName(domain.getYDJJDCName());
        if(domain.getXcgzjDirtyFlag())
            po.setXcgzj(domain.getXcgzj());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getHdzzlDirtyFlag())
            po.setHdzzl(domain.getHdzzl());
        if(domain.getAblDirtyFlag())
            po.setAbl(domain.getAbl());
        if(domain.getCllxmsDirtyFlag())
            po.setCllxms(domain.getCllxms());
        if(domain.getCjhDirtyFlag())
            po.setCjh(domain.getCjh());
        if(domain.getHpdsDirtyFlag())
            po.setHpds(domain.getHpds());
        if(domain.getYDJJDCIdDirtyFlag())
            po.setYDJJDCId(domain.getYDJJDCId());

        return po ;
    }
}
