package com.sinosig.mybatis.module;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import com.sinosig.core.repository.SYXXXRepository;
import com.sinosig.core.repository.po.SYXXX;
import com.sinosig.core.module.filter.SYXXXSearchContext;
import com.sinosig.mybatis.module.mapper.T_SYXXXMapper;
import com.sinosig.mybatis.module.po.T_SYXXXImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosig.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_SYXXX] 存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "syxxx", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_SYXXXRepositoryImpl extends ServiceImpl<T_SYXXXMapper, T_SYXXXImpl> implements SYXXXRepository {

    @Autowired
    QueryBuilder queryBuilder;

    private boolean isLogicValid = false ;

    @Autowired
	T_SYXXXMapper t_SYXXXMapper;

    public SYXXX createPO(){
        return new T_SYXXXImpl();
    }

    public SYXXX get(String key){
        return this.getById(key);
    }


    public boolean create(SYXXX po){
        return this.save((T_SYXXXImpl)po);
    }

    public boolean update(SYXXX po){
        return this.updateById((T_SYXXXImpl)po);
    }

    public boolean remove(String key){
        return this.removeById(key);
    }

    public Page<SYXXX> searchDefault(SYXXXSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<SYXXX> page_datas=t_SYXXXMapper.searchDefault(page,context,qw);
        List<SYXXX> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<SYXXX>(list_datas, context.getPageable(), page_datas.getTotal());
    }


    public com.sinosig.core.module.domain.SYXXX convert2Domain( SYXXX po ,com.sinosig.core.module.domain.SYXXX domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module.domain.SYXXX();
              }
            //if(po.getCreateManDirtyFlag())
                domain.setCreateMan(po.getCreateMan());
            //if(po.getZzxsDirtyFlag())
                domain.setZzxs(po.getZzxs());
            //if(po.getZrxeDirtyFlag())
                domain.setZrxe(po.getZrxe());
            //if(po.getFlDirtyFlag())
                domain.setFl(po.getFl());
            //if(po.getSYXXXIdDirtyFlag())
                domain.setSYXXXId(po.getSYXXXId());
            //if(po.getTkdmDirtyFlag())
                domain.setTkdm(po.getTkdm());
            //if(po.getCreateDateDirtyFlag())
                domain.setCreateDate(po.getCreateDate());
            //if(po.getPtfhxsDirtyFlag())
                domain.setPtfhxs(po.getPtfhxs());
            //if(po.getMdDirtyFlag())
                domain.setMd(po.getMd());
            //if(po.getUpdateManDirtyFlag())
                domain.setUpdateMan(po.getUpdateMan());
            //if(po.getUpdateDateDirtyFlag())
                domain.setUpdateDate(po.getUpdateDate());
            //if(po.getJzbfDirtyFlag())
                domain.setJzbf(po.getJzbf());
            //if(po.getSjbfDirtyFlag())
                domain.setSjbf(po.getSjbf());
            //if(po.getBjmpDirtyFlag())
                domain.setBjmp(po.getBjmp());
            //if(po.getSYXXXNameDirtyFlag())
                domain.setSYXXXName(po.getSYXXXName());
            //if(po.getTkmcDirtyFlag())
                domain.setTkmc(po.getTkmc());
            //if(po.getCIDIdDirtyFlag())
                domain.setCIDId(po.getCIDId());
              return domain ;
    }

    public SYXXX convert2PO(com.sinosig.core.module.domain.SYXXX domain , SYXXX po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getZzxsDirtyFlag())
            po.setZzxs(domain.getZzxs());
        if(domain.getZrxeDirtyFlag())
            po.setZrxe(domain.getZrxe());
        if(domain.getFlDirtyFlag())
            po.setFl(domain.getFl());
        if(domain.getSYXXXIdDirtyFlag())
            po.setSYXXXId(domain.getSYXXXId());
        if(domain.getTkdmDirtyFlag())
            po.setTkdm(domain.getTkdm());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getPtfhxsDirtyFlag())
            po.setPtfhxs(domain.getPtfhxs());
        if(domain.getMdDirtyFlag())
            po.setMd(domain.getMd());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getJzbfDirtyFlag())
            po.setJzbf(domain.getJzbf());
        if(domain.getSjbfDirtyFlag())
            po.setSjbf(domain.getSjbf());
        if(domain.getBjmpDirtyFlag())
            po.setBjmp(domain.getBjmp());
        if(domain.getSYXXXNameDirtyFlag())
            po.setSYXXXName(domain.getSYXXXName());
        if(domain.getTkmcDirtyFlag())
            po.setTkmc(domain.getTkmc());
        if(domain.getCIDIdDirtyFlag())
            po.setCIDId(domain.getCIDId());

        return po ;
    }
}
