package com.sinosig.mybatis.module;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import com.sinosig.core.repository.SYXTBYDRepository;
import com.sinosig.core.repository.po.SYXTBYD;
import com.sinosig.core.module.filter.SYXTBYDSearchContext;
import com.sinosig.mybatis.module.mapper.T_SYXTBYDMapper;
import com.sinosig.mybatis.module.po.T_SYXTBYDImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosig.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_SYXTBYD] 存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "syxtbyd", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_SYXTBYDRepositoryImpl extends ServiceImpl<T_SYXTBYDMapper, T_SYXTBYDImpl> implements SYXTBYDRepository {

    @Autowired
    QueryBuilder queryBuilder;

    private boolean isLogicValid = false ;

    @Autowired
	T_SYXTBYDMapper t_SYXTBYDMapper;

    public SYXTBYD createPO(){
        return new T_SYXTBYDImpl();
    }

    public SYXTBYD get(String key){
        return this.getById(key);
    }


    public boolean create(SYXTBYD po){
        return this.save((T_SYXTBYDImpl)po);
    }

    public boolean update(SYXTBYD po){
        return this.updateById((T_SYXTBYDImpl)po);
    }

    public boolean remove(String key){
        return this.removeById(key);
    }

    public Page<SYXTBYD> searchDefault(SYXTBYDSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<SYXTBYD> page_datas=t_SYXTBYDMapper.searchDefault(page,context,qw);
        List<SYXTBYD> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<SYXTBYD>(list_datas, context.getPageable(), page_datas.getTotal());
    }


    public com.sinosig.core.module.domain.SYXTBYD convert2Domain( SYXTBYD po ,com.sinosig.core.module.domain.SYXTBYD domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module.domain.SYXTBYD();
              }
            //if(po.getSYXTBYDIdDirtyFlag())
                domain.setSYXTBYDId(po.getSYXTBYDId());
            //if(po.getSYXTBYDNameDirtyFlag())
                domain.setSYXTBYDName(po.getSYXTBYDName());
            //if(po.getUpdateDateDirtyFlag())
                domain.setUpdateDate(po.getUpdateDate());
            //if(po.getXhDirtyFlag())
                domain.setXh(po.getXh());
            //if(po.getTymcDirtyFlag())
                domain.setTymc(po.getTymc());
            //if(po.getCreateManDirtyFlag())
                domain.setCreateMan(po.getCreateMan());
            //if(po.getCreateDateDirtyFlag())
                domain.setCreateDate(po.getCreateDate());
            //if(po.getUpdateManDirtyFlag())
                domain.setUpdateMan(po.getUpdateMan());
            //if(po.getTynrDirtyFlag())
                domain.setTynr(po.getTynr());
            //if(po.getTBYDKNameDirtyFlag())
                domain.setTBYDKName(po.getTBYDKName());
            //if(po.getTBYDKIdDirtyFlag())
                domain.setTBYDKId(po.getTBYDKId());
            //if(po.getCIDIdDirtyFlag())
                domain.setCIDId(po.getCIDId());
              return domain ;
    }

    public SYXTBYD convert2PO(com.sinosig.core.module.domain.SYXTBYD domain , SYXTBYD po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getSYXTBYDIdDirtyFlag())
            po.setSYXTBYDId(domain.getSYXTBYDId());
        if(domain.getSYXTBYDNameDirtyFlag())
            po.setSYXTBYDName(domain.getSYXTBYDName());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getXhDirtyFlag())
            po.setXh(domain.getXh());
        if(domain.getTymcDirtyFlag())
            po.setTymc(domain.getTymc());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getTynrDirtyFlag())
            po.setTynr(domain.getTynr());
        if(domain.getTBYDKNameDirtyFlag())
            po.setTBYDKName(domain.getTBYDKName());
        if(domain.getTBYDKIdDirtyFlag())
            po.setTBYDKId(domain.getTBYDKId());
        if(domain.getCIDIdDirtyFlag())
            po.setCIDId(domain.getCIDId());

        return po ;
    }
}
