package com.sinosig.mybatis.module;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import com.sinosig.core.repository.SJZDRepository;
import com.sinosig.core.repository.po.SJZD;
import com.sinosig.core.module.filter.SJZDSearchContext;
import com.sinosig.mybatis.module.mapper.T_SJZDMapper;
import com.sinosig.mybatis.module.po.T_SJZDImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosig.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_SJZD] 存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "sjzd", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_SJZDRepositoryImpl extends ServiceImpl<T_SJZDMapper, T_SJZDImpl> implements SJZDRepository {

    @Autowired
    QueryBuilder queryBuilder;

    private boolean isLogicValid = false ;

    @Autowired
	T_SJZDMapper t_SJZDMapper;

    public SJZD createPO(){
        return new T_SJZDImpl();
    }

    public SJZD get(String key){
        return this.getById(key);
    }


    public boolean create(SJZD po){
        return this.save((T_SJZDImpl)po);
    }

    public boolean update(SJZD po){
        return this.updateById((T_SJZDImpl)po);
    }

    public boolean remove(String key){
        return this.removeById(key);
    }

    public Page<SJZD> searchDefault(SJZDSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<SJZD> page_datas=t_SJZDMapper.searchDefault(page,context,qw);
        List<SJZD> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<SJZD>(list_datas, context.getPageable(), page_datas.getTotal());
    }


    public com.sinosig.core.module.domain.SJZD convert2Domain( SJZD po ,com.sinosig.core.module.domain.SJZD domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module.domain.SJZD();
              }
            //if(po.getUpdateDateDirtyFlag())
                domain.setUpdateDate(po.getUpdateDate());
            //if(po.getUpdateManDirtyFlag())
                domain.setUpdateMan(po.getUpdateMan());
            //if(po.getSJZDNameDirtyFlag())
                domain.setSJZDName(po.getSJZDName());
            //if(po.getSJZDIdDirtyFlag())
                domain.setSJZDId(po.getSJZDId());
            //if(po.getBhDirtyFlag())
                domain.setBh(po.getBh());
            //if(po.getCreateManDirtyFlag())
                domain.setCreateMan(po.getCreateMan());
            //if(po.getCreateDateDirtyFlag())
                domain.setCreateDate(po.getCreateDate());
              return domain ;
    }

    public SJZD convert2PO(com.sinosig.core.module.domain.SJZD domain , SJZD po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getSJZDNameDirtyFlag())
            po.setSJZDName(domain.getSJZDName());
        if(domain.getSJZDIdDirtyFlag())
            po.setSJZDId(domain.getSJZDId());
        if(domain.getBhDirtyFlag())
            po.setBh(domain.getBh());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());

        return po ;
    }
}
