package com.sinosig.mybatis.module;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import com.sinosig.core.repository.JQXXXRepository;
import com.sinosig.core.repository.po.JQXXX;
import com.sinosig.core.module.filter.JQXXXSearchContext;
import com.sinosig.mybatis.module.mapper.T_JQXXXMapper;
import com.sinosig.mybatis.module.po.T_JQXXXImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosig.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_JQXXX] 存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "jqxxx", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_JQXXXRepositoryImpl extends ServiceImpl<T_JQXXXMapper, T_JQXXXImpl> implements JQXXXRepository {

    @Autowired
    QueryBuilder queryBuilder;

    private boolean isLogicValid = false ;

    @Autowired
	T_JQXXXMapper t_JQXXXMapper;

    public JQXXX createPO(){
        return new T_JQXXXImpl();
    }

    public JQXXX get(String key){
        return this.getById(key);
    }


    public boolean create(JQXXX po){
        return this.save((T_JQXXXImpl)po);
    }

    public boolean update(JQXXX po){
        return this.updateById((T_JQXXXImpl)po);
    }

    public boolean remove(String key){
        return this.removeById(key);
    }

    public Page<JQXXX> searchDefault(JQXXXSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<JQXXX> page_datas=t_JQXXXMapper.searchDefault(page,context,qw);
        List<JQXXX> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<JQXXX>(list_datas, context.getPageable(), page_datas.getTotal());
    }


    public com.sinosig.core.module.domain.JQXXX convert2Domain( JQXXX po ,com.sinosig.core.module.domain.JQXXX domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module.domain.JQXXX();
              }
            //if(po.getJQXXXIdDirtyFlag())
                domain.setJQXXXId(po.getJQXXXId());
            //if(po.getFlxsDirtyFlag())
                domain.setFlxs(po.getFlxs());
            //if(po.getJzbfDirtyFlag())
                domain.setJzbf(po.getJzbf());
            //if(po.getSjbfDirtyFlag())
                domain.setSjbf(po.getSjbf());
            //if(po.getZrxeDirtyFlag())
                domain.setZrxe(po.getZrxe());
            //if(po.getJQXXXNameDirtyFlag())
                domain.setJQXXXName(po.getJQXXXName());
            //if(po.getUpdateDateDirtyFlag())
                domain.setUpdateDate(po.getUpdateDate());
            //if(po.getCreateManDirtyFlag())
                domain.setCreateMan(po.getCreateMan());
            //if(po.getTkdmDirtyFlag())
                domain.setTkdm(po.getTkdm());
            //if(po.getCreateDateDirtyFlag())
                domain.setCreateDate(po.getCreateDate());
            //if(po.getTkmcDirtyFlag())
                domain.setTkmc(po.getTkmc());
            //if(po.getUpdateManDirtyFlag())
                domain.setUpdateMan(po.getUpdateMan());
            //if(po.getCIDIdDirtyFlag())
                domain.setCIDId(po.getCIDId());
              return domain ;
    }

    public JQXXX convert2PO(com.sinosig.core.module.domain.JQXXX domain , JQXXX po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getJQXXXIdDirtyFlag())
            po.setJQXXXId(domain.getJQXXXId());
        if(domain.getFlxsDirtyFlag())
            po.setFlxs(domain.getFlxs());
        if(domain.getJzbfDirtyFlag())
            po.setJzbf(domain.getJzbf());
        if(domain.getSjbfDirtyFlag())
            po.setSjbf(domain.getSjbf());
        if(domain.getZrxeDirtyFlag())
            po.setZrxe(domain.getZrxe());
        if(domain.getJQXXXNameDirtyFlag())
            po.setJQXXXName(domain.getJQXXXName());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getTkdmDirtyFlag())
            po.setTkdm(domain.getTkdm());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getTkmcDirtyFlag())
            po.setTkmc(domain.getTkmc());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getCIDIdDirtyFlag())
            po.setCIDId(domain.getCIDId());

        return po ;
    }
}
