package com.sinosig.mybatis.module;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import com.sinosig.core.repository.JQXTBYDRepository;
import com.sinosig.core.repository.po.JQXTBYD;
import com.sinosig.core.module.filter.JQXTBYDSearchContext;
import com.sinosig.mybatis.module.mapper.T_JQXTBYDMapper;
import com.sinosig.mybatis.module.po.T_JQXTBYDImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosig.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_JQXTBYD] 存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "jqxtbyd", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_JQXTBYDRepositoryImpl extends ServiceImpl<T_JQXTBYDMapper, T_JQXTBYDImpl> implements JQXTBYDRepository {

    @Autowired
    QueryBuilder queryBuilder;

    private boolean isLogicValid = false ;

    @Autowired
	T_JQXTBYDMapper t_JQXTBYDMapper;

    public JQXTBYD createPO(){
        return new T_JQXTBYDImpl();
    }

    public JQXTBYD get(String key){
        return this.getById(key);
    }


    public boolean create(JQXTBYD po){
        return this.save((T_JQXTBYDImpl)po);
    }

    public boolean update(JQXTBYD po){
        return this.updateById((T_JQXTBYDImpl)po);
    }

    public boolean remove(String key){
        return this.removeById(key);
    }

    public Page<JQXTBYD> searchDefault(JQXTBYDSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<JQXTBYD> page_datas=t_JQXTBYDMapper.searchDefault(page,context,qw);
        List<JQXTBYD> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<JQXTBYD>(list_datas, context.getPageable(), page_datas.getTotal());
    }


    public com.sinosig.core.module.domain.JQXTBYD convert2Domain( JQXTBYD po ,com.sinosig.core.module.domain.JQXTBYD domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module.domain.JQXTBYD();
              }
            //if(po.getTymcDirtyFlag())
                domain.setTymc(po.getTymc());
            //if(po.getCreateManDirtyFlag())
                domain.setCreateMan(po.getCreateMan());
            //if(po.getJQXTBYDNameDirtyFlag())
                domain.setJQXTBYDName(po.getJQXTBYDName());
            //if(po.getUpdateManDirtyFlag())
                domain.setUpdateMan(po.getUpdateMan());
            //if(po.getCreateDateDirtyFlag())
                domain.setCreateDate(po.getCreateDate());
            //if(po.getTynrDirtyFlag())
                domain.setTynr(po.getTynr());
            //if(po.getJQXTBYDIdDirtyFlag())
                domain.setJQXTBYDId(po.getJQXTBYDId());
            //if(po.getXhDirtyFlag())
                domain.setXh(po.getXh());
            //if(po.getUpdateDateDirtyFlag())
                domain.setUpdateDate(po.getUpdateDate());
            //if(po.getTBYDKNameDirtyFlag())
                domain.setTBYDKName(po.getTBYDKName());
            //if(po.getTBYDKIdDirtyFlag())
                domain.setTBYDKId(po.getTBYDKId());
            //if(po.getCIDIdDirtyFlag())
                domain.setCIDId(po.getCIDId());
              return domain ;
    }

    public JQXTBYD convert2PO(com.sinosig.core.module.domain.JQXTBYD domain , JQXTBYD po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getTymcDirtyFlag())
            po.setTymc(domain.getTymc());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getJQXTBYDNameDirtyFlag())
            po.setJQXTBYDName(domain.getJQXTBYDName());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getTynrDirtyFlag())
            po.setTynr(domain.getTynr());
        if(domain.getJQXTBYDIdDirtyFlag())
            po.setJQXTBYDId(domain.getJQXTBYDId());
        if(domain.getXhDirtyFlag())
            po.setXh(domain.getXh());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getTBYDKNameDirtyFlag())
            po.setTBYDKName(domain.getTBYDKName());
        if(domain.getTBYDKIdDirtyFlag())
            po.setTBYDKId(domain.getTBYDKId());
        if(domain.getCIDIdDirtyFlag())
            po.setCIDId(domain.getCIDId());

        return po ;
    }
}
