package com.sinosig.mybatis.module;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import com.sinosig.core.repository.SJZDXRepository;
import com.sinosig.core.repository.po.SJZDX;
import com.sinosig.core.module.filter.SJZDXSearchContext;
import com.sinosig.mybatis.module.mapper.T_SJZDXMapper;
import com.sinosig.mybatis.module.po.T_SJZDXImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosig.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_SJZDX] 存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "sjzdx", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_SJZDXRepositoryImpl extends ServiceImpl<T_SJZDXMapper, T_SJZDXImpl> implements SJZDXRepository {

    @Autowired
    QueryBuilder queryBuilder;

    private boolean isLogicValid = false ;

    @Autowired
	T_SJZDXMapper t_SJZDXMapper;

    public SJZDX createPO(){
        return new T_SJZDXImpl();
    }

    public SJZDX get(String key){
        return this.getById(key);
    }


    public boolean create(SJZDX po){
        return this.save((T_SJZDXImpl)po);
    }

    public boolean update(SJZDX po){
        return this.updateById((T_SJZDXImpl)po);
    }

    public boolean remove(String key){
        return this.removeById(key);
    }

    public Page<SJZDX> searchCLZL(SJZDXSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<SJZDX> page_datas=t_SJZDXMapper.searchCLZL(page,context,qw);
        List<SJZDX> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<SJZDX>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    public Page<SJZDX> searchYWLY(SJZDXSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<SJZDX> page_datas=t_SJZDXMapper.searchYWLY(page,context,qw);
        List<SJZDX> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<SJZDX>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    public Page<SJZDX> searchCLDL(SJZDXSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<SJZDX> page_datas=t_SJZDXMapper.searchCLDL(page,context,qw);
        List<SJZDX> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<SJZDX>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    public Page<SJZDX> searchDefault(SJZDXSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<SJZDX> page_datas=t_SJZDXMapper.searchDefault(page,context,qw);
        List<SJZDX> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<SJZDX>(list_datas, context.getPageable(), page_datas.getTotal());
    }


    public com.sinosig.core.module.domain.SJZDX convert2Domain( SJZDX po ,com.sinosig.core.module.domain.SJZDX domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module.domain.SJZDX();
              }
            //if(po.getNameDirtyFlag())
                domain.setName(po.getName());
            //if(po.getCreateManDirtyFlag())
                domain.setCreateMan(po.getCreateMan());
            //if(po.getPnameDirtyFlag())
                domain.setPname(po.getPname());
            //if(po.getSJZDXIdDirtyFlag())
                domain.setSJZDXId(po.getSJZDXId());
            //if(po.getSJZDXNameDirtyFlag())
                domain.setSJZDXName(po.getSJZDXName());
            //if(po.getUpdateManDirtyFlag())
                domain.setUpdateMan(po.getUpdateMan());
            //if(po.getCodeDirtyFlag())
                domain.setCode(po.getCode());
            //if(po.getUpdateDateDirtyFlag())
                domain.setUpdateDate(po.getUpdateDate());
            //if(po.getCreateDateDirtyFlag())
                domain.setCreateDate(po.getCreateDate());
            //if(po.getPcodeDirtyFlag())
                domain.setPcode(po.getPcode());
            //if(po.getSJZDIdDirtyFlag())
                domain.setSJZDId(po.getSJZDId());
              return domain ;
    }

    public SJZDX convert2PO(com.sinosig.core.module.domain.SJZDX domain , SJZDX po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getNameDirtyFlag())
            po.setName(domain.getName());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getPnameDirtyFlag())
            po.setPname(domain.getPname());
        if(domain.getSJZDXIdDirtyFlag())
            po.setSJZDXId(domain.getSJZDXId());
        if(domain.getSJZDXNameDirtyFlag())
            po.setSJZDXName(domain.getSJZDXName());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getCodeDirtyFlag())
            po.setCode(domain.getCode());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getPcodeDirtyFlag())
            po.setPcode(domain.getPcode());
        if(domain.getSJZDIdDirtyFlag())
            po.setSJZDId(domain.getSJZDId());

        return po ;
    }
}
