package com.sinosig.mybatis.module;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import com.sinosig.core.repository.CIDRepository;
import com.sinosig.core.repository.po.CID;
import com.sinosig.core.module.filter.CIDSearchContext;
import com.sinosig.mybatis.module.mapper.T_CIDMapper;
import com.sinosig.mybatis.module.po.T_CIDImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosig.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_CID] 存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "cid", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_CIDRepositoryImpl extends ServiceImpl<T_CIDMapper, T_CIDImpl> implements CIDRepository {

    @Autowired
    QueryBuilder queryBuilder;

    private boolean isLogicValid = false ;

    @Autowired
	T_CIDMapper t_CIDMapper;

    public CID createPO(){
        return new T_CIDImpl();
    }

    public CID get(String key){
        return this.getById(key);
    }


    public boolean create(CID po){
        return this.save((T_CIDImpl)po);
    }

    public boolean update(CID po){
        return this.updateById((T_CIDImpl)po);
    }

    public boolean remove(String key){
        return this.removeById(key);
    }

    public Page<CID> searchDefault(CIDSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<CID> page_datas=t_CIDMapper.searchDefault(page,context,qw);
        List<CID> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<CID>(list_datas, context.getPageable(), page_datas.getTotal());
    }


    public com.sinosig.core.module.domain.CID convert2Domain( CID po ,com.sinosig.core.module.domain.CID domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module.domain.CID();
              }
            //if(po.getSyxdeDirtyFlag())
                domain.setSyxde(po.getSyxde());
            //if(po.getAblDirtyFlag())
                domain.setAbl(po.getAbl());
            //if(po.getFdjhDirtyFlag())
                domain.setFdjh(po.getFdjh());
            //if(po.getCIDDataDirtyFlag())
                domain.setCIDData(po.getCIDData());
            //if(po.getHpdsDirtyFlag())
                domain.setHpds(po.getHpds());
            //if(po.getCcs_jqxDirtyFlag())
                domain.setCcs_jqx(po.getCcs_jqx());
            //if(po.getSyxDirtyFlag())
                domain.setSyx(po.getSyx());
            //if(po.getHdzzlDirtyFlag())
                domain.setHdzzl(po.getHdzzl());
            //if(po.getUpdateDateDirtyFlag())
                domain.setUpdateDate(po.getUpdateDate());
            //if(po.getGlDirtyFlag())
                domain.setGl(po.getGl());
            //if(po.getCIDNameDirtyFlag())
                domain.setCIDName(po.getCIDName());
            //if(po.getQdlxDirtyFlag())
                domain.setQdlx(po.getQdlx());
            //if(po.getSyxdbDirtyFlag())
                domain.setSyxdb(po.getSyxdb());
            //if(po.getCreateDateDirtyFlag())
                domain.setCreateDate(po.getCreateDate());
            //if(po.getDycpxhDirtyFlag())
                domain.setDycpxh(po.getDycpxh());
            //if(po.getCldlDirtyFlag())
                domain.setCldl(po.getCldl());
            //if(po.getJqxDirtyFlag())
                domain.setJqx(po.getJqx());
            //if(po.getJqxdqflDirtyFlag())
                domain.setJqxdqfl(po.getJqxdqfl());
            //if(po.getHsbf_syxDirtyFlag())
                domain.setHsbf_syx(po.getHsbf_syx());
            //if(po.getSyxdqfsDirtyFlag())
                domain.setSyxdqfs(po.getSyxdqfs());
            //if(po.getHdzkDirtyFlag())
                domain.setHdzk(po.getHdzk());
            //if(po.getSyxzDirtyFlag())
                domain.setSyxz(po.getSyxz());
            //if(po.getCreateManDirtyFlag())
                domain.setCreateMan(po.getCreateMan());
            //if(po.getCllxmsDirtyFlag())
                domain.setCllxms(po.getCllxms());
            //if(po.getXcgzjDirtyFlag())
                domain.setXcgzj(po.getXcgzj());
            //if(po.getBhsbf_syxDirtyFlag())
                domain.setBhsbf_syx(po.getBhsbf_syx());
            //if(po.getJqxdbDirtyFlag())
                domain.setJqxdb(po.getJqxdb());
            //if(po.getClsjjzDirtyFlag())
                domain.setClsjjz(po.getClsjjz());
            //if(po.getSe_syxDirtyFlag())
                domain.setSe_syx(po.getSe_syx());
            //if(po.getHjDirtyFlag())
                domain.setHj(po.getHj());
            //if(po.getYwlyDirtyFlag())
                domain.setYwly(po.getYwly());
            //if(po.getHpzlDirtyFlag())
                domain.setHpzl(po.getHpzl());
            //if(po.getJqxdqfsDirtyFlag())
                domain.setJqxdqfs(po.getJqxdqfs());
            //if(po.getClzlDirtyFlag())
                domain.setClzl(po.getClzl());
            //if(po.getSyxdqflDirtyFlag())
                domain.setSyxdqfl(po.getSyxdqfl());
            //if(po.getCjhDirtyFlag())
                domain.setCjh(po.getCjh());
            //if(po.getCphmDirtyFlag())
                domain.setCphm(po.getCphm());
            //if(po.getPlDirtyFlag())
                domain.setPl(po.getPl());
            //if(po.getHsbf_jqxDirtyFlag())
                domain.setHsbf_jqx(po.getHsbf_jqx());
            //if(po.getJqxdeDirtyFlag())
                domain.setJqxde(po.getJqxde());
            //if(po.getCIDIdDirtyFlag())
                domain.setCIDId(po.getCIDId());
            //if(po.getBhsbf_jqxDirtyFlag())
                domain.setBhsbf_jqx(po.getBhsbf_jqx());
            //if(po.getUpdateManDirtyFlag())
                domain.setUpdateMan(po.getUpdateMan());
            //if(po.getCdrqDirtyFlag())
                domain.setCdrq(po.getCdrq());
            //if(po.getZbzlDirtyFlag())
                domain.setZbzl(po.getZbzl());
            //if(po.getSe_jqxDirtyFlag())
                domain.setSe_jqx(po.getSe_jqx());
            //if(po.getCPXHNameDirtyFlag())
                domain.setCPXHName(po.getCPXHName());
            //if(po.getORGUSERNameDirtyFlag())
                domain.setORGUSERName(po.getORGUSERName());
            //if(po.getORGNameDirtyFlag())
                domain.setORGName(po.getORGName());
            //if(po.getORGUSERIdDirtyFlag())
                domain.setORGUSERId(po.getORGUSERId());
            //if(po.getCPXHIdDirtyFlag())
                domain.setCPXHId(po.getCPXHId());
            //if(po.getORGIdDirtyFlag())
                domain.setORGId(po.getORGId());
              return domain ;
    }

    public CID convert2PO(com.sinosig.core.module.domain.CID domain , CID po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getSyxdeDirtyFlag())
            po.setSyxde(domain.getSyxde());
        if(domain.getAblDirtyFlag())
            po.setAbl(domain.getAbl());
        if(domain.getFdjhDirtyFlag())
            po.setFdjh(domain.getFdjh());
        if(domain.getCIDDataDirtyFlag())
            po.setCIDData(domain.getCIDData());
        if(domain.getHpdsDirtyFlag())
            po.setHpds(domain.getHpds());
        if(domain.getCcs_jqxDirtyFlag())
            po.setCcs_jqx(domain.getCcs_jqx());
        if(domain.getSyxDirtyFlag())
            po.setSyx(domain.getSyx());
        if(domain.getHdzzlDirtyFlag())
            po.setHdzzl(domain.getHdzzl());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getGlDirtyFlag())
            po.setGl(domain.getGl());
        if(domain.getCIDNameDirtyFlag())
            po.setCIDName(domain.getCIDName());
        if(domain.getQdlxDirtyFlag())
            po.setQdlx(domain.getQdlx());
        if(domain.getSyxdbDirtyFlag())
            po.setSyxdb(domain.getSyxdb());
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getDycpxhDirtyFlag())
            po.setDycpxh(domain.getDycpxh());
        if(domain.getCldlDirtyFlag())
            po.setCldl(domain.getCldl());
        if(domain.getJqxDirtyFlag())
            po.setJqx(domain.getJqx());
        if(domain.getJqxdqflDirtyFlag())
            po.setJqxdqfl(domain.getJqxdqfl());
        if(domain.getHsbf_syxDirtyFlag())
            po.setHsbf_syx(domain.getHsbf_syx());
        if(domain.getSyxdqfsDirtyFlag())
            po.setSyxdqfs(domain.getSyxdqfs());
        if(domain.getHdzkDirtyFlag())
            po.setHdzk(domain.getHdzk());
        if(domain.getSyxzDirtyFlag())
            po.setSyxz(domain.getSyxz());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getCllxmsDirtyFlag())
            po.setCllxms(domain.getCllxms());
        if(domain.getXcgzjDirtyFlag())
            po.setXcgzj(domain.getXcgzj());
        if(domain.getBhsbf_syxDirtyFlag())
            po.setBhsbf_syx(domain.getBhsbf_syx());
        if(domain.getJqxdbDirtyFlag())
            po.setJqxdb(domain.getJqxdb());
        if(domain.getClsjjzDirtyFlag())
            po.setClsjjz(domain.getClsjjz());
        if(domain.getSe_syxDirtyFlag())
            po.setSe_syx(domain.getSe_syx());
        if(domain.getHjDirtyFlag())
            po.setHj(domain.getHj());
        if(domain.getYwlyDirtyFlag())
            po.setYwly(domain.getYwly());
        if(domain.getHpzlDirtyFlag())
            po.setHpzl(domain.getHpzl());
        if(domain.getJqxdqfsDirtyFlag())
            po.setJqxdqfs(domain.getJqxdqfs());
        if(domain.getClzlDirtyFlag())
            po.setClzl(domain.getClzl());
        if(domain.getSyxdqflDirtyFlag())
            po.setSyxdqfl(domain.getSyxdqfl());
        if(domain.getCjhDirtyFlag())
            po.setCjh(domain.getCjh());
        if(domain.getCphmDirtyFlag())
            po.setCphm(domain.getCphm());
        if(domain.getPlDirtyFlag())
            po.setPl(domain.getPl());
        if(domain.getHsbf_jqxDirtyFlag())
            po.setHsbf_jqx(domain.getHsbf_jqx());
        if(domain.getJqxdeDirtyFlag())
            po.setJqxde(domain.getJqxde());
        if(domain.getCIDIdDirtyFlag())
            po.setCIDId(domain.getCIDId());
        if(domain.getBhsbf_jqxDirtyFlag())
            po.setBhsbf_jqx(domain.getBhsbf_jqx());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getCdrqDirtyFlag())
            po.setCdrq(domain.getCdrq());
        if(domain.getZbzlDirtyFlag())
            po.setZbzl(domain.getZbzl());
        if(domain.getSe_jqxDirtyFlag())
            po.setSe_jqx(domain.getSe_jqx());
        if(domain.getCPXHNameDirtyFlag())
            po.setCPXHName(domain.getCPXHName());
        if(domain.getORGUSERNameDirtyFlag())
            po.setORGUSERName(domain.getORGUSERName());
        if(domain.getORGNameDirtyFlag())
            po.setORGName(domain.getORGName());
        if(domain.getORGUSERIdDirtyFlag())
            po.setORGUSERId(domain.getORGUSERId());
        if(domain.getCPXHIdDirtyFlag())
            po.setCPXHId(domain.getCPXHId());
        if(domain.getORGIdDirtyFlag())
            po.setORGId(domain.getORGId());

        return po ;
    }
}
