import qs from 'qs';
import { MockAdapter } from '@/mock/mock-adapter';
const mock = MockAdapter.getInstance();

// 模拟数据
const mockDatas: Array<any> = [
    {"tymc":null,"tbydkid":"1","tbydkname":"Test","createdate":"2020-03-09 10:48:09","updateman":"示例操作者","lb":null,"updatedate":"2020-03-09 10:48:09","tynr":null,"createman":"示例操作者","srfkey":"1"},
    {"tymc":null,"tbydkid":"2","tbydkname":"Test(1)","createdate":"2020-03-09 10:48:09","updateman":"示例操作者","lb":null,"updatedate":"2020-03-09 10:48:09","tynr":null,"createman":"示例操作者","srfkey":"2"},
    {"tymc":null,"tbydkid":"3","tbydkname":"Test(2)","createdate":"2020-03-09 10:48:09","updateman":"示例操作者","lb":null,"updatedate":"2020-03-09 10:48:09","tynr":null,"createman":"示例操作者","srfkey":"3"}
];


        
// Create
mock.onPost(new RegExp(/^\/tbydks\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['tbydkid'];
    const matchArray:any = new RegExp(/^\/tbydks\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    return [status, mockDatas[0]];
});

// Get
mock.onGet(new RegExp(/^\/tbydks\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['tbydkid'];
    const matchArray:any = new RegExp(/^\/tbydks\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.tbydkid, tempValue.tbydkid));
    return [status, _items?_items:{}];
});

        
// Update
mock.onPut(new RegExp(/^\/tbydks\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['tbydkid'];
    const matchArray:any = new RegExp(/^\/tbydks\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.tbydkid, tempValue.tbydkid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['tbydkid'] == tempValue['tbydkid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

        
// CheckKey
mock.onPost(new RegExp(/^\/tbydks\/?([a-zA-Z0-9\-\;]{0,35})\/checkkey$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['tbydkid'];
    const matchArray:any = new RegExp(/^\/tbydks\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.tbydkid, tempValue.tbydkid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['tbydkid'] == tempValue['tbydkid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

        
// Save
mock.onPost(new RegExp(/^\/tbydks\/?([a-zA-Z0-9\-\;]{0,35})\/save$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['tbydkid'];
    const matchArray:any = new RegExp(/^\/tbydks\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.tbydkid, tempValue.tbydkid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['tbydkid'] == tempValue['tbydkid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});


// GetDraft
mock.onGet(new RegExp(/^\/tbydks\/getdraft$/)).reply((config: any) => {
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, {
    }];
});

// Remove
mock.onDelete(new RegExp(/^\/tbydks\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['tbydkid'];
    const matchArray:any = new RegExp(/^\/tbydks\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.tbydkid, tempValue.tbydkid));
    return [status, _items?_items:{}];
});

    
// FetchDefault
mock.onGet(new RegExp(/^\/tbydks\/fetchdefault$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, mockDatas ? mockDatas : []];
});


// FetchDefault
mock.onGet(new RegExp(/^\/tbydks\/fetchdefault(\?[\w-./?%&=]*)*$/)).reply((config: any) => {
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if((config.page-1)*config.size < total){
      records = mockDatas.slice(config.page,config.size);
    }
    return [status, records ?  records : []];
});



    
// FetchJQX
mock.onGet(new RegExp(/^\/tbydks\/fetchjqx$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, mockDatas ? mockDatas : []];
});


// FetchJQX
mock.onGet(new RegExp(/^\/tbydks\/fetchjqx(\?[\w-./?%&=]*)*$/)).reply((config: any) => {
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if((config.page-1)*config.size < total){
      records = mockDatas.slice(config.page,config.size);
    }
    return [status, records ?  records : []];
});



    
// FetchSYX
mock.onGet(new RegExp(/^\/tbydks\/fetchsyx$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, mockDatas ? mockDatas : []];
});


// FetchSYX
mock.onGet(new RegExp(/^\/tbydks\/fetchsyx(\?[\w-./?%&=]*)*$/)).reply((config: any) => {
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if((config.page-1)*config.size < total){
      records = mockDatas.slice(config.page,config.size);
    }
    return [status, records ?  records : []];
});



// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现
