import qs from 'qs';
import { MockAdapter } from '@/mock/mock-adapter';
const mock = MockAdapter.getInstance();

// 模拟数据
const mockDatas: Array<any> = [
    {"orgid":"40","orgname":"Test","porgid":null,"porgname":null,"createdate":"2020-03-09 10:48:09","updateman":"示例操作者","updatedate":"2020-03-09 10:48:09","createman":"示例操作者","srfkey":"40"},
    {"orgid":"41","orgname":"Test(1)","porgid":null,"porgname":null,"createdate":"2020-03-09 10:48:09","updateman":"示例操作者","updatedate":"2020-03-09 10:48:09","createman":"示例操作者","srfkey":"41"},
    {"orgid":"42","orgname":"Test(2)","porgid":null,"porgname":null,"createdate":"2020-03-09 10:48:09","updateman":"示例操作者","updatedate":"2020-03-09 10:48:09","createman":"示例操作者","srfkey":"42"},
    {"orgid":"43","orgname":"Test(3)","porgid":null,"porgname":null,"createdate":"2020-03-09 10:48:09","updateman":"示例操作者","updatedate":"2020-03-09 10:48:09","createman":"示例操作者","srfkey":"43"},
    {"orgid":"44","orgname":"Test(4)","porgid":null,"porgname":null,"createdate":"2020-03-09 10:48:09","updateman":"示例操作者","updatedate":"2020-03-09 10:48:09","createman":"示例操作者","srfkey":"44"},
    {"orgid":"45","orgname":"Test(5)","porgid":null,"porgname":null,"createdate":"2020-03-09 10:48:09","updateman":"示例操作者","updatedate":"2020-03-09 10:48:09","createman":"示例操作者","srfkey":"45"}
];


    
// FetchTopOrg
mock.onGet(new RegExp(/^\/orgs\/fetchtoporg$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, mockDatas ? mockDatas : []];
});


// FetchTopOrg
mock.onGet(new RegExp(/^\/orgs\/fetchtoporg(\?[\w-./?%&=]*)*$/)).reply((config: any) => {
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if((config.page-1)*config.size < total){
      records = mockDatas.slice(config.page,config.size);
    }
    return [status, records ?  records : []];
});



    
// FetchCurOrg
mock.onGet(new RegExp(/^\/orgs\/fetchcurorg$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, mockDatas ? mockDatas : []];
});


// FetchCurOrg
mock.onGet(new RegExp(/^\/orgs\/fetchcurorg(\?[\w-./?%&=]*)*$/)).reply((config: any) => {
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if((config.page-1)*config.size < total){
      records = mockDatas.slice(config.page,config.size);
    }
    return [status, records ?  records : []];
});



        
// CheckKey
mock.onPost(new RegExp(/^\/orgs\/?([a-zA-Z0-9\-\;]{0,35})\/checkkey$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['orgid'];
    const matchArray:any = new RegExp(/^\/orgs\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.orgid, tempValue.orgid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['orgid'] == tempValue['orgid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

        
// Create
mock.onPost(new RegExp(/^\/orgs\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['orgid'];
    const matchArray:any = new RegExp(/^\/orgs\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    return [status, mockDatas[0]];
});

// Get
mock.onGet(new RegExp(/^\/orgs\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['orgid'];
    const matchArray:any = new RegExp(/^\/orgs\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.orgid, tempValue.orgid));
    return [status, _items?_items:{}];
});

        
// Save
mock.onPost(new RegExp(/^\/orgs\/?([a-zA-Z0-9\-\;]{0,35})\/save$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['orgid'];
    const matchArray:any = new RegExp(/^\/orgs\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.orgid, tempValue.orgid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['orgid'] == tempValue['orgid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

// Remove
mock.onDelete(new RegExp(/^\/orgs\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['orgid'];
    const matchArray:any = new RegExp(/^\/orgs\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.orgid, tempValue.orgid));
    return [status, _items?_items:{}];
});

        
// Update
mock.onPut(new RegExp(/^\/orgs\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['orgid'];
    const matchArray:any = new RegExp(/^\/orgs\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.orgid, tempValue.orgid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['orgid'] == tempValue['orgid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});


// GetDraft
mock.onGet(new RegExp(/^\/orgs\/getdraft$/)).reply((config: any) => {
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, {
    }];
});

    
// FetchDefault
mock.onGet(new RegExp(/^\/orgs\/fetchdefault$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, mockDatas ? mockDatas : []];
});


// FetchDefault
mock.onGet(new RegExp(/^\/orgs\/fetchdefault(\?[\w-./?%&=]*)*$/)).reply((config: any) => {
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if((config.page-1)*config.size < total){
      records = mockDatas.slice(config.page,config.size);
    }
    return [status, records ?  records : []];
});



// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现
