import qs from 'qs';
import { MockAdapter } from '@/mock/mock-adapter';
const mock = MockAdapter.getInstance();

// 模拟数据
const mockDatas: Array<any> = [
];


        
// Save
mock.onPost(new RegExp(/^\/dbds\/?([a-zA-Z0-9\-\;]{0,35})\/save$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['dbdid'];
    const matchArray:any = new RegExp(/^\/dbds\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.dbdid, tempValue.dbdid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['dbdid'] == tempValue['dbdid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

        
// Update
mock.onPut(new RegExp(/^\/dbds\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['dbdid'];
    const matchArray:any = new RegExp(/^\/dbds\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.dbdid, tempValue.dbdid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['dbdid'] == tempValue['dbdid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});


// GetDraft
mock.onGet(new RegExp(/^\/dbds\/getdraft$/)).reply((config: any) => {
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, {
    }];
});

        
// Create
mock.onPost(new RegExp(/^\/dbds\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['dbdid'];
    const matchArray:any = new RegExp(/^\/dbds\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    return [status, mockDatas[0]];
});

        
// CheckKey
mock.onPost(new RegExp(/^\/dbds\/?([a-zA-Z0-9\-\;]{0,35})\/checkkey$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['dbdid'];
    const matchArray:any = new RegExp(/^\/dbds\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.dbdid, tempValue.dbdid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['dbdid'] == tempValue['dbdid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

// Remove
mock.onDelete(new RegExp(/^\/dbds\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['dbdid'];
    const matchArray:any = new RegExp(/^\/dbds\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.dbdid, tempValue.dbdid));
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/dbds\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['dbdid'];
    const matchArray:any = new RegExp(/^\/dbds\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.dbdid, tempValue.dbdid));
    return [status, _items?_items:{}];
});

    
// FetchDefault
mock.onGet(new RegExp(/^\/dbds\/fetchdefault$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, mockDatas ? mockDatas : []];
});


// FetchDefault
mock.onGet(new RegExp(/^\/dbds\/fetchdefault(\?[\w-./?%&=]*)*$/)).reply((config: any) => {
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if((config.page-1)*config.size < total){
      records = mockDatas.slice(config.page,config.size);
    }
    return [status, records ?  records : []];
});



// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现
