import qs from 'qs';
import { MockAdapter } from '@/mock/mock-adapter';
const mock = MockAdapter.getInstance();

// 模拟数据
const mockDatas: Array<any> = [
    {"zbzl":null,"jqxde":null,"clzl":null,"jqxdqfs":null,"createdate":"2020-03-09 10:48:09","qdlx":null,"jqxdqfl":null,"updateman":"示例操作者","fdjh":null,"cdrq":null,"abl":null,"srfkey":"28","orgusername":null,"cidname":"Test","ywly":null,"orgid":null,"orgname":null,"hpzl":null,"jqxdb":null,"syx":null,"cidid":"28","cldl":null,"hdzk":null,"cllxms":null,"orguserid":null,"syxde":null,"syxdb":null,"dycpxh":null,"cpxhid":null,"clsjjz":null,"hdzzl":null,"jqx":null,"syxdqfl":null,"xcgzj":null,"gl":null,"syxz":null,"cphm":null,"cjh":null,"pl":null,"cpxhname":null,"syxdqfs":null,"hpds":null,"updatedate":"2020-03-09 10:48:09","createman":"示例操作者"},
    {"zbzl":null,"jqxde":null,"clzl":null,"jqxdqfs":null,"createdate":"2020-03-09 10:48:09","qdlx":null,"jqxdqfl":null,"updateman":"示例操作者","fdjh":null,"cdrq":null,"abl":null,"srfkey":"29","orgusername":null,"cidname":"Test(1)","ywly":null,"orgid":null,"orgname":null,"hpzl":null,"jqxdb":null,"syx":null,"cidid":"29","cldl":null,"hdzk":null,"cllxms":null,"orguserid":null,"syxde":null,"syxdb":null,"dycpxh":null,"cpxhid":null,"clsjjz":null,"hdzzl":null,"jqx":null,"syxdqfl":null,"xcgzj":null,"gl":null,"syxz":null,"cphm":null,"cjh":null,"pl":null,"cpxhname":null,"syxdqfs":null,"hpds":null,"updatedate":"2020-03-09 10:48:09","createman":"示例操作者"},
    {"zbzl":null,"jqxde":null,"clzl":null,"jqxdqfs":null,"createdate":"2020-03-09 10:48:09","qdlx":null,"jqxdqfl":null,"updateman":"示例操作者","fdjh":null,"cdrq":null,"abl":null,"srfkey":"30","orgusername":null,"cidname":"Test(2)","ywly":null,"orgid":null,"orgname":null,"hpzl":null,"jqxdb":null,"syx":null,"cidid":"30","cldl":null,"hdzk":null,"cllxms":null,"orguserid":null,"syxde":null,"syxdb":null,"dycpxh":null,"cpxhid":null,"clsjjz":null,"hdzzl":null,"jqx":null,"syxdqfl":null,"xcgzj":null,"gl":null,"syxz":null,"cphm":null,"cjh":null,"pl":null,"cpxhname":null,"syxdqfs":null,"hpds":null,"updatedate":"2020-03-09 10:48:09","createman":"示例操作者"},
    {"zbzl":null,"jqxde":null,"clzl":null,"jqxdqfs":null,"createdate":"2020-03-09 10:48:09","qdlx":null,"jqxdqfl":null,"updateman":"示例操作者","fdjh":null,"cdrq":null,"abl":null,"srfkey":"31","orgusername":null,"cidname":"Test(3)","ywly":null,"orgid":null,"orgname":null,"hpzl":null,"jqxdb":null,"syx":null,"cidid":"31","cldl":null,"hdzk":null,"cllxms":null,"orguserid":null,"syxde":null,"syxdb":null,"dycpxh":null,"cpxhid":null,"clsjjz":null,"hdzzl":null,"jqx":null,"syxdqfl":null,"xcgzj":null,"gl":null,"syxz":null,"cphm":null,"cjh":null,"pl":null,"cpxhname":null,"syxdqfs":null,"hpds":null,"updatedate":"2020-03-09 10:48:09","createman":"示例操作者"},
    {"zbzl":null,"jqxde":null,"clzl":null,"jqxdqfs":null,"createdate":"2020-03-09 10:48:09","qdlx":null,"jqxdqfl":null,"updateman":"示例操作者","fdjh":null,"cdrq":null,"abl":null,"srfkey":"32","orgusername":null,"cidname":"Test(4)","ywly":null,"orgid":null,"orgname":null,"hpzl":null,"jqxdb":null,"syx":null,"cidid":"32","cldl":null,"hdzk":null,"cllxms":null,"orguserid":null,"syxde":null,"syxdb":null,"dycpxh":null,"cpxhid":null,"clsjjz":null,"hdzzl":null,"jqx":null,"syxdqfl":null,"xcgzj":null,"gl":null,"syxz":null,"cphm":null,"cjh":null,"pl":null,"cpxhname":null,"syxdqfs":null,"hpds":null,"updatedate":"2020-03-09 10:48:09","createman":"示例操作者"},
    {"zbzl":null,"jqxde":null,"clzl":null,"jqxdqfs":null,"createdate":"2020-03-09 10:48:09","qdlx":null,"jqxdqfl":null,"updateman":"示例操作者","fdjh":null,"cdrq":null,"abl":null,"srfkey":"33","orgusername":null,"cidname":"Test(5)","ywly":null,"orgid":null,"orgname":null,"hpzl":null,"jqxdb":null,"syx":null,"cidid":"33","cldl":null,"hdzk":null,"cllxms":null,"orguserid":null,"syxde":null,"syxdb":null,"dycpxh":null,"cpxhid":null,"clsjjz":null,"hdzzl":null,"jqx":null,"syxdqfl":null,"xcgzj":null,"gl":null,"syxz":null,"cphm":null,"cjh":null,"pl":null,"cpxhname":null,"syxdqfs":null,"hpds":null,"updatedate":"2020-03-09 10:48:09","createman":"示例操作者"}
];


        
// CheckKey
mock.onPost(new RegExp(/^\/cids\/?([a-zA-Z0-9\-\;]{0,35})\/checkkey$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['cidid'];
    const matchArray:any = new RegExp(/^\/cids\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.cidid, tempValue.cidid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['cidid'] == tempValue['cidid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

        
// Create
mock.onPost(new RegExp(/^\/cids\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['cidid'];
    const matchArray:any = new RegExp(/^\/cids\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    return [status, mockDatas[0]];
});

// Get
mock.onGet(new RegExp(/^\/cids\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['cidid'];
    const matchArray:any = new RegExp(/^\/cids\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.cidid, tempValue.cidid));
    return [status, _items?_items:{}];
});


// GetDraft
mock.onGet(new RegExp(/^\/cids\/getdraft$/)).reply((config: any) => {
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, {
    }];
});

        
// Update
mock.onPut(new RegExp(/^\/cids\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['cidid'];
    const matchArray:any = new RegExp(/^\/cids\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.cidid, tempValue.cidid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['cidid'] == tempValue['cidid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

        
// Save
mock.onPost(new RegExp(/^\/cids\/?([a-zA-Z0-9\-\;]{0,35})\/save$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['cidid'];
    const matchArray:any = new RegExp(/^\/cids\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.cidid, tempValue.cidid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['cidid'] == tempValue['cidid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    return [status, data];
});

// Remove
mock.onDelete(new RegExp(/^\/cids\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['cidid'];
    const matchArray:any = new RegExp(/^\/cids\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.log('tempValue--------'+JSON.stringify(tempValue));
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.cidid, tempValue.cidid));
    return [status, _items?_items:{}];
});

    
// FetchDefault
mock.onGet(new RegExp(/^\/cids\/fetchdefault$/)).reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    return [status, mockDatas ? mockDatas : []];
});


// FetchDefault
mock.onGet(new RegExp(/^\/cids\/fetchdefault(\?[\w-./?%&=]*)*$/)).reply((config: any) => {
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if((config.page-1)*config.size < total){
      records = mockDatas.slice(config.page,config.size);
    }
    return [status, records ?  records : []];
});



// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现

// URI参数传递情况未实现
