package com.sinosig.mybatis.module;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Repository;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import com.sinosig.core.repository.TBYDKRepository;
import com.sinosig.core.repository.po.TBYDK;
import com.sinosig.core.module.filter.TBYDKSearchContext;
import com.sinosig.mybatis.module.mapper.T_TBYDKMapper;
import com.sinosig.mybatis.module.po.T_TBYDKImpl;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sinosig.mybatis.util.helper.QueryBuilder;


/**
 * 关系型数据实体表[T_TBYDK] 存储对象
 */
@Repository
@ConditionalOnProperty(prefix = "tbydk", value="store" , havingValue = "sql", matchIfMissing = true)
public class T_TBYDKRepositoryImpl extends ServiceImpl<T_TBYDKMapper, T_TBYDKImpl> implements TBYDKRepository {

    @Autowired
    QueryBuilder queryBuilder;

    private boolean isLogicValid = false ;

    @Autowired
	T_TBYDKMapper t_TBYDKMapper;

    public TBYDK createPO(){
        return new T_TBYDKImpl();
    }

    public TBYDK get(String key){
        return this.getById(key);
    }


    public boolean create(TBYDK po){
        return this.save((T_TBYDKImpl)po);
    }

    public boolean update(TBYDK po){
        return this.updateById((T_TBYDKImpl)po);
    }

    public boolean remove(String key){
        return this.removeById(key);
    }

    public Page<TBYDK> searchDefault(TBYDKSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<TBYDK> page_datas=t_TBYDKMapper.searchDefault(page,context,qw);
        List<TBYDK> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<TBYDK>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    public Page<TBYDK> searchJQX(TBYDKSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<TBYDK> page_datas=t_TBYDKMapper.searchJQX(page,context,qw);
        List<TBYDK> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<TBYDK>(list_datas, context.getPageable(), page_datas.getTotal());
    }

    public Page<TBYDK> searchSYX(TBYDKSearchContext context){
        QueryWrapper qw=queryBuilder.buildQueryWrapper(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page=queryBuilder.buildPage(context);
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<TBYDK> page_datas=t_TBYDKMapper.searchSYX(page,context,qw);
        List<TBYDK> list_datas=queryBuilder.page2List(page_datas);
        return new PageImpl<TBYDK>(list_datas, context.getPageable(), page_datas.getTotal());
    }


    public com.sinosig.core.module.domain.TBYDK convert2Domain( TBYDK po ,com.sinosig.core.module.domain.TBYDK domain){
              if(po == null)
                     return domain ;
              if(domain == null){
                     domain = new com.sinosig.core.module.domain.TBYDK();
              }
            //if(po.getCreateDateDirtyFlag())
                domain.setCreateDate(po.getCreateDate());
            //if(po.getTBYDKNameDirtyFlag())
                domain.setTBYDKName(po.getTBYDKName());
            //if(po.getUpdateDateDirtyFlag())
                domain.setUpdateDate(po.getUpdateDate());
            //if(po.getUpdateManDirtyFlag())
                domain.setUpdateMan(po.getUpdateMan());
            //if(po.getLbDirtyFlag())
                domain.setLb(po.getLb());
            //if(po.getCreateManDirtyFlag())
                domain.setCreateMan(po.getCreateMan());
            //if(po.getTynrDirtyFlag())
                domain.setTynr(po.getTynr());
            //if(po.getTymcDirtyFlag())
                domain.setTymc(po.getTymc());
            //if(po.getTBYDKIdDirtyFlag())
                domain.setTBYDKId(po.getTBYDKId());
              return domain ;
    }

    public TBYDK convert2PO(com.sinosig.core.module.domain.TBYDK domain , TBYDK po){
        if(domain == null)
            return po ;
        if(po==null){
            po = createPO() ;
        }
        if(domain.getCreateDateDirtyFlag())
            po.setCreateDate(domain.getCreateDate());
        if(domain.getTBYDKNameDirtyFlag())
            po.setTBYDKName(domain.getTBYDKName());
        if(domain.getUpdateDateDirtyFlag())
            po.setUpdateDate(domain.getUpdateDate());
        if(domain.getUpdateManDirtyFlag())
            po.setUpdateMan(domain.getUpdateMan());
        if(domain.getLbDirtyFlag())
            po.setLb(domain.getLb());
        if(domain.getCreateManDirtyFlag())
            po.setCreateMan(domain.getCreateMan());
        if(domain.getTynrDirtyFlag())
            po.setTynr(domain.getTynr());
        if(domain.getTymcDirtyFlag())
            po.setTymc(domain.getTymc());
        if(domain.getTBYDKIdDirtyFlag())
            po.setTBYDKId(domain.getTBYDKId());

        return po ;
    }
}
