package com.sinosig.job;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;

import java.util.List;
import java.util.ArrayList;

import com.sinosig.util.config.SysInfoProperties;
import com.sinosig.util.feign.FeignRequestInterceptor;
import com.sinosig.util.config.UniWFClientProperties;
import com.sinosig.util.feign.UniWFFeignClient;
import com.sinosig.util.domain.PSDEWF;
import com.sinosig.util.domain.PSDataEntity;
import com.sinosig.util.domain.PSSystem;
import com.sinosig.util.domain.PSWorkflow;
import com.sinosig.util.domain.WFEngine;
import com.sinosig.util.domain.WFMode;
import com.sinosig.util.domain.Workflow;

/**
 *
 */
@Component
public class WFJob implements ApplicationRunner {

    UniWFFeignClient uniWFFeignClient;

    @Autowired
    SysInfoProperties sysInfoProperties;

    @Autowired
    public WFJob(Decoder decoder, Encoder encoder, Client client, Contract contract, FeignRequestInterceptor feignRequestInterceptor, UniWFClientProperties uniWFClientProperties) {
        if (uniWFClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class,"http://" + uniWFClientProperties.getServiceId() + "/") ;
		} else if (uniWFClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(encoder)
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.uniWFFeignClient = nameBuilder.target(UniWFFeignClient.class, "http://" + uniWFClientProperties.getServiceUrl() + "/") ;
		}
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        // 注册统一工作流（域注册）
        Workflow workflow = new Workflow();
        workflow.setWorkflowid(sysInfoProperties.getDomainid());
        workflow.setWorkflowname(sysInfoProperties.getDomainname());
        workflow.setLogicname(sysInfoProperties.getDomainlogicname());
        uniWFFeignClient.registDomain(workflow);

        // 注册工作流引擎
        List<WFEngine> wfengines = new ArrayList<WFEngine>();
        WFEngine wfengine1 = new WFEngine();
        wfengine1.setWfengineid("ACTIVITI");
        wfengine1.setWfenginename("ACTIVITI");
        wfengine1.setWfenginetype("ACTIVITI");
        wfengine1.setLogicname("ACTIVITI");
        wfengines.add(wfengine1);
        uniWFFeignClient.registWFEngine(wfengines);

        // 注册业务系统（部署系统）
        PSSystem pssystem = new PSSystem();
        pssystem.setPssystemid(sysInfoProperties.getSystemid());
        pssystem.setPssystemName(sysInfoProperties.getSystemname());
        pssystem.setWorkflowid(sysInfoProperties.getDomainid());
        pssystem.setServiceid(sysInfoProperties.getServiceid());
        pssystem.setServiceurl(sysInfoProperties.getServiceurl());
        pssystem.setLogicname(sysInfoProperties.getSystemlogicname());
        uniWFFeignClient.registPSSystem(pssystem);

        // 注册业务工作流
        List<PSWorkflow> psworkflows = new ArrayList<PSWorkflow>();
        PSWorkflow psworkflow0 = new PSWorkflow();
        psworkflow0.setPsworkflowid("ba7faf1a90a8e407c7c1740550a71255");
        psworkflow0.setPsworkflowname("QJ");
        psworkflow0.setLogicname("请假");
        psworkflow0.setWorkflowid(sysInfoProperties.getDomainid());
        psworkflow0.setPssystemid(sysInfoProperties.getSystemid());
        psworkflow0.setWfenginetype("ACTIVITI");
        psworkflows.add(psworkflow0);
        uniWFFeignClient.registPSWorkflow(psworkflows);

        // 注册业务实体
        List<PSDataEntity> psdataentities = new ArrayList<PSDataEntity>();
        uniWFFeignClient.registPSDataEntity(psdataentities);

        // 注册业务实体工作流
        List<PSDEWF> psdewfs = new ArrayList<PSDEWF>();
        uniWFFeignClient.registPSDEWF(psdewfs);

        // 注册业务工作流模式
    }
}
