package com.sinosig.client.usermgr.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import com.sinosig.core.client.model.IORGUSER;
import com.sinosig.client.usermgr.config.UserMgrClientProperties;
import com.sinosig.core.client.service.IORGUSERClientService;
import com.sinosig.client.usermgr.model.ORGUSERImpl;
import com.sinosig.client.usermgr.feign.ORGUSERFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import com.sinosig.util.feign.FeignRequestInterceptor;
import com.sinosig.util.SearchContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import com.sinosig.util.feign.suport.SearchContextFeignEncode;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

/**
 * 实体[ORGUSER] 服务对象接口
 */
@Service
public class ORGUSERClientServiceImpl implements IORGUSERClientService {

    ORGUSERFeignClient oRGUSERFeignClient;

    @Autowired
    public ORGUSERClientServiceImpl(Decoder decoder, Encoder encoder, Client client, Contract contract ,FeignRequestInterceptor feignRequestInterceptor,UserMgrClientProperties usermgrClientProperties) {
        if (usermgrClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.oRGUSERFeignClient = nameBuilder.target(ORGUSERFeignClient.class,"http://"+usermgrClientProperties.getServiceId()+"/") ;
		}else if (usermgrClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.oRGUSERFeignClient = nameBuilder.target(ORGUSERFeignClient.class,"http://"+usermgrClientProperties.getServiceUrl()+"/") ;
		}
    }
    @Override
    public IORGUSER createModel() {
		return new ORGUSERImpl();
	}


    public void get(IORGUSER orguser){
        IORGUSER clientModel = oRGUSERFeignClient.get(orguser.getORGUSERId()) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), orguser.getClass(), false);
        copier.copy(clientModel, orguser, null);
    }


    public void update(IORGUSER orguser){
        IORGUSER clientModel = oRGUSERFeignClient.update(orguser.getORGUSERId(),(ORGUSERImpl)orguser) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), orguser.getClass(), false);
        copier.copy(clientModel, orguser, null);
    }


    public void create(IORGUSER orguser){
        IORGUSER clientModel = oRGUSERFeignClient.create((ORGUSERImpl)orguser) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), orguser.getClass(), false);
        copier.copy(clientModel, orguser, null);
    }


    public void remove(IORGUSER orguser){
        oRGUSERFeignClient.remove(orguser.getORGUSERId()) ;
    }


    public Page<IORGUSER> fetchDefault(SearchContext context){
        Page<ORGUSERImpl> page = this.oRGUSERFeignClient.fetchDefault(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }


    public Page<IORGUSER> fetchCurOrgUser(SearchContext context){
        Page<ORGUSERImpl> page = this.oRGUSERFeignClient.fetchCurOrgUser(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }


    public Page<IORGUSER> select(SearchContext context){
        return null ;
    }


    public void getDraft(IORGUSER orguser){
        IORGUSER clientModel = oRGUSERFeignClient.getDraft((ORGUSERImpl)orguser) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), orguser.getClass(), false);
        copier.copy(clientModel, orguser, null);
    }


    public void checkKey(IORGUSER orguser){
        IORGUSER clientModel = oRGUSERFeignClient.checkKey((ORGUSERImpl)orguser) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), orguser.getClass(), false);
        copier.copy(clientModel, orguser, null);
    }


    public void save(IORGUSER orguser){
        IORGUSER clientModel = oRGUSERFeignClient.save((ORGUSERImpl)orguser) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), orguser.getClass(), false);
        copier.copy(clientModel, orguser, null);
    }



}

