package com.sinosig.client.usermgr.service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import com.sinosig.core.client.model.IORG;
import com.sinosig.client.usermgr.config.UserMgrClientProperties;
import com.sinosig.core.client.service.IORGClientService;
import com.sinosig.client.usermgr.model.ORGImpl;
import com.sinosig.client.usermgr.feign.ORGFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import com.sinosig.util.feign.FeignRequestInterceptor;
import com.sinosig.util.SearchContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import com.sinosig.util.feign.suport.SearchContextFeignEncode;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;

/**
 * 实体[ORG] 服务对象接口
 */
@Service
public class ORGClientServiceImpl implements IORGClientService {

    ORGFeignClient oRGFeignClient;

    @Autowired
    public ORGClientServiceImpl(Decoder decoder, Encoder encoder, Client client, Contract contract ,FeignRequestInterceptor feignRequestInterceptor,UserMgrClientProperties usermgrClientProperties) {
        if (usermgrClientProperties.getServiceId()!=null) {
    		Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.oRGFeignClient = nameBuilder.target(ORGFeignClient.class,"http://"+usermgrClientProperties.getServiceId()+"/") ;
		}else if (usermgrClientProperties.getServiceUrl()!=null) {
			if (client instanceof LoadBalancerFeignClient) {
				client = ((LoadBalancerFeignClient) client).getDelegate();
			}
			Feign.Builder nameBuilder = Feign.builder()
                    .client(client)
                    .encoder(new SearchContextFeignEncode(encoder))
                    .decoder(decoder)
                    .contract(contract)
                    .requestInterceptor(feignRequestInterceptor)
                    ;
        	this.oRGFeignClient = nameBuilder.target(ORGFeignClient.class,"http://"+usermgrClientProperties.getServiceUrl()+"/") ;
		}
    }
    @Override
    public IORG createModel() {
		return new ORGImpl();
	}


    public Page<IORG> fetchTopOrg(SearchContext context){
        Page<ORGImpl> page = this.oRGFeignClient.fetchTopOrg(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }


    public Page<IORG> fetchDefault(SearchContext context){
        Page<ORGImpl> page = this.oRGFeignClient.fetchDefault(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }


    public void update(IORG org){
        IORG clientModel = oRGFeignClient.update(org.getORGId(),(ORGImpl)org) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), org.getClass(), false);
        copier.copy(clientModel, org, null);
    }


    public Page<IORG> fetchCurOrg(SearchContext context){
        Page<ORGImpl> page = this.oRGFeignClient.fetchCurOrg(context) ;
        return new PageImpl(page.getContent(),context.getPageable(),page.getTotalElements());
    }


    public void remove(IORG org){
        oRGFeignClient.remove(org.getORGId()) ;
    }


    public void get(IORG org){
        IORG clientModel = oRGFeignClient.get(org.getORGId()) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), org.getClass(), false);
        copier.copy(clientModel, org, null);
    }


    public void create(IORG org){
        IORG clientModel = oRGFeignClient.create((ORGImpl)org) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), org.getClass(), false);
        copier.copy(clientModel, org, null);
    }


    public void checkKey(IORG org){
        IORG clientModel = oRGFeignClient.checkKey((ORGImpl)org) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), org.getClass(), false);
        copier.copy(clientModel, org, null);
    }


    public void save(IORG org){
        IORG clientModel = oRGFeignClient.save((ORGImpl)org) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), org.getClass(), false);
        copier.copy(clientModel, org, null);
    }


    public void getDraft(IORG org){
        IORG clientModel = oRGFeignClient.getDraft((ORGImpl)org) ;
        BeanCopier copier=BeanCopier.create(clientModel.getClass(), org.getClass(), false);
        copier.copy(clientModel, org, null);
    }



}

